@extends('layouts.modern')

@section('title', 'عرض الإشعار')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">تفاصيل الإشعار</h5>
                    <div>
                        <a href="{{ route('notifications.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <div class="notification-details">
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <h4 class="notification-title">{{ $notification->title }}</h4>
                                <div class="notification-meta">
                                    <span class="badge 
                                        @if ($notification->priority == 'low') badge-secondary
                                        @elseif ($notification->priority == 'normal') badge-info
                                        @elseif ($notification->priority == 'high') badge-warning
                                        @elseif ($notification->priority == 'urgent') badge-danger
                                        @endif">
                                        {{ $notification->priority == 'low' ? 'منخفضة' : 
                                           ($notification->priority == 'normal' ? 'عادية' : 
                                           ($notification->priority == 'high' ? 'عالية' : 'عاجلة')) }}
                                    </span>
                                    <span class="badge 
                                        @if ($notification->type == 'maintenance_due') badge-info
                                        @elseif ($notification->type == 'maintenance_urgent') badge-warning
                                        @elseif ($notification->type == 'maintenance_today') badge-primary
                                        @elseif ($notification->type == 'maintenance_overdue') badge-danger
                                        @elseif ($notification->type == 'maintenance_critical_overdue') badge-danger
                                        @elseif ($notification->type == 'contract_expiring') badge-warning
                                        @else badge-secondary
                                        @endif">
                                        @if ($notification->type == 'maintenance_due')
                                            صيانة مستحقة
                                        @elseif ($notification->type == 'maintenance_urgent')
                                            صيانة عاجلة
                                        @elseif ($notification->type == 'maintenance_today')
                                            صيانة اليوم
                                        @elseif ($notification->type == 'maintenance_overdue')
                                            صيانة متأخرة
                                        @elseif ($notification->type == 'maintenance_critical_overdue')
                                            صيانة متأخرة بشكل حرج
                                        @elseif ($notification->type == 'contract_expiring')
                                            عقد على وشك الانتهاء
                                        @else
                                            {{ $notification->type }}
                                        @endif
                                    </span>
                                    <span class="badge 
                                        @if ($notification->read_at) badge-success
                                        @elseif ($notification->sent_at) badge-info
                                        @else badge-warning
                                        @endif">
                                        {{ $notification->read_at ? 'مقروء' : 
                                           ($notification->sent_at ? 'تم الإرسال' : 'معلق') }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <p><strong>تاريخ الإنشاء:</strong> {{ $notification->created_at->format('Y-m-d H:i') }}</p>
                                @if ($notification->sent_at)
                                    <p><strong>تاريخ الإرسال:</strong> {{ $notification->sent_at->format('Y-m-d H:i') }}</p>
                                @endif
                                @if ($notification->read_at)
                                    <p><strong>تاريخ القراءة:</strong> {{ $notification->read_at->format('Y-m-d H:i') }}</p>
                                @endif
                            </div>
                            <div class="col-md-6">
                                @if ($notification->user)
                                    <p><strong>المستخدم:</strong> {{ $notification->user->name }}</p>
                                @endif
                                <p><strong>الشركة:</strong> {{ $notification->company->name }}</p>
                            </div>
                        </div>

                        <div class="row mb-4">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">محتوى الإشعار</h6>
                                    </div>
                                    <div class="card-body">
                                        <p class="notification-message">{{ $notification->message }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @php
                            // Ensure data is an array before accessing it
                            $notificationData = [];
                            if ($notification->data) {
                                $notificationData = is_array($notification->data) ? $notification->data : json_decode($notification->data, true);
                                $notificationData = is_array($notificationData) ? $notificationData : [];
                            }
                        @endphp
                        
                        @if (!empty($notificationData))
                            <div class="row mb-4">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h6 class="mb-0">بيانات إضافية</h6>
                                        </div>
                                        <div class="card-body">
                                            
                                            @if (isset($notificationData['details']))
                                                <div class="alert alert-info">
                                                    <h6 class="alert-heading">تفاصيل الصيانة</h6>
                                                    <pre class="mb-0" style="white-space: pre-wrap; font-family: inherit;">{{ $notificationData['details'] }}</pre>
                                                </div>
                                            @endif
                                            
                                            @if (isset($notificationData['requires_immediate_action']) && $notificationData['requires_immediate_action'])
                                                <div class="alert alert-danger">
                                                    <h6 class="alert-heading">تنبيه هام</h6>
                                                    <p>هذه الصيانة تتطلب إجراء فوري!</p>
                                                </div>
                                            @endif
                                            
                                            <div class="table-responsive">
                                                <table class="table table-bordered">
                                                    <tbody>
                                                        
                                                        @foreach ($notificationData as $key => $value)
                                                            @if (!in_array($key, ['details', 'requires_immediate_action']))
                                                                <tr>
                                                                    <th>
                                                                        @if ($key == 'schedule_id')
                                                                            رقم الجدولة
                                                                        @elseif ($key == 'elevator_id')
                                                                            رقم المصعد
                                                                        @elseif ($key == 'contract_id')
                                                                            رقم العقد
                                                                        @elseif ($key == 'scheduled_date')
                                                                            تاريخ الصيانة
                                                                        @elseif ($key == 'days_until_maintenance')
                                                                            الأيام المتبقية
                                                                        @elseif ($key == 'days_overdue')
                                                                            أيام التأخير
                                                                        @elseif ($key == 'customer')
                                                                            العميل
                                                                        @elseif ($key == 'location')
                                                                            الموقع
                                                                        @elseif ($key == 'contract_number')
                                                                            رقم العقد
                                                                        @elseif ($key == 'severity')
                                                                            مستوى الخطورة
                                                                        @elseif ($key == 'is_today')
                                                                            اليوم
                                                                        @else
                                                                            {{ $key }}
                                                                        @endif
                                                                    </th>
                                                                    <td>{{ $value }}</td>
                                                                </tr>
                                                            @endif
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                            
                                            @if (isset($notificationData['schedule_id']))
                                                <div class="mt-3">
                                                    <a href="{{ route('maintenance-schedules.show', $notificationData['schedule_id']) }}" class="btn btn-primary">
                                                        <i class="fas fa-calendar-check"></i> عرض جدولة الصيانة
                                                    </a>
                                                </div>
                                            @endif
                                            
                                            @if (isset($notificationData['elevator_id']))
                                                <div class="mt-2">
                                                    <a href="{{ route('elevators.show', $notificationData['elevator_id']) }}" class="btn btn-info">
                                                        <i class="fas fa-elevator"></i> عرض بيانات المصعد
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="row">
                            <div class="col-md-12">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        @if (!$notification->read_at)
                                            <a href="{{ route('notifications.mark-read', $notification->id) }}" class="btn btn-success">
                                                <i class="fas fa-check"></i> تحديد كمقروء
                                            </a>
                                        @endif
                                    </div>
                                    <div>
                                        <form action="{{ route('notifications.destroy', $notification->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الإشعار؟')">
                                                <i class="fas fa-trash"></i> حذف الإشعار
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .notification-title {
        font-size: 1.5rem;
        margin-bottom: 10px;
    }
    .notification-meta {
        margin-bottom: 20px;
    }
    .notification-meta .badge {
        margin-right: 5px;
        font-size: 0.9rem;
    }
    .notification-message {
        font-size: 1.1rem;
        line-height: 1.6;
    }
</style>
@endsection