@extends('layouts.modern')

@section('title', 'إعدادات الإشعارات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">إعدادات الإشعارات</h5>
                    <div>
                        <a href="{{ route('notifications.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للإشعارات
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row">
                        <div class="col-md-4">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">قنوات الإشعارات</h5>
                                </div>
                                <div class="card-body">
                                    <form action="#" method="POST">
                                        @csrf
                                        <div class="form-group mb-3">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="enable_email" name="enable_email" checked>
                                                <label class="custom-control-label" for="enable_email">تفعيل الإشعارات عبر البريد الإلكتروني</label>
                                            </div>
                                        </div>
                                        <div class="form-group mb-3">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="enable_sms" name="enable_sms">
                                                <label class="custom-control-label" for="enable_sms">تفعيل الإشعارات عبر الرسائل النصية</label>
                                            </div>
                                        </div>
                                        <div class="form-group mb-3">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="enable_push" name="enable_push" checked>
                                                <label class="custom-control-label" for="enable_push">تفعيل الإشعارات الفورية</label>
                                            </div>
                                        </div>
                                        <div class="form-group mb-3">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="enable_whatsapp" name="enable_whatsapp">
                                                <label class="custom-control-label" for="enable_whatsapp">تفعيل الإشعارات عبر واتساب</label>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-primary">حفظ الإعدادات</button>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-8">
                            <div class="card mb-4">
                                <div class="card-header">
                                    <h5 class="mb-0">أنواع الإشعارات</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>نوع الإشعار</th>
                                                    <th>الوصف</th>
                                                    <th>القنوات المفعلة</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>صيانة مستحقة</td>
                                                    <td>إشعارات الصيانة المستحقة خلال الأسبوع القادم</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>صيانة عاجلة</td>
                                                    <td>إشعارات الصيانة العاجلة التي تتطلب تدخلاً سريعاً</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                        <span class="badge bg-success">الرسائل النصية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>صيانة اليوم</td>
                                                    <td>إشعارات الصيانة المجدولة لليوم الحالي</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>صيانة متأخرة</td>
                                                    <td>إشعارات الصيانة المتأخرة عن موعدها المحدد</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                        <span class="badge bg-success">الرسائل النصية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>صيانة متأخرة بشكل حرج</td>
                                                    <td>إشعارات الصيانة المتأخرة بشكل حرج وتتطلب تدخلاً فورياً</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                        <span class="badge bg-success">الرسائل النصية</span>
                                                        <span class="badge bg-success">واتساب</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>عقد على وشك الانتهاء</td>
                                                    <td>إشعارات العقود التي على وشك الانتهاء خلال الشهر القادم</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <!-- إشعارات إدارة العملاء -->
                                                <tr>
                                                    <td>عميل جديد</td>
                                                    <td>إشعارات عند إضافة عميل جديد في النظام</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>تحديث بيانات العميل</td>
                                                    <td>إشعارات عند تحديث بيانات العملاء الهامة</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>طلب خدمة من العميل</td>
                                                    <td>إشعارات عند تقديم العميل لطلب خدمة جديد</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                        <span class="badge bg-success">الرسائل النصية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>شكوى عميل</td>
                                                    <td>إشعارات عند تقديم العميل لشكوى جديدة</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                        <span class="badge bg-success">الرسائل النصية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>تذكير متابعة العميل</td>
                                                    <td>إشعارات تذكير بمتابعة العملاء المحتملين</td>
                                                    <td>
                                                        <span class="badge bg-success">البريد الإلكتروني</span>
                                                        <span class="badge bg-success">الإشعارات الفورية</span>
                                                    </td>
                                                    <td>
                                                        <a href="#" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection