@extends('layouts.modern')

@section('title', 'سجلات الإشعارات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">سجلات الإشعارات</h5>
                    <div>
                        <a href="{{ route('notification-logs.export') }}" class="btn btn-sm btn-success">
                            <i class="fas fa-file-export"></i> تصدير السجلات
                        </a>
                        <a href="{{ route('notifications.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-left"></i> العودة للإشعارات
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="mb-4">
                        <form action="{{ route('notification-logs.index') }}" method="GET" class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="type">نوع الإشعار</label>
                                    <select name="type" id="type" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="maintenance_due" {{ request('type') == 'maintenance_due' ? 'selected' : '' }}>صيانة مستحقة</option>
                                        <option value="maintenance_urgent" {{ request('type') == 'maintenance_urgent' ? 'selected' : '' }}>صيانة عاجلة</option>
                                        <option value="maintenance_today" {{ request('type') == 'maintenance_today' ? 'selected' : '' }}>صيانة اليوم</option>
                                        <option value="maintenance_overdue" {{ request('type') == 'maintenance_overdue' ? 'selected' : '' }}>صيانة متأخرة</option>
                                        <option value="maintenance_critical_overdue" {{ request('type') == 'maintenance_critical_overdue' ? 'selected' : '' }}>صيانة متأخرة بشكل حرج</option>
                                        <option value="contract_expiring" {{ request('type') == 'contract_expiring' ? 'selected' : '' }}>عقد على وشك الانتهاء</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="success" {{ request('status') == 'success' ? 'selected' : '' }}>ناجح</option>
                                        <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>فاشل</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="channel">القناة</label>
                                    <select name="channel" id="channel" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="email" {{ request('channel') == 'email' ? 'selected' : '' }}>البريد الإلكتروني</option>
                                        <option value="sms" {{ request('channel') == 'sms' ? 'selected' : '' }}>الرسائل النصية</option>
                                        <option value="push" {{ request('channel') == 'push' ? 'selected' : '' }}>الإشعارات الفورية</option>
                                        <option value="whatsapp" {{ request('channel') == 'whatsapp' ? 'selected' : '' }}>واتساب</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="date_from">من تاريخ</label>
                                    <input type="date" name="date_from" id="date_from" class="form-control" value="{{ request('date_from') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="date_to">إلى تاريخ</label>
                                    <input type="date" name="date_to" id="date_to" class="form-control" value="{{ request('date_to') }}">
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">تصفية</button>
                                <a href="{{ route('notification-logs.index') }}" class="btn btn-secondary mr-2">إعادة تعيين</a>
                            </div>
                        </form>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>المعرف</th>
                                    <th>نوع الإشعار</th>
                                    <th>القناة</th>
                                    <th>المستلم</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الإرسال</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($notificationLogs ?? [] as $log)
                                    <tr class="{{ $log->status == 'failed' ? 'table-danger' : '' }}">
                                        <td>{{ $log->id ?? 1 }}</td>
                                        <td>
                                            @if ($log->type == 'maintenance_due')
                                                <span class="badge bg-info">صيانة مستحقة</span>
                                            @elseif ($log->type == 'maintenance_urgent')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-exclamation-circle"></i> صيانة عاجلة
                                                </span>
                                            @elseif ($log->type == 'maintenance_today')
                                                <span class="badge bg-primary">
                                                    <i class="fas fa-calendar-day"></i> صيانة اليوم
                                                </span>
                                            @elseif ($log->type == 'maintenance_overdue')
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-exclamation-triangle"></i> صيانة متأخرة
                                                </span>
                                            @elseif ($log->type == 'maintenance_critical_overdue')
                                                <span class="badge bg-danger" style="background-color: #d9534f !important;">
                                                    <i class="fas fa-radiation"></i> صيانة متأخرة بشكل حرج
                                                </span>
                                            @elseif ($log->type == 'contract_expiring')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-file-contract"></i> عقد على وشك الانتهاء
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">{{ $log->type ?? 'صيانة مستحقة' }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($log->channel == 'email')
                                                <span class="badge bg-primary">
                                                    <i class="fas fa-envelope"></i> البريد الإلكتروني
                                                </span>
                                            @elseif ($log->channel == 'sms')
                                                <span class="badge bg-info">
                                                    <i class="fas fa-sms"></i> الرسائل النصية
                                                </span>
                                            @elseif ($log->channel == 'push')
                                                <span class="badge bg-success">
                                                    <i class="fas fa-bell"></i> الإشعارات الفورية
                                                </span>
                                            @elseif ($log->channel == 'whatsapp')
                                                <span class="badge bg-success">
                                                    <i class="fab fa-whatsapp"></i> واتساب
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">{{ $log->channel ?? 'البريد الإلكتروني' }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $log->recipient ?? 'user@example.com' }}</td>
                                        <td>
                                            @if ($log->status == 'success')
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check"></i> ناجح
                                                </span>
                                            @elseif ($log->status == 'failed')
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-times"></i> فاشل
                                                </span>
                                            @elseif ($log->status == 'pending')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-clock"></i> معلق
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">{{ $log->status ?? 'ناجح' }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span title="{{ $log->created_at ?? now()->format('Y-m-d H:i:s') }}">
                                                {{ $log->created_at ?? now()->subHours(rand(1, 24))->diffForHumans() }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('notification-logs.show', $log->id ?? 1) }}" class="btn btn-sm btn-info" title="عرض التفاصيل">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if ($log->status == 'failed')
                                                    <a href="#" class="btn btn-sm btn-warning" title="إعادة المحاولة">
                                                        <i class="fas fa-redo"></i>
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">لا توجد سجلات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection