@extends('layouts.modern')

@section('title', 'الإشعارات')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">الإشعارات</h5>
                    <div>
                        <a href="{{ route('notifications.mark-all-read') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-check-double"></i> تحديد الكل كمقروء
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="mb-4">
                        <form action="{{ route('notifications.index') }}" method="GET" class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="type">نوع الإشعار</label>
                                    <select name="type" id="type" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="maintenance_due" {{ request('type') == 'maintenance_due' ? 'selected' : '' }}>صيانة مستحقة</option>
                                        <option value="maintenance_urgent" {{ request('type') == 'maintenance_urgent' ? 'selected' : '' }}>صيانة عاجلة</option>
                                        <option value="maintenance_today" {{ request('type') == 'maintenance_today' ? 'selected' : '' }}>صيانة اليوم</option>
                                        <option value="maintenance_overdue" {{ request('type') == 'maintenance_overdue' ? 'selected' : '' }}>صيانة متأخرة</option>
                                        <option value="maintenance_critical_overdue" {{ request('type') == 'maintenance_critical_overdue' ? 'selected' : '' }}>صيانة متأخرة بشكل حرج</option>
                                        <option value="contract_expiring" {{ request('type') == 'contract_expiring' ? 'selected' : '' }}>عقد على وشك الانتهاء</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>معلق</option>
                                        <option value="sent" {{ request('status') == 'sent' ? 'selected' : '' }}>تم الإرسال</option>
                                        <option value="read" {{ request('status') == 'read' ? 'selected' : '' }}>مقروء</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="priority">الأولوية</label>
                                    <select name="priority" id="priority" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>منخفضة</option>
                                        <option value="normal" {{ request('priority') == 'normal' ? 'selected' : '' }}>عادية</option>
                                        <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>عالية</option>
                                        <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>عاجلة</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="read">القراءة</label>
                                    <select name="read" id="read" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="read" {{ request('read') == 'read' ? 'selected' : '' }}>مقروء</option>
                                        <option value="unread" {{ request('read') == 'unread' ? 'selected' : '' }}>غير مقروء</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary">تصفية</button>
                                <a href="{{ route('notifications.index') }}" class="btn btn-secondary mr-2">إعادة تعيين</a>
                            </div>
                        </form>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>العنوان</th>
                                    <th>النوع</th>
                                    <th>الأولوية</th>
                                    <th>الحالة</th>
                                    <th>التاريخ</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($notifications as $notification)
                                    <tr class="{{ $notification->read_at ? '' : 'table-primary' }} {{ $notification->priority == 'high' ? 'table-warning' : '' }} {{ $notification->priority == 'critical' ? 'table-danger' : '' }}">
                                        <td>
                                            <a href="{{ route('notifications.show', $notification->id) }}" class="fw-bold">
                                                {{ $notification->title }}
                                            </a>
                                            <div class="small text-muted">{{ Str::limit($notification->message, 60) }}</div>
                                        </td>
                                        <td>
                                            @if ($notification->type == 'maintenance_due')
                                                <span class="badge bg-info">صيانة مستحقة</span>
                                            @elseif ($notification->type == 'maintenance_urgent')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-exclamation-circle"></i> صيانة عاجلة
                                                </span>
                                            @elseif ($notification->type == 'maintenance_today')
                                                <span class="badge bg-primary">
                                                    <i class="fas fa-calendar-day"></i> صيانة اليوم
                                                </span>
                                            @elseif ($notification->type == 'maintenance_overdue')
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-exclamation-triangle"></i> صيانة متأخرة
                                                </span>
                                            @elseif ($notification->type == 'maintenance_critical_overdue')
                                                <span class="badge bg-danger" style="background-color: #d9534f !important;">
                                                    <i class="fas fa-radiation"></i> صيانة متأخرة بشكل حرج
                                                </span>
                                            @elseif ($notification->type == 'contract_expiring')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-file-contract"></i> عقد على وشك الانتهاء
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">{{ $notification->type }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($notification->priority == 'low')
                                                <span class="badge bg-secondary">منخفضة</span>
                                            @elseif ($notification->priority == 'normal')
                                                <span class="badge bg-info">عادية</span>
                                            @elseif ($notification->priority == 'high')
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-exclamation-circle"></i> عالية
                                                </span>
                                            @elseif ($notification->priority == 'critical')
                                                <span class="badge bg-danger">
                                                    <i class="fas fa-radiation"></i> حرجة
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($notification->read_at)
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check"></i> مقروء
                                                </span>
                                            @elseif ($notification->sent_at)
                                                <span class="badge bg-info">
                                                    <i class="fas fa-paper-plane"></i> تم الإرسال
                                                </span>
                                            @else
                                                <span class="badge bg-warning">
                                                    <i class="fas fa-clock"></i> معلق
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            <span title="{{ $notification->created_at->format('Y-m-d H:i:s') }}">
                                                {{ $notification->created_at->diffForHumans() }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('notifications.show', $notification->id) }}" class="btn btn-sm btn-info" title="عرض التفاصيل">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if (!$notification->read_at)
                                                    <a href="{{ route('notifications.mark-read', $notification->id) }}" class="btn btn-sm btn-success" title="تحديد كمقروء">
                                                        <i class="fas fa-check"></i>
                                                    </a>
                                                @endif
                                                @php
                                                    $notificationData = [];
                                                    if ($notification->data) {
                                                        $notificationData = is_array($notification->data) ? $notification->data : json_decode($notification->data, true);
                                                        $notificationData = is_array($notificationData) ? $notificationData : [];
                                                    }
                                                @endphp
                                                
                                                @if (isset($notificationData['schedule_id']))
                                                    <a href="{{ route('maintenance-schedules.show', $notificationData['schedule_id']) }}" class="btn btn-sm btn-primary" title="عرض جدولة الصيانة">
                                                        <i class="fas fa-calendar-check"></i>
                                                    </a>
                                                @endif
                                                <form action="{{ route('notifications.destroy', $notification->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذا الإشعار؟')" title="حذف الإشعار">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">لا توجد إشعارات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $notifications->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection