@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('تفاصيل عقد الصيانة') }}</span>
                    <div>
                        <a href="{{ route('maintenance-contracts.edit', $contract->id) }}" class="btn btn-primary btn-sm mx-1">
                            <i class="fas fa-edit"></i> {{ __('تعديل') }}
                        </a>
                        <a href="{{ route('maintenance-contracts.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> {{ __('العودة إلى قائمة العقود') }}
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-primary text-white">
                                    {{ __('معلومات العقد الأساسية') }}
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">{{ __('رقم العقد') }}</th>
                                            <td>{{ $contract->contract_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('عنوان العقد') }}</th>
                                            <td>{{ $contract->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('العميل') }}</th>
                                            <td>
                                                @if($contract->customer)
                                                    <a href="{{ route('customers.show', $contract->customer->id) }}">
                                                        {{ $contract->customer->name }}
                                                    </a>
                                                @else
                                                    {{ __('غير محدد') }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('الفرع') }}</th>
                                            <td>{{ $contract->branch ? $contract->branch->name : __('غير محدد') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('تاريخ البدء') }}</th>
                                            <td>{{ $contract->start_date ? $contract->start_date->format('Y-m-d') : __('غير محدد') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('تاريخ الانتهاء') }}</th>
                                            <td>{{ $contract->end_date ? $contract->end_date->format('Y-m-d') : __('غير محدد') }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('الحالة') }}</th>
                                            <td>
                                                @if($contract->status == 'active')
                                                    <span class="badge bg-success">{{ __('نشط') }}</span>
                                                @elseif($contract->status == 'draft')
                                                    <span class="badge bg-warning">{{ __('مسودة') }}</span>
                                                @elseif($contract->status == 'expired')
                                                    <span class="badge bg-danger">{{ __('منتهي') }}</span>
                                                @elseif($contract->status == 'cancelled')
                                                    <span class="badge bg-secondary">{{ __('ملغي') }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-info text-white">
                                    {{ __('معلومات مالية') }}
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">{{ __('المبلغ الإجمالي') }}</th>
                                            <td>{{ number_format($contract->total_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('دورة الفوترة') }}</th>
                                            <td>
                                                @if($contract->billing_cycle == 'monthly')
                                                    {{ __('شهري') }}
                                                @elseif($contract->billing_cycle == 'quarterly')
                                                    {{ __('ربع سنوي') }}
                                                @elseif($contract->billing_cycle == 'semi_annually')
                                                    {{ __('نصف سنوي') }}
                                                @elseif($contract->billing_cycle == 'annually')
                                                    {{ __('سنوي') }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('المبلغ الدوري') }}</th>
                                            <td>{{ number_format($contract->monthly_amount, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('عدد الزيارات في السنة') }}</th>
                                            <td>{{ $contract->visits_per_year }}</td>
                                        </tr>
                                        <tr>
                                            <th>{{ __('تكلفة الزيارة الواحدة') }}</th>
                                            <td>{{ number_format($contract->total_amount / $contract->visits_per_year, 2) }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-4">
                                <div class="card-header bg-success text-white">
                                    {{ __('المصاعد المشمولة في العقد') }}
                                </div>
                                <div class="card-body">
                                    @if(count($contract->elevators) > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>{{ __('الرقم التسلسلي') }}</th>
                                                        <th>{{ __('الموديل') }}</th>
                                                        <th>{{ __('الشركة المصنعة') }}</th>
                                                        <th>{{ __('الموقع') }}</th>
                                                        <th>{{ __('الحالة') }}</th>
                                                        <th>{{ __('الإجراءات') }}</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($contract->elevators as $index => $elevator)
                                                        <tr>
                                                            <td>{{ $index + 1 }}</td>
                                                            <td>{{ $elevator->serial_number }}</td>
                                                            <td>{{ $elevator->model }}</td>
                                                            <td>{{ $elevator->manufacturer }}</td>
                                                            <td>{{ $elevator->location ? $elevator->location->name : __('غير محدد') }}</td>
                                                            <td>
                                                                @if($elevator->status == 'operational')
                                                                    <span class="badge bg-success">{{ __('يعمل') }}</span>
                                                                @elseif($elevator->status == 'under_maintenance')
                                                                    <span class="badge bg-warning">{{ __('تحت الصيانة') }}</span>
                                                                @elseif($elevator->status == 'out_of_service')
                                                                    <span class="badge bg-danger">{{ __('خارج الخدمة') }}</span>
                                                                @elseif($elevator->status == 'installation')
                                                                    <span class="badge bg-info">{{ __('قيد التركيب') }}</span>
                                                                @endif
                                                            </td>
                                                            <td>
                                                                <a href="{{ route('elevators.show', $elevator->id) }}" class="btn btn-info btn-sm" title="{{ __('عرض') }}">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            {{ __('لا توجد مصاعد مرتبطة بهذا العقد') }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($contract->invoices && $contract->invoices->count() > 0)
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-4">
                                <div class="card-header bg-warning text-dark">
                                    {{ __('الفواتير المرتبطة بالعقد') }}
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>{{ __('رقم الفاتورة') }}</th>
                                                    <th>{{ __('تاريخ الفاتورة') }}</th>
                                                    <th>{{ __('تاريخ الاستحقاق') }}</th>
                                                    <th>{{ __('المبلغ الإجمالي') }}</th>
                                                    <th>{{ __('المبلغ المدفوع') }}</th>
                                                    <th>{{ __('المبلغ المتبقي') }}</th>
                                                    <th>{{ __('الحالة') }}</th>
                                                    <th>{{ __('الإجراءات') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($contract->invoices as $index => $invoice)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $invoice->invoice_number }}</td>
                                                        <td>{{ $invoice->invoice_date ? $invoice->invoice_date->format('Y-m-d') : __('غير محدد') }}</td>
                                                        <td>{{ $invoice->due_date ? $invoice->due_date->format('Y-m-d') : __('غير محدد') }}</td>
                                                        <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                                        <td>{{ number_format($invoice->paid_amount, 2) }}</td>
                                                        <td>{{ number_format($invoice->due_amount, 2) }}</td>
                                                        <td>
                                                            @if($invoice->status == 'paid')
                                                                <span class="badge bg-success">{{ __('مدفوعة') }}</span>
                                                            @elseif($invoice->status == 'partially_paid')
                                                                <span class="badge bg-warning">{{ __('مدفوعة جزئياً') }}</span>
                                                            @elseif($invoice->status == 'overdue')
                                                                <span class="badge bg-danger">{{ __('متأخرة') }}</span>
                                                            @elseif($invoice->status == 'draft')
                                                                <span class="badge bg-secondary">{{ __('مسودة') }}</span>
                                                            @elseif($invoice->status == 'sent')
                                                                <span class="badge bg-info">{{ __('مرسلة') }}</span>
                                                            @elseif($invoice->status == 'cancelled')
                                                                <span class="badge bg-dark">{{ __('ملغاة') }}</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-info btn-sm" title="{{ __('عرض') }}">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-4">
                                <div class="card-header bg-secondary text-white">
                                    {{ __('معلومات إضافية') }}
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-12 mb-3">
                                            <h5>{{ __('الشروط والأحكام') }}</h5>
                                            <div class="p-3 bg-light rounded">
                                                {!! nl2br(e($contract->terms_conditions)) ?: __('لا توجد شروط وأحكام مسجلة') !!}
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <h5>{{ __('ملاحظات') }}</h5>
                                            <div class="p-3 bg-light rounded">
                                                {!! nl2br(e($contract->notes)) ?: __('لا توجد ملاحظات مسجلة') !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-0">
                        <div class="col-md-12 text-center">
                            <a href="{{ route('maintenance-schedules.create', ['contract_id' => $contract->id]) }}" class="btn btn-success">
                                <i class="fas fa-calendar-plus"></i> {{ __('إنشاء جدول صيانة') }}
                            </a>
                            <a href="{{ route('invoices.create', ['contract_id' => $contract->id]) }}" class="btn btn-warning">
                                <i class="fas fa-file-invoice-dollar"></i> {{ __('إنشاء فاتورة جديدة') }}
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection