@extends('layouts.app')

@section('title', 'تفاصيل فريق الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل فريق الصيانة: {{ $maintenanceTeam->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-teams.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        @can('edit_maintenance_teams')
                        <a href="{{ route('maintenance-teams.edit', $maintenanceTeam) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات الفريق</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم الفريق</th>
                                            <td>{{ $maintenanceTeam->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>الشركة</th>
                                            <td>{{ $maintenanceTeam->company->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>قائد الفريق</th>
                                            <td>{{ $maintenanceTeam->leader->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $maintenanceTeam->created_at->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $maintenanceTeam->creator->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الوصف</th>
                                            <td>{{ $maintenanceTeam->description ?? 'لا يوجد وصف' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">أعضاء الفريق</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الاسم</th>
                                                    <th>الدور</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($maintenanceTeam->members as $index => $member)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $member->name }}</td>
                                                    <td>{{ $member->pivot->role ?? 'Member' }}</td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="3" class="text-center">لا يوجد أعضاء في الفريق</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">طلبات الصيانة المسندة للفريق</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>رقم الطلب</th>
                                                    <th>العنوان</th>
                                                    <th>العميل</th>
                                                    <th>المصعد</th>
                                                    <th>الحالة</th>
                                                    <th>تاريخ الطلب</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($maintenanceTeam->maintenanceRequests as $index => $request)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $request->request_number }}</td>
                                                    <td>{{ $request->title }}</td>
                                                    <td>{{ $request->customer->name ?? 'غير محدد' }}</td>
                                                    <td>{{ $request->elevator->name ?? 'غير محدد' }}</td>
                                                    <td>
                                                        @if($request->status == 'pending')
                                                            <span class="badge badge-warning">قيد الانتظار</span>
                                                        @elseif($request->status == 'assigned')
                                                            <span class="badge badge-info">تم التعيين</span>
                                                        @elseif($request->status == 'in_progress')
                                                            <span class="badge badge-primary">قيد التنفيذ</span>
                                                        @elseif($request->status == 'completed')
                                                            <span class="badge badge-success">مكتمل</span>
                                                        @elseif($request->status == 'cancelled')
                                                            <span class="badge badge-danger">ملغي</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ $request->requested_date->format('Y-m-d') }}</td>
                                                    <td>
                                                        <a href="{{ route('maintenance-requests.show', $request) }}" class="btn btn-info btn-sm">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="8" class="text-center">لا توجد طلبات صيانة مسندة للفريق</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection