@extends('layouts.app')

@section('title', 'فرق الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">فرق الصيانة</h3>
                    <div class="card-tools">
                        @can('create_maintenance_teams')
                        <a href="{{ route('maintenance-teams.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة فريق جديد
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>اسم الفريق</th>
                                    <th>قائد الفريق</th>
                                    <th>الشركة</th>
                                    <th>عدد الأعضاء</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($maintenanceTeams as $team)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $team->name }}</td>
                                    <td>{{ $team->teamLeader->name ?? 'غير محدد' }}</td>
                                    <td>{{ $team->company->name ?? 'غير محدد' }}</td>
                                    <td>{{ $team->members->count() }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('maintenance-teams.show', $team) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @can('edit_maintenance_teams')
                                            <a href="{{ route('maintenance-teams.edit', $team) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            @can('delete_maintenance_teams')
                                            <form action="{{ route('maintenance-teams.destroy', $team) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الفريق؟');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد فرق صيانة</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $maintenanceTeams->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection