@extends('layouts.app')

@section('title', 'تعديل فريق الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل فريق الصيانة: {{ $maintenanceTeam->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-teams.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('maintenance-teams.update', $maintenanceTeam) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">اسم الفريق <span class="text-danger">*</span></label>
                                    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $maintenanceTeam->name) }}" required>
                                    @error('name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="company_id">الشركة <span class="text-danger">*</span></label>
                                    <select name="company_id" id="company_id" class="form-control @error('company_id') is-invalid @enderror" required>
                                        <option value="">اختر الشركة</option>
                                        @foreach($companies as $company)
                                            <option value="{{ $company->id }}" {{ old('company_id', $maintenanceTeam->company_id) == $company->id ? 'selected' : '' }}>
                                                {{ $company->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('company_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="team_leader_id">قائد الفريق <span class="text-danger">*</span></label>
                                    <select name="team_leader_id" id="team_leader_id" class="form-control @error('team_leader_id') is-invalid @enderror" required>
                                        <option value="">اختر قائد الفريق</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}" {{ old('team_leader_id', $maintenanceTeam->leader_id) == $user->id ? 'selected' : '' }}>
                                                {{ $user->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('team_leader_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">وصف الفريق</label>
                                    <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3">{{ old('description', $maintenanceTeam->description) }}</textarea>
                                    @error('description')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">أعضاء الفريق <span class="text-danger">*</span></h4>
                                        <div class="card-tools">
                                            <button type="button" class="btn btn-primary btn-sm" id="add-member">
                                                <i class="fas fa-plus"></i> إضافة عضو
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered" id="members-table">
                                                <thead>
                                                    <tr>
                                                        <th>العضو</th>
                                                        <th>الدور</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(old('members'))
                                                        @foreach(old('members') as $index => $memberId)
                                                            <tr>
                                                                <td>
                                                                    <select name="members[]" class="form-control" required>
                                                                        <option value="">اختر العضو</option>
                                                                        @foreach($users as $user)
                                                                            <option value="{{ $user->id }}" {{ $memberId == $user->id ? 'selected' : '' }}>
                                                                                {{ $user->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="member_roles[]" class="form-control" value="{{ old('member_roles')[$index] ?? 'Member' }}" placeholder="الدور">
                                                                </td>
                                                                <td>
                                                                    <button type="button" class="btn btn-danger btn-sm remove-member">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    @else
                                                        @forelse($maintenanceTeam->members as $member)
                                                            <tr>
                                                                <td>
                                                                    <select name="members[]" class="form-control" required>
                                                                        <option value="">اختر العضو</option>
                                                                        @foreach($users as $user)
                                                                            <option value="{{ $user->id }}" {{ $member->id == $user->id ? 'selected' : '' }}>
                                                                                {{ $user->name }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="member_roles[]" class="form-control" value="{{ $member->pivot->role ?? 'Member' }}" placeholder="الدور">
                                                                </td>
                                                                <td>
                                                                    <button type="button" class="btn btn-danger btn-sm remove-member">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        @empty
                                                            <tr>
                                                                <td>
                                                                    <select name="members[]" class="form-control" required>
                                                                        <option value="">اختر العضو</option>
                                                                        @foreach($users as $user)
                                                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="member_roles[]" class="form-control" value="Member" placeholder="الدور">
                                                                </td>
                                                                <td>
                                                                    <button type="button" class="btn btn-danger btn-sm remove-member">
                                                                        <i class="fas fa-trash"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        @endforelse
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                                <a href="{{ route('maintenance-teams.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // إضافة عضو جديد
        $('#add-member').click(function() {
            // إنشاء عناصر الصف الجديد
            var newRow = $('<tr>');
            
            // إنشاء خلية القائمة المنسدلة للأعضاء
            var selectCell = $('<td>');
            var selectElement = $('<select>', {
                name: 'members[]',
                class: 'form-control',
                required: true
            });
            
            // إضافة خيار فارغ
            selectElement.append($('<option>', {
                value: '',
                text: 'اختر العضو'
            }));
            
            // إضافة خيارات المستخدمين
            @foreach($users as $user)
                selectElement.append($('<option>', {
                    value: '{{ $user->id }}',
                    text: '{{ $user->name }}'
                }));
            @endforeach
            
            selectCell.append(selectElement);
            
            // إنشاء خلية الدور
            var roleCell = $('<td>');
            var roleInput = $('<input>', {
                type: 'text',
                name: 'member_roles[]',
                class: 'form-control',
                value: 'Member',
                placeholder: 'الدور'
            });
            roleCell.append(roleInput);
            
            // إنشاء خلية الإجراءات
            var actionCell = $('<td>');
            var removeButton = $('<button>', {
                type: 'button',
                class: 'btn btn-danger btn-sm remove-member'
            }).append($('<i>', {
                class: 'fas fa-trash'
            }));
            actionCell.append(removeButton);
            
            // إضافة الخلايا إلى الصف
            newRow.append(selectCell, roleCell, actionCell);
            
            // إضافة الصف إلى الجدول
            $('#members-table tbody').append(newRow);
        });

        // حذف عضو
        $(document).on('click', '.remove-member', function() {
            if ($('#members-table tbody tr').length > 1) {
                $(this).closest('tr').remove();
            } else {
                alert('يجب أن يكون هناك عضو واحد على الأقل في الفريق');
            }
        });
    });
</script>
@endpush