@extends('layouts.modern')

@section('title', 'تفاصيل جدول الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">تفاصيل جدول الصيانة</h4>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        @if($schedule->status == 'scheduled')
                            <a href="{{ route('maintenance-logs.create', ['schedule_id' => $schedule->id]) }}" class="btn btn-success">
                                <i class="fas fa-check"></i> تسجيل صيانة
                            </a>
                        @endif
                        @can('edit-maintenance-schedule')
                        <a href="{{ route('maintenance-schedules.edit', $schedule->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الجدول</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم الجدول</th>
                                            <td>{{ $schedule->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الصيانة</th>
                                            <td>{{ $schedule->scheduled_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($schedule->status == 'scheduled')
                                                    <span class="badge badge-info">مجدول</span>
                                                @elseif($schedule->status == 'completed')
                                                    <span class="badge badge-success">مكتمل</span>
                                                @elseif($schedule->status == 'missed')
                                                    <span class="badge badge-warning">فائت</span>
                                                @elseif($schedule->status == 'cancelled')
                                                    <span class="badge badge-danger">ملغي</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تم إنشاؤه بواسطة</th>
                                            <td>{{ $schedule->user ? $schedule->user->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $schedule->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $schedule->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات المصعد والعقد</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">المصعد</th>
                                            <td>
                                                @if($schedule->elevator)
                                                    <a href="{{ route('elevators.show', $schedule->elevator->id) }}">
                                                        {{ $schedule->elevator->model }} ({{ $schedule->elevator->serial_number }})
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العقد</th>
                                            <td>
                                                @if($schedule->maintenance_contract)
                                                    <a href="{{ route('maintenance-contracts.show', $schedule->maintenance_contract->id) }}">
                                                        {{ $schedule->maintenance_contract->contract_number }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>
                                                @if($schedule->elevator && $schedule->elevator->customer)
                                                    <a href="{{ route('customers.show', $schedule->elevator->customer->id) }}">
                                                        {{ $schedule->elevator->customer->name }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الموقع</th>
                                            <td>
                                                @if($schedule->elevator && $schedule->elevator->location)
                                                    {{ $schedule->elevator->location->name }}
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    @if($schedule->notes)
                                        {{ $schedule->notes }}
                                    @else
                                        <span class="text-muted">لا توجد ملاحظات</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">سجلات الصيانة المرتبطة</h5>
                                </div>
                                <div class="card-body">
                                    @if($schedule->maintenance_logs->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>تاريخ الصيانة</th>
                                                        <th>الفني</th>
                                                        <th>الحالة</th>
                                                        <th>الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($schedule->maintenance_logs as $log)
                                                    <tr>
                                                        <td>{{ $log->id }}</td>
                                                        <td>{{ $log->maintenance_date->format('Y-m-d') }}</td>
                                                        <td>{{ $log->technician ? $log->technician->name : 'غير محدد' }}</td>
                                                        <td>
                                                            @if($log->status == 'completed')
                                                                <span class="badge badge-success">مكتمل</span>
                                                            @elseif($log->status == 'partial')
                                                                <span class="badge badge-warning">جزئي</span>
                                                            @elseif($log->status == 'failed')
                                                                <span class="badge badge-danger">فشل</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <a href="{{ route('maintenance-logs.show', $log->id) }}" class="btn btn-sm btn-info">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <p class="text-center">لا توجد سجلات صيانة مرتبطة بهذا الجدول</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection