@extends('layouts.modern')

@section('title', 'جداول الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">جداول الصيانة</h4>
                    <div class="card-tools">
                        @can('create-maintenance-schedule')
                        <a href="{{ route('maintenance-schedules.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة جدول صيانة
                        </a>
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#generateSchedulesModal">
                            <i class="fas fa-calendar-plus"></i> إنشاء جداول متعددة
                        </button>
                        <button type="button" class="btn btn-info" id="openModalBtn">
                            <i class="fas fa-calendar-plus"></i> فتح النافذة (بديل)
                        </button>
                        <button type="button" class="btn btn-warning" id="openTestModalBtn">
                            <i class="fas fa-vial"></i> اختبار النوافذ
                        </button>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <form action="{{ route('maintenance-schedules.index') }}" method="GET" class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>مجدول</option>
                                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="missed" {{ request('status') == 'missed' ? 'selected' : '' }}>فائت</option>
                                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <select name="elevator_id" id="elevator_id" class="form-control">
                                        <option value="">الكل</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ request('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->model }} ({{ $elevator->serial_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="contract_id">العقد</label>
                                    <select name="contract_id" id="contract_id" class="form-control">
                                        <option value="">الكل</option>
                                        @foreach($contracts as $contract)
                                            <option value="{{ $contract->id }}" {{ request('contract_id') == $contract->id ? 'selected' : '' }}>
                                                {{ $contract->contract_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="start_date">من تاريخ</label>
                                    <input type="date" name="start_date" id="start_date" class="form-control" value="{{ request('start_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="end_date">إلى تاريخ</label>
                                    <input type="date" name="end_date" id="end_date" class="form-control" value="{{ request('end_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary form-control">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المصعد</th>
                                    <th>العقد</th>
                                    <th>تاريخ الصيانة</th>
                                    <th>الحالة</th>
                                    <th>تم إنشاؤه بواسطة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($schedules as $schedule)
                                <tr>
                                    <td>{{ $schedule->id }}</td>
                                    <td>
                                        @if($schedule->elevator)
                                            {{ $schedule->elevator->model }} ({{ $schedule->elevator->serial_number }})
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($schedule->maintenance_contract)
                                            {{ $schedule->maintenance_contract->contract_number }}
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                    <td>{{ $schedule->scheduled_date->format('Y-m-d') }}</td>
                                    <td>
                                        @if($schedule->status == 'scheduled')
                                            <span class="badge badge-info">مجدول</span>
                                        @elseif($schedule->status == 'completed')
                                            <span class="badge badge-success">مكتمل</span>
                                        @elseif($schedule->status == 'missed')
                                            <span class="badge badge-warning">فائت</span>
                                        @elseif($schedule->status == 'cancelled')
                                            <span class="badge badge-danger">ملغي</span>
                                        @endif
                                    </td>
                                    <td>{{ $schedule->user ? $schedule->user->name : 'غير محدد' }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('maintenance-schedules.show', $schedule->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if($schedule->status == 'scheduled')
                                                <a href="{{ route('maintenance-logs.create', ['schedule_id' => $schedule->id]) }}" class="btn btn-sm btn-success">
                                                    <i class="fas fa-check"></i> تسجيل صيانة
                                                </a>
                                            @endif
                                            @can('edit-maintenance-schedule')
                                            <a href="{{ route('maintenance-schedules.edit', $schedule->id) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            @can('delete-maintenance-schedule')
                                            <form action="{{ route('maintenance-schedules.destroy', $schedule->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الجدول؟')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد جداول صيانة</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3 pagination-container">
                        {{ $schedules->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for generating multiple schedules -->
<div class="modal fade" id="generateSchedulesModal" tabindex="-1" aria-labelledby="generateSchedulesModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('maintenance-schedules.generate') }}" method="POST" id="generateSchedulesForm">
                @csrf
                <!-- إضافة رسالة تأكيد -->
                <div id="form_messages"></div>
                <div class="modal-header">
                    <h5 class="modal-title" id="generateSchedulesModalLabel">إنشاء جداول صيانة متعددة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="contract_id">العقد</label>
                        <select name="contract_id" id="contract_id" class="form-control" required>
                            <option value="">اختر العقد</option>
                            @foreach($contracts as $contract)
                                <option value="{{ $contract->id }}">{{ $contract->contract_number }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div id="contract_info" class="alert alert-info d-none">
                        <p><strong>معلومات العقد:</strong></p>
                        <p id="contract_billing_cycle"></p>
                        <p id="contract_elevators_count"></p>
                    </div>
                    <div class="form-group">
                        <label for="start_date">تاريخ البداية</label>
                        <input type="date" name="start_date" id="start_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                    </div>
                    <div class="form-group">
                        <label for="end_date">تاريخ النهاية</label>
                        <input type="date" name="end_date" id="end_date" class="form-control" value="{{ date('Y-m-d', strtotime('+1 year')) }}" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn">إنشاء</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

<!-- نافذة منبثقة بسيطة للاختبار -->
<div class="modal fade" id="testModal" tabindex="-1" aria-labelledby="testModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="testModalLabel">نافذة اختبار</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        هذه نافذة اختبار بسيطة للتأكد من أن Bootstrap 5 يعمل بشكل صحيح.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
      </div>
    </div>
  </div>
</div>

@section('scripts')
<script>
    // التحقق من أن Bootstrap و jQuery موجودان
    console.log('jQuery version:', $.fn.jquery);
    console.log('Bootstrap version:', typeof bootstrap !== 'undefined' ? 'Bootstrap 5' : 'Not loaded or Bootstrap 4');
    
    // إعداد AJAX لإرسال CSRF token مع كل طلب
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    
    // التحقق من وجود وظائف Bootstrap 5
    if (typeof bootstrap !== 'undefined') {
        console.log('Bootstrap Modal exists:', typeof bootstrap.Modal !== 'undefined');
        console.log('Bootstrap Tooltip exists:', typeof bootstrap.Tooltip !== 'undefined');
        console.log('Bootstrap Popover exists:', typeof bootstrap.Popover !== 'undefined');
    } else {
        console.log('Bootstrap is not loaded correctly');
    }
    
    // التحقق من وجود jQuery plugins لـ Bootstrap 4
    console.log('jQuery modal plugin exists:', typeof $.fn.modal !== 'undefined');
    console.log('jQuery tooltip plugin exists:', typeof $.fn.tooltip !== 'undefined');
    console.log('jQuery popover plugin exists:', typeof $.fn.popover !== 'undefined');
    
    // التحقق من وجود النافذة المنبثقة
    console.log('Modal element exists:', $('#generateSchedulesModal').length > 0);
    
    // التحقق من وجود عناصر النموذج
    console.log('Form elements:');
    console.log('- Form exists:', $('#generateSchedulesForm').length > 0);
    console.log('- Contract select exists:', $('#contract_id').length > 0);
    console.log('- Start date input exists:', $('#start_date').length > 0);
    console.log('- End date input exists:', $('#end_date').length > 0);
    
    // إضافة مستمع لحدث فتح النافذة المنبثقة
    var generateModal = document.getElementById('generateSchedulesModal');
    if (generateModal) {
        generateModal.addEventListener('shown.bs.modal', function () {
            console.log('Modal opened successfully');
            
            // التحقق من قيم الحقول عند فتح النافذة
            console.log('Initial field values:');
            console.log('- Contract ID:', $('#contract_id').val(), typeof $('#contract_id').val());
            console.log('- Start Date:', $('#start_date').val(), typeof $('#start_date').val());
            console.log('- End Date:', $('#end_date').val(), typeof $('#end_date').val());
        });
    }
    
    // إضافة مستمع للزر
    $('button[data-bs-target="#generateSchedulesModal"]').on('click', function() {
        console.log('Generate schedules button clicked');
    });
    
    // فتح نافذة إنشاء جداول متعددة إذا كانت معلمة show_generate موجودة في الرابط
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.has('show_generate')) {
        console.log('show_generate parameter detected, opening modal');
        var generateSchedulesModal = new bootstrap.Modal(document.getElementById('generateSchedulesModal'));
        generateSchedulesModal.show();
    }
    
    // إضافة مستمع للزر البديل
    $('#openModalBtn').on('click', function() {
        console.log('Alternative button clicked');
        try {
            var myModal = new bootstrap.Modal(document.getElementById('generateSchedulesModal'));
            myModal.show();
        } catch (e) {
            console.error('Error opening modal:', e);
            alert('حدث خطأ أثناء فتح النافذة: ' + e.message);
        }
    });
    
    // إضافة مستمع لزر اختبار النوافذ
    $('#openTestModalBtn').on('click', function() {
        console.log('Test modal button clicked');
        try {
            var testModal = new bootstrap.Modal(document.getElementById('testModal'));
            testModal.show();
        } catch (e) {
            console.error('Error opening test modal:', e);
            alert('حدث خطأ أثناء فتح نافذة الاختبار: ' + e.message);
        }
    });
    
    $(document).ready(function() {
        // إضافة معالج لتقديم النموذج
        $('#generateSchedulesForm').submit(function(e) {
            e.preventDefault();
            
            // التحقق من صحة البيانات
            var contractId = $('#contract_id').val();
            var startDate = $('#start_date').val();
            var endDate = $('#end_date').val();
            
            console.log('Form validation:');
            console.log('- Contract ID:', contractId, typeof contractId);
            console.log('- Start Date:', startDate, typeof startDate);
            console.log('- End Date:', endDate, typeof endDate);
            
            if (!contractId || !startDate || !endDate) {
                console.log('Validation failed: Missing required fields');
                $('#form_messages').html('<div class="alert alert-danger">يرجى ملء جميع الحقول المطلوبة</div>');
                return false;
            }
            
            console.log('Validation passed: All fields are filled');
            
            // إظهار رسالة التحميل
            $('#submitBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> جاري الإنشاء...');
            $('#form_messages').html('<div class="alert alert-info">جاري إنشاء جداول الصيانة...</div>');
            
            // إرسال النموذج
            var formAction = $(this).attr('action');
            var formData = new FormData(this);
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            
            console.log('Submitting form to:', formAction);
            console.log('Form data:', $(this).serialize());
            console.log('CSRF Token:', csrfToken);
            
            // استخدام fetch API بدلاً من $.ajax
            fetch(formAction, {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': csrfToken,
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => {
                console.log('Response status:', response.status);
                console.log('Response headers:', response.headers);
                
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.message || 'حدث خطأ أثناء إنشاء جداول الصيانة');
                    });
                }
                
                return response.json();
            })
            .then(data => {
                console.log('Success response:', data);
                alert('تم إنشاء جداول الصيانة بنجاح!');
                // إعادة تحميل الصفحة بعد النجاح
                window.location.reload();
            })
            .catch(error => {
                console.error('Error:', error);
                
                // إظهار رسالة الخطأ
                var errorMessage = error.message || 'حدث خطأ أثناء إنشاء جداول الصيانة';
                $('#form_messages').html('<div class="alert alert-danger">' + errorMessage + '</div>');
                $('#submitBtn').prop('disabled', false).html('إنشاء');
            });
            });
        });
        
        $('#contract_id').change(function() {
            var contractId = $(this).val();
            if (contractId) {
                // إظهار مؤشر التحميل
                $('#contract_info').removeClass('d-none').html('<p>جاري تحميل معلومات العقد...</p>');
                
                // استدعاء API للحصول على معلومات العقد
                $.ajax({
                    url: '/api/contracts/' + contractId + '/elevators',
                    type: 'GET',
                    success: function(data) {
                        // عرض معلومات العقد
                        var elevatorsCount = data.length;
                        
                        // الحصول على دورة الفوترة
                        $.ajax({
                            url: '/api/contracts/' + contractId,
                            type: 'GET',
                            success: function(contractData) {
                                var billingCycle = contractData.billing_cycle;
                                var billingCycleText = '';
                                
                                switch(billingCycle) {
                                    case 'monthly':
                                        billingCycleText = 'شهري';
                                        break;
                                    case 'quarterly':
                                        billingCycleText = 'ربع سنوي';
                                        break;
                                    case 'semi_annually':
                                        billingCycleText = 'نصف سنوي';
                                        break;
                                    case 'annually':
                                        billingCycleText = 'سنوي';
                                        break;
                                    default:
                                        billingCycleText = billingCycle;
                                }
                                
                                var html = '<p><strong>معلومات العقد:</strong></p>';
                                html += '<p>دورة الفوترة: ' + billingCycleText + '</p>';
                                html += '<p>عدد المصاعد: ' + elevatorsCount + '</p>';
                                
                                if (elevatorsCount === 0) {
                                    html += '<div class="alert alert-warning">تنبيه: لا توجد مصاعد مرتبطة بهذا العقد. يرجى إضافة مصاعد للعقد أولاً.</div>';
                                }
                                
                                $('#contract_info').removeClass('d-none').html(html);
                            },
                            error: function() {
                                $('#contract_info').removeClass('d-none').html('<div class="alert alert-danger">حدث خطأ أثناء تحميل معلومات العقد</div>');
                            }
                        });
                    },
                    error: function() {
                        $('#contract_info').removeClass('d-none').html('<div class="alert alert-danger">حدث خطأ أثناء تحميل معلومات العقد</div>');
                    }
                });
            } else {
                // إخفاء معلومات العقد إذا لم يتم اختيار عقد
                $('#contract_info').addClass('d-none');
            }
        });
    });
</script>
@endsection