@extends('layouts.modern')

@section('title', 'تعديل جدول صيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">تعديل جدول صيانة</h4>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('maintenance-schedules.update', $schedule->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_contract_id">العقد</label>
                                    <input type="text" class="form-control" value="@foreach($contracts as $contract){{ old('maintenance_contract_id', $schedule->maintenance_contract_id) == $contract->id ? $contract->contract_number : '' }}@endforeach" readonly>
                                    <input type="hidden" name="maintenance_contract_id" id="maintenance_contract_id" value="{{ old('maintenance_contract_id', $schedule->maintenance_contract_id) }}">
                                    @error('maintenance_contract_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <input type="text" class="form-control" value="@foreach($elevators as $elevator){{ old('elevator_id', $schedule->elevator_id) == $elevator->id ? $elevator->model . ' (' . $elevator->serial_number . ')' : '' }}@endforeach" readonly>
                                    <input type="hidden" name="elevator_id" id="elevator_id" value="{{ old('elevator_id', $schedule->elevator_id) }}">
                                    @error('elevator_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="scheduled_date">تاريخ الصيانة</label>
                                    <input type="text" class="form-control" value="{{ old('scheduled_date', $schedule->scheduled_date->format('Y-m-d')) }}" readonly>
                                    <input type="hidden" name="scheduled_date" id="scheduled_date" value="{{ old('scheduled_date', $schedule->scheduled_date->format('Y-m-d')) }}">
                                    @error('scheduled_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="scheduled" {{ old('status', $schedule->status) == 'scheduled' ? 'selected' : '' }}>مجدول</option>
                                        <option value="completed" {{ old('status', $schedule->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="missed" {{ old('status', $schedule->status) == 'missed' ? 'selected' : '' }}>فائت</option>
                                        <option value="cancelled" {{ old('status', $schedule->status) == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes', $schedule->notes) }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التغييرات
                            </button>
                            <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-default">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // El script de carga dinámica de ascensores se ha eliminado ya que los campos son de solo lectura
</script>
@endpush