@extends('layouts.modern')

@section('title', 'إضافة جدول صيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">إضافة جدول صيانة جديد</h4>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('maintenance-schedules.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_contract_id">العقد</label>
                                    <select name="maintenance_contract_id" id="maintenance_contract_id" class="form-control @error('maintenance_contract_id') is-invalid @enderror" required>
                                        <option value="">اختر العقد</option>
                                        @foreach($contracts as $contract)
                                            <option value="{{ $contract->id }}" {{ old('maintenance_contract_id') == $contract->id ? 'selected' : '' }}>
                                                {{ $contract->contract_number }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('maintenance_contract_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <select name="elevator_id" id="elevator_id" class="form-control @error('elevator_id') is-invalid @enderror" required>
                                        <option value="">اختر المصعد</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ old('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->model }} ({{ $elevator->serial_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('elevator_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="scheduled_date">تاريخ الصيانة</label>
                                    <input type="date" name="scheduled_date" id="scheduled_date" class="form-control @error('scheduled_date') is-invalid @enderror" value="{{ old('scheduled_date') }}" required>
                                    @error('scheduled_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="scheduled" {{ old('status') == 'scheduled' ? 'selected' : '' }}>مجدول</option>
                                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="missed" {{ old('status') == 'missed' ? 'selected' : '' }}>فائت</option>
                                        <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="notes">ملاحظات</label>
                            <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                            <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-default">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // When contract is selected, load related elevators
        $('#maintenance_contract_id').change(function() {
            var contractId = $(this).val();
            if (contractId) {
                $.ajax({
                    url: '/api/contracts/' + contractId + '/elevators',
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#elevator_id').empty();
                        $('#elevator_id').append('<option value="">اختر المصعد</option>');
                        $.each(data, function(key, value) {
                            $('#elevator_id').append('<option value="' + value.id + '">' + value.model + ' (' + value.serial_number + ')</option>');
                        });
                    }
                });
            } else {
                $('#elevator_id').empty();
                $('#elevator_id').append('<option value="">اختر المصعد</option>');
            }
        });
    });
</script>
@endpush