@extends('layouts.modern')

@section('title', 'طلبات الصيانة')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item active">طلبات الصيانة</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">طلبات الصيانة</h3>
                    <div class="card-tools">
                        @can('create_maintenance_requests')
                            <a href="{{ route('maintenance-requests.create') }}" class="btn btn-success btn-sm">
                                <i class="fa fa-plus"></i> إضافة طلب صيانة جديد
                            </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العميل</th>
                                    <th>المصعد</th>
                                    <th>الأولوية</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الطلب</th>
                                    <th>المسؤول</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($maintenanceRequests as $index => $request)
                                    <tr>
                                        <td>{{ $maintenanceRequests->firstItem() + $index }}</td>
                                        <td>{{ $request->customer->name ?? 'غير محدد' }}</td>
                                        <td>{{ $request->elevator->name ?? 'غير محدد' }}</td>
                                        <td>
                                            @switch($request->priority)
                                                @case('low')
                                                    <span class="badge badge-info">منخفضة</span>
                                                    @break
                                                @case('medium')
                                                    <span class="badge badge-warning">متوسطة</span>
                                                    @break
                                                @case('high')
                                                    <span class="badge badge-danger">عالية</span>
                                                    @break
                                                @case('urgent')
                                                    <span class="badge badge-dark">طارئة</span>
                                                    @break
                                                @default
                                                    <span class="badge badge-secondary">غير محدد</span>
                                            @endswitch
                                        </td>
                                        <td>
                                            @switch($request->status)
                                                @case('pending')
                                                    <span class="badge badge-warning">قيد الانتظار</span>
                                                    @break
                                                @case('assigned')
                                                    <span class="badge badge-info">تم التعيين</span>
                                                    @break
                                                @case('in_progress')
                                                    <span class="badge badge-primary">قيد التنفيذ</span>
                                                    @break
                                                @case('completed')
                                                    <span class="badge badge-success">مكتمل</span>
                                                    @break
                                                @case('cancelled')
                                                    <span class="badge badge-danger">ملغي</span>
                                                    @break
                                                @default
                                                    <span class="badge badge-secondary">غير محدد</span>
                                            @endswitch
                                        </td>
                                        <td>{{ $request->requested_date->format('Y-m-d H:i') }}</td>
                                        <td>{{ $request->assignedTo->name ?? 'غير معين' }}</td>
                                        <td>
                                            <div class="btn-group">
                                                @can('view_maintenance_requests')
                                                    <a href="{{ route('maintenance-requests.show', $request->id) }}" class="btn btn-info btn-sm">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                @endcan
                                                @can('edit_maintenance_requests')
                                                    <a href="{{ route('maintenance-requests.edit', $request->id) }}" class="btn btn-primary btn-sm">
                                                        <i class="fa fa-edit"></i>
                                                    </a>
                                                @endcan
                                                @can('delete_maintenance_requests')
                                                    <form action="{{ route('maintenance-requests.destroy', $request->id) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذا الطلب؟')">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </form>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد طلبات صيانة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $maintenanceRequests->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection