@extends('layouts.modern')

@section('title', 'تعديل طلب صيانة')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('maintenance-requests.index') }}">طلبات الصيانة</a></li>
        <li class="breadcrumb-item active">تعديل طلب صيانة</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">تعديل طلب صيانة #{{ $maintenanceRequest->request_number }}</h3>
                </div>
                <form action="{{ route('maintenance-requests.update', $maintenanceRequest->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="company_id" value="{{ $maintenanceRequest->company_id }}">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id">العميل <span class="text-danger">*</span></label>
                                    <select name="customer_id" id="customer_id" class="form-control select2 @error('customer_id') is-invalid @enderror" required>
                                        <option value="">اختر العميل</option>
                                        @foreach(\App\Models\Customer::where('company_id', auth()->user()->company_id)->orderBy('name')->get() as $customer)
                                            <option value="{{ $customer->id }}" {{ old('customer_id', $maintenanceRequest->customer_id) == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد <span class="text-danger">*</span></label>
                                    <select name="elevator_id" id="elevator_id" class="form-control select2 @error('elevator_id') is-invalid @enderror" required>
                                        <option value="">اختر المصعد</option>
                                        @if($maintenanceRequest->elevator)
                                            <option value="{{ $maintenanceRequest->elevator_id }}" selected>
                                                {{ $maintenanceRequest->elevator->serial_number }} - {{ $maintenanceRequest->elevator->model }}
                                            </option>
                                        @endif
                                    </select>
                                    @error('elevator_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="priority">الأولوية <span class="text-danger">*</span></label>
                                    <select name="priority" id="priority" class="form-control @error('priority') is-invalid @enderror" required>
                                        <option value="low" {{ old('priority', $maintenanceRequest->priority) == 'low' ? 'selected' : '' }}>منخفضة</option>
                                        <option value="medium" {{ old('priority', $maintenanceRequest->priority) == 'medium' ? 'selected' : '' }}>متوسطة</option>
                                        <option value="high" {{ old('priority', $maintenanceRequest->priority) == 'high' ? 'selected' : '' }}>عالية</option>
                                        <option value="urgent" {{ old('priority', $maintenanceRequest->priority) == 'urgent' ? 'selected' : '' }}>طارئة</option>
                                    </select>
                                    @error('priority')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="requested_date">تاريخ الطلب <span class="text-danger">*</span></label>
                                    <input type="datetime-local" name="requested_date" id="requested_date" class="form-control @error('requested_date') is-invalid @enderror" value="{{ old('requested_date', $maintenanceRequest->requested_date ? date('Y-m-d\TH:i', strtotime($maintenanceRequest->requested_date)) : '') }}" required>
                                    @error('requested_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="assigned_user_id">تعيين إلى</label>
                                    <select name="assigned_user_id" id="assigned_user_id" class="form-control select2 @error('assigned_user_id') is-invalid @enderror">
                                        <option value="">اختر الموظف</option>
                                        @foreach(\App\Models\User::where('company_id', auth()->user()->company_id)->orderBy('name')->get() as $user)
                                            <option value="{{ $user->id }}" {{ old('assigned_user_id', $maintenanceRequest->assigned_user_id) == $user->id ? 'selected' : '' }}>
                                                {{ $user->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('assigned_user_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="pending" {{ old('status', $maintenanceRequest->status) == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="assigned" {{ old('status', $maintenanceRequest->status) == 'assigned' ? 'selected' : '' }}>تم التعيين</option>
                                        <option value="in_progress" {{ old('status', $maintenanceRequest->status) == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                        <option value="completed" {{ old('status', $maintenanceRequest->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="cancelled" {{ old('status', $maintenanceRequest->status) == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="title">عنوان الطلب <span class="text-danger">*</span></label>
                            <input type="text" name="title" id="title" class="form-control @error('title') is-invalid @enderror" value="{{ old('title', $maintenanceRequest->title) }}" required>
                            @error('title')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="description">وصف المشكلة <span class="text-danger">*</span></label>
                            <textarea name="description" id="description" rows="4" class="form-control @error('description') is-invalid @enderror" required>{{ old('description', $maintenanceRequest->description) }}</textarea>
                            @error('description')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="problem_details">تفاصيل المشكلة</label>
                            <textarea name="problem_details" id="problem_details" rows="3" class="form-control @error('problem_details') is-invalid @enderror">{{ old('problem_details', $maintenanceRequest->problem_details) }}</textarea>
                            @error('problem_details')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        @if($maintenanceRequest->status == 'completed' || old('status') == 'completed')
                        <div class="form-group" id="completion_notes_group">
                            <label for="completion_notes">ملاحظات الإنجاز</label>
                            <textarea name="completion_notes" id="completion_notes" rows="3" class="form-control @error('completion_notes') is-invalid @enderror">{{ old('completion_notes', $maintenanceRequest->completion_notes) }}</textarea>
                            @error('completion_notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        @endif
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> حفظ التغييرات
                        </button>
                        <a href="{{ route('maintenance-requests.index') }}" class="btn btn-secondary">
                            <i class="fa fa-times"></i> إلغاء
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تحميل المصاعد عند اختيار العميل
        $('#customer_id').on('change', function() {
            var customerId = $(this).val();
            if (customerId) {
                $.ajax({
                    url: "/api/customer/elevators",
                    type: "GET",
                    data: { customer_id: customerId },
                    success: function(data) {
                        $('#elevator_id').empty();
                        $('#elevator_id').append('<option value="">اختر المصعد</option>');
                        $.each(data, function(key, value) {
                            $('#elevator_id').append('<option value="' + value.id + '">' + value.serial_number + ' - ' + value.model + '</option>');
                        });
                    }
                });
            } else {
                $('#elevator_id').empty();
                $('#elevator_id').append('<option value="">اختر المصعد</option>');
            }
        });

        // إظهار/إخفاء حقل ملاحظات الإنجاز عند تغيير الحالة
        $('#status').on('change', function() {
            if ($(this).val() === 'completed') {
                if ($('#completion_notes_group').length === 0) {
                    var completionNotesGroup = '<div class="form-group" id="completion_notes_group">' +
                        '<label for="completion_notes">ملاحظات الإنجاز</label>' +
                        '<textarea name="completion_notes" id="completion_notes" rows="3" class="form-control"></textarea>' +
                        '</div>';
                    $(this).closest('.row').parent().append(completionNotesGroup);
                }
            } else {
                $('#completion_notes_group').remove();
            }
        });
    });
</script>
@endpush