@extends('layouts.modern')

@section('title', 'إضافة طلب صيانة جديد')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('maintenance-requests.index') }}">طلبات الصيانة</a></li>
        <li class="breadcrumb-item active">إضافة طلب صيانة جديد</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">إضافة طلب صيانة جديد</h3>
                </div>
                <form action="{{ route('maintenance-requests.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id">العميل <span class="text-danger">*</span></label>
                                    <select name="customer_id" id="customer_id" class="form-control select2 @error('customer_id') is-invalid @enderror" required>
                                        <option value="">اختر العميل</option>
                                        @foreach(\App\Models\Customer::where('company_id', auth()->user()->company_id)->orderBy('name')->get() as $customer)
                                            <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد <span class="text-danger">*</span></label>
                                    <select name="elevator_id" id="elevator_id" class="form-control select2 @error('elevator_id') is-invalid @enderror" required>
                                        <option value="">اختر المصعد</option>
                                    </select>
                                    @error('elevator_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="priority">الأولوية <span class="text-danger">*</span></label>
                                    <select name="priority" id="priority" class="form-control @error('priority') is-invalid @enderror" required>
                                        <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>منخفضة</option>
                                        <option value="medium" {{ old('priority', 'medium') == 'medium' ? 'selected' : '' }}>متوسطة</option>
                                        <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>عالية</option>
                                        <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>طارئة</option>
                                    </select>
                                    @error('priority')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="requested_date">تاريخ الطلب <span class="text-danger">*</span></label>
                                    <input type="datetime-local" name="requested_date" id="requested_date" class="form-control @error('requested_date') is-invalid @enderror" value="{{ old('requested_date', now()->format('Y-m-d\TH:i')) }}" required>
                                    @error('requested_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="assigned_to">تعيين إلى</label>
                                    <select name="assigned_to" id="assigned_to" class="form-control select2 @error('assigned_to') is-invalid @enderror">
                                        <option value="">اختر الموظف</option>
                                        @foreach(\App\Models\User::where('company_id', auth()->user()->company_id)->orderBy('name')->get() as $user)
                                            <option value="{{ $user->id }}" {{ old('assigned_to') == $user->id ? 'selected' : '' }}>
                                                {{ $user->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('assigned_to')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة <span class="text-danger">*</span></label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="pending" {{ old('status', 'pending') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                        <option value="assigned" {{ old('status') == 'assigned' ? 'selected' : '' }}>تم التعيين</option>
                                        <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="description">وصف المشكلة <span class="text-danger">*</span></label>
                            <textarea name="description" id="description" rows="4" class="form-control @error('description') is-invalid @enderror" required>{{ old('description') }}</textarea>
                            @error('description')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="notes">ملاحظات إضافية</label>
                            <textarea name="notes" id="notes" rows="3" class="form-control @error('notes') is-invalid @enderror">{{ old('notes') }}</textarea>
                            @error('notes')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> حفظ
                        </button>
                        <a href="{{ route('maintenance-requests.index') }}" class="btn btn-secondary">
                            <i class="fa fa-times"></i> إلغاء
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // تحميل المصاعد عند اختيار العميل
        $('#customer_id').on('change', function() {
            var customerId = $(this).val();
            if (customerId) {
                $.ajax({
                    url: "/api/customer/elevators",
                    type: "GET",
                    data: { customer_id: customerId },
                    success: function(data) {
                        $('#elevator_id').empty();
                        $('#elevator_id').append('<option value="">اختر المصعد</option>');
                        $.each(data, function(key, value) {
                            $('#elevator_id').append('<option value="' + value.id + '">' + value.serial_number + ' - ' + value.model + '</option>');
                        });
                    }
                });
            } else {
                $('#elevator_id').empty();
                $('#elevator_id').append('<option value="">اختر المصعد</option>');
            }
        });

        // تحديث حالة التعيين عند اختيار موظف
        $('#assigned_to').on('change', function() {
            var assignedTo = $(this).val();
            if (assignedTo && $('#status').val() === 'pending') {
                $('#status').val('assigned');
            }
        });
    });
</script>
@endpush