@extends('layouts.modern')

@section('title', 'تقارير الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">تقارير الصيانة</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="card-title">تقرير أداء فرق الصيانة</h5>
                                </div>
                                <div class="card-body">
                                    <p>عرض تقارير أداء فرق الصيانة خلال فترة زمنية محددة.</p>
                                    <form action="{{ route('maintenance-reports.performance') }}" method="GET">
                                        <div class="form-group">
                                            <label for="start_date">تاريخ البداية</label>
                                            <input type="date" name="start_date" id="start_date" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="end_date">تاريخ النهاية</label>
                                            <input type="date" name="end_date" id="end_date" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="team_id">فريق الصيانة (اختياري)</label>
                                            <select name="team_id" id="team_id" class="form-control">
                                                <option value="">كل الفرق</option>
                                                @foreach(\App\Models\MaintenanceTeam::all() as $team)
                                                    <option value="{{ $team->id }}">{{ $team->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-primary">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="card-title">تقرير حالة المصاعد</h5>
                                </div>
                                <div class="card-body">
                                    <p>عرض تقارير حالة المصاعد وتكرار الأعطال.</p>
                                    <form action="{{ route('maintenance-reports.elevator-status') }}" method="GET">
                                        <div class="form-group">
                                            <label for="period">الفترة الزمنية</label>
                                            <select name="period" id="period" class="form-control" required>
                                                <option value="month">الشهر الحالي</option>
                                                <option value="quarter">الربع الحالي</option>
                                                <option value="year">السنة الحالية</option>
                                                <option value="custom">فترة مخصصة</option>
                                            </select>
                                        </div>
                                        <div class="form-group custom-date-range d-none">
                                            <label for="custom_start_date">تاريخ البداية</label>
                                            <input type="date" name="custom_start_date" id="custom_start_date" class="form-control">
                                        </div>
                                        <div class="form-group custom-date-range d-none">
                                            <label for="custom_end_date">تاريخ النهاية</label>
                                            <input type="date" name="custom_end_date" id="custom_end_date" class="form-control">
                                        </div>
                                        <div class="form-group">
                                            <label for="customer_id">العميل (اختياري)</label>
                                            <select name="customer_id" id="customer_id" class="form-control">
                                                <option value="">كل العملاء</option>
                                                @foreach(\App\Models\Customer::all() as $customer)
                                                    <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-success">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-danger text-white">
                                    <h5 class="card-title"><i class="fas fa-wrench"></i> تقرير صيانة الأعطال</h5>
                                </div>
                                <div class="card-body">
                                    <p>عرض تقارير صيانة الأعطال والصيانة الطارئة وتكرارها.</p>
                                    <form action="{{ route('maintenance-reports.breakdowns') }}" method="GET">
                                        <div class="form-group">
                                            <label for="breakdown_start_date">تاريخ البداية</label>
                                            <input type="date" name="breakdown_start_date" id="breakdown_start_date" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="breakdown_end_date">تاريخ النهاية</label>
                                            <input type="date" name="breakdown_end_date" id="breakdown_end_date" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="breakdown_elevator_id">المصعد (اختياري)</label>
                                            <select name="breakdown_elevator_id" id="breakdown_elevator_id" class="form-control">
                                                <option value="">كل المصاعد</option>
                                                @foreach(\App\Models\Elevator::all() as $elevator)
                                                    <option value="{{ $elevator->id }}">{{ $elevator->serial_number }} - {{ $elevator->building_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-danger">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h5 class="card-title"><i class="fas fa-dollar-sign"></i> تقرير تكلفة الصيانة</h5>
                                </div>
                                <div class="card-body">
                                    <p>عرض تقارير تكاليف الصيانة والقطع المستبدلة.</p>
                                    <form action="{{ route('maintenance-reports.cost') }}" method="GET">
                                        <div class="form-group">
                                            <label for="cost_start_date">تاريخ البداية</label>
                                            <input type="date" name="cost_start_date" id="cost_start_date" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="cost_end_date">تاريخ النهاية</label>
                                            <input type="date" name="cost_end_date" id="cost_end_date" class="form-control" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="elevator_id">المصعد (اختياري)</label>
                                            <select name="elevator_id" id="elevator_id" class="form-control">
                                                <option value="">كل المصاعد</option>
                                                @foreach(\App\Models\Elevator::all() as $elevator)
                                                    <option value="{{ $elevator->id }}">{{ $elevator->serial_number }} - {{ $elevator->building_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-info">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="card-title"><i class="fas fa-calendar-check"></i> تقرير الصيانة الدورية</h5>
                                </div>
                                <div class="card-body">
                                    <p>عرض تقارير الصيانة الدورية والفحص الدوري ومدى الالتزام بالجدول الزمني.</p>
                                    <form action="{{ route('maintenance-reports.schedule-compliance') }}" method="GET">
                                        <div class="form-group">
                                            <label for="compliance_year">السنة</label>
                                            <select name="compliance_year" id="compliance_year" class="form-control" required>
                                                @for($year = date('Y'); $year >= date('Y') - 5; $year--)
                                                    <option value="{{ $year }}">{{ $year }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="compliance_month">الشهر (اختياري)</label>
                                            <select name="compliance_month" id="compliance_month" class="form-control">
                                                <option value="">كل الشهور</option>
                                                @for($month = 1; $month <= 12; $month++)
                                                    <option value="{{ $month }}">{{ date('F', mktime(0, 0, 0, $month, 1)) }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <button type="submit" class="btn btn-warning">عرض التقرير</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // إظهار/إخفاء حقول التاريخ المخصصة
        $('#period').change(function() {
            if ($(this).val() === 'custom') {
                $('.custom-date-range').removeClass('d-none');
            } else {
                $('.custom-date-range').addClass('d-none');
            }
        });
        
        // تعيين التاريخ الافتراضي لليوم
        var today = new Date();
        var dd = String(today.getDate()).padStart(2, '0');
        var mm = String(today.getMonth() + 1).padStart(2, '0');
        var yyyy = today.getFullYear();
        
        today = yyyy + '-' + mm + '-' + dd;
        
        // تعيين تاريخ البداية قبل شهر من اليوم
        var oneMonthAgo = new Date();
        oneMonthAgo.setMonth(oneMonthAgo.getMonth() - 1);
        var dd2 = String(oneMonthAgo.getDate()).padStart(2, '0');
        var mm2 = String(oneMonthAgo.getMonth() + 1).padStart(2, '0');
        var yyyy2 = oneMonthAgo.getFullYear();
        
        var oneMonthAgoStr = yyyy2 + '-' + mm2 + '-' + dd2;
        
        $('#start_date, #custom_start_date, #cost_start_date').val(oneMonthAgoStr);
        $('#end_date, #custom_end_date, #cost_end_date').val(today);
    });
</script>
@endsection