@extends('layouts.modern')

@section('title', 'تفاصيل الإشعار')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل الإشعار</h3>
                    
                    <div class="card-tools">
                        <a href="{{ route('maintenance-notifications.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">
                                        @if($notification->type == 'maintenance_completed')
                                            <i class="fas fa-check-circle text-success"></i>
                                        @elseif($notification->type == 'maintenance_issue')
                                            <i class="fas fa-exclamation-circle text-danger"></i>
                                        @elseif($notification->type == 'warranty_expiring')
                                            <i class="fas fa-calendar-times text-warning"></i>
                                        @elseif($notification->type == 'maintenance_due')
                                            <i class="fas fa-calendar-check text-info"></i>
                                        @else
                                            <i class="fas fa-bell"></i>
                                        @endif
                                        {{ $notification->title }}
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="message-content">
                                        {!! nl2br(e($notification->message)) !!}
                                    </div>
                                    
                                    @if($notification->link)
                                        <div class="mt-4">
                                            <a href="{{ $notification->link }}" class="btn btn-primary">
                                                <i class="fas fa-external-link-alt"></i> فتح الرابط
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات الإشعار</h5>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>رقم الإشعار:</span>
                                            <span class="badge badge-primary">{{ $notification->id }}</span>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>نوع الإشعار:</span>
                                            @if($notification->type == 'maintenance_completed')
                                                <span class="badge badge-success">اكتمال الصيانة</span>
                                            @elseif($notification->type == 'maintenance_issue')
                                                <span class="badge badge-danger">مشكلة في الصيانة</span>
                                            @elseif($notification->type == 'warranty_expiring')
                                                <span class="badge badge-warning">انتهاء الضمان</span>
                                            @elseif($notification->type == 'maintenance_due')
                                                <span class="badge badge-info">موعد صيانة</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $notification->type }}</span>
                                            @endif
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>الحالة:</span>
                                            @if($notification->is_read)
                                                <span class="badge badge-success">مقروء</span>
                                            @else
                                                <span class="badge badge-warning">غير مقروء</span>
                                            @endif
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>تاريخ الإنشاء:</span>
                                            <span>{{ $notification->created_at->format('Y-m-d H:i') }}</span>
                                        </li>
                                        @if($notification->is_read && $notification->read_at)
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>تاريخ القراءة:</span>
                                            <span>{{ $notification->read_at->format('Y-m-d H:i') }}</span>
                                        </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                            
                            @if($notifiableObject)
                            <div class="card mt-3">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات مرتبطة</h5>
                                </div>
                                <div class="card-body">
                                    @if($notification->notifiable_type == 'App\\Models\\MaintenanceLog')
                                        <h6>سجل الصيانة:</h6>
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>رقم السجل:</span>
                                                <span>{{ $notifiableObject->id }}</span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>المصعد:</span>
                                                <span>{{ $notifiableObject->elevator->name ?? 'غير محدد' }}</span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>الحالة:</span>
                                                @if($notifiableObject->status == 'completed')
                                                    <span class="badge badge-success">مكتمل</span>
                                                @elseif($notifiableObject->status == 'failed')
                                                    <span class="badge badge-danger">فاشل</span>
                                                @elseif($notifiableObject->status == 'pending')
                                                    <span class="badge badge-warning">معلق</span>
                                                @else
                                                    <span class="badge badge-secondary">{{ $notifiableObject->status }}</span>
                                                @endif
                                            </li>
                                        </ul>
                                        <div class="mt-2">
                                            <a href="{{ route('maintenance-logs.show', $notifiableObject->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i> عرض سجل الصيانة
                                            </a>
                                        </div>
                                    @elseif($notification->notifiable_type == 'App\\Models\\Elevator')
                                        <h6>المصعد:</h6>
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>رقم المصعد:</span>
                                                <span>{{ $notifiableObject->id }}</span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>اسم المصعد:</span>
                                                <span>{{ $notifiableObject->name }}</span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>العميل:</span>
                                                <span>{{ $notifiableObject->customer->name ?? 'غير محدد' }}</span>
                                            </li>
                                        </ul>
                                        <div class="mt-2">
                                            <a href="{{ route('elevators.show', $notifiableObject->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i> عرض المصعد
                                            </a>
                                        </div>
                                    @elseif($notification->notifiable_type == 'App\\Models\\MaintenanceSchedule')
                                        <h6>جدول الصيانة:</h6>
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>رقم الجدول:</span>
                                                <span>{{ $notifiableObject->id }}</span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>المصعد:</span>
                                                <span>{{ $notifiableObject->elevator->name ?? 'غير محدد' }}</span>
                                            </li>
                                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                                <span>تاريخ الصيانة:</span>
                                                <span>{{ $notifiableObject->scheduled_date->format('Y-m-d') }}</span>
                                            </li>
                                        </ul>
                                        <div class="mt-2">
                                            <a href="{{ route('maintenance-schedules.show', $notifiableObject->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i> عرض جدول الصيانة
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            @endif
                            
                            <div class="mt-3">
                                <form action="{{ route('maintenance-notifications.update-status', $notification->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('PUT')
                                    @if($notification->is_read)
                                        <input type="hidden" name="status" value="unread">
                                        <button type="submit" class="btn btn-warning">
                                            <i class="fas fa-envelope"></i> تحديد كغير مقروء
                                        </button>
                                    @else
                                        <input type="hidden" name="status" value="read">
                                        <button type="submit" class="btn btn-success">
                                            <i class="fas fa-envelope-open"></i> تحديد كمقروء
                                        </button>
                                    @endif
                                </form>
                                
                                @can('delete_maintenance_notifications')
                                <form action="{{ route('maintenance-notifications.destroy', $notification->id) }}" method="POST" class="d-inline delete-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger">
                                        <i class="fas fa-trash"></i> حذف الإشعار
                                    </button>
                                </form>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تأكيد حذف الإشعار
        const deleteForm = document.querySelector('.delete-form');
        if (deleteForm) {
            deleteForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                if (confirm('هل أنت متأكد من حذف هذا الإشعار؟')) {
                    this.submit();
                }
            });
        }
    });
</script>
@endsection