@extends('layouts.modern')

@section('title', 'إشعارات الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إشعارات الصيانة</h3>
                    
                    <div class="card-tools">
                        @can('send_maintenance_notifications')
                        <form action="{{ route('maintenance-notifications.send-pending') }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-sm btn-primary">
                                <i class="fas fa-paper-plane"></i> إرسال الإشعارات المعلقة
                            </button>
                        </form>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="width: 50px">#</th>
                                    <th>العنوان</th>
                                    <th>النوع</th>
                                    <th>الحالة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th style="width: 150px">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($notifications as $notification)
                                    <tr class="{{ $notification->is_read ? '' : 'table-warning' }}">
                                        <td>{{ $notification->id }}</td>
                                        <td>{{ $notification->title }}</td>
                                        <td>
                                            @if($notification->type == 'maintenance_completed')
                                                <span class="badge badge-success">اكتمال الصيانة</span>
                                            @elseif($notification->type == 'maintenance_issue')
                                                <span class="badge badge-danger">مشكلة في الصيانة</span>
                                            @elseif($notification->type == 'warranty_expiring')
                                                <span class="badge badge-warning">انتهاء الضمان</span>
                                            @elseif($notification->type == 'maintenance_due')
                                                <span class="badge badge-info">موعد صيانة</span>
                                            @elseif($notification->type == 'maintenance_urgent')
                                                <span class="badge badge-danger">صيانة عاجلة</span>
                                            @elseif($notification->type == 'maintenance_overdue')
                                                <span class="badge badge-warning">صيانة متأخرة</span>
                                            @elseif($notification->type == 'maintenance_critical_overdue')
                                                <span class="badge badge-dark">صيانة متأخرة بشكل حرج</span>
                                            @elseif($notification->type == 'contract_expiring')
                                                <span class="badge badge-primary">انتهاء عقد</span>
                                            @elseif($notification->type == 'daily_maintenance')
                                                <span class="badge badge-info">صيانة يومية</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $notification->type }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($notification->is_read)
                                                <span class="badge badge-success">مقروء</span>
                                            @else
                                                <span class="badge badge-warning">غير مقروء</span>
                                            @endif
                                        </td>
                                        <td>{{ $notification->created_at->format('Y-m-d H:i') }}</td>
                                        <td>
                                            <a href="{{ route('maintenance-notifications.show', $notification->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <form action="{{ route('maintenance-notifications.update-status', $notification->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('PUT')
                                                @if($notification->is_read)
                                                    <input type="hidden" name="status" value="unread">
                                                    <button type="submit" class="btn btn-sm btn-warning" title="تحديد كغير مقروء">
                                                        <i class="fas fa-envelope"></i>
                                                    </button>
                                                @else
                                                    <input type="hidden" name="status" value="read">
                                                    <button type="submit" class="btn btn-sm btn-success" title="تحديد كمقروء">
                                                        <i class="fas fa-envelope-open"></i>
                                                    </button>
                                                @endif
                                            </form>
                                            
                                            @can('delete_maintenance_notifications')
                                            <form action="{{ route('maintenance-notifications.destroy', $notification->id) }}" method="POST" class="d-inline delete-form">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" title="حذف">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center">لا توجد إشعارات</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $notifications->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تأكيد حذف الإشعار
        const deleteForms = document.querySelectorAll('.delete-form');
        deleteForms.forEach(form => {
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                
                if (confirm('هل أنت متأكد من حذف هذا الإشعار؟')) {
                    this.submit();
                }
            });
        });
    });
</script>
@endsection