@extends('layouts.modern')

@section('title', 'تفاصيل سجل الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">تفاصيل سجل الصيانة</h4>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-logs.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                        @can('edit-maintenance-log')
                        <a href="{{ route('maintenance-logs.edit', $log->id) }}" class="btn btn-primary">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                        <button onclick="window.print()" class="btn btn-secondary">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات الصيانة</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم السجل</th>
                                            <td>{{ $log->id }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الصيانة</th>
                                            <td>{{ $log->maintenance_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفني</th>
                                            <td>{{ $log->technician ? $log->technician->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($log->status == 'completed')
                                                    <span class="badge badge-success">مكتمل</span>
                                                @elseif($log->status == 'partial')
                                                    <span class="badge badge-warning">جزئي</span>
                                                @elseif($log->status == 'failed')
                                                    <span class="badge badge-danger">فشل</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>جدول الصيانة</th>
                                            <td>
                                                @if($log->maintenanceSchedule)
                                                    <a href="{{ route('maintenance-schedules.show', $log->maintenanceSchedule->id) }}">
                                                        {{ $log->maintenanceSchedule->id }} - {{ $log->maintenanceSchedule->scheduled_date->format('Y-m-d') }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير مرتبط بجدول</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $log->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $log->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات المصعد</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">المصعد</th>
                                            <td>
                                                @if($log->elevator)
                                                    <a href="{{ route('elevators.show', $log->elevator->id) }}">
                                                        {{ $log->elevator->model }} ({{ $log->elevator->serial_number }})
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>
                                                @if($log->elevator && $log->elevator->customer)
                                                    <a href="{{ route('customers.show', $log->elevator->customer->id) }}">
                                                        {{ $log->elevator->customer->name }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الموقع</th>
                                            <td>
                                                @if($log->elevator && $log->elevator->location)
                                                    {{ $log->elevator->location->name }}
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ التركيب</th>
                                            <td>
                                                @if($log->elevator && $log->elevator->installation_date)
                                                    {{ $log->elevator->installation_date->format('Y-m-d') }}
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>عدد الطوابق</th>
                                            <td>
                                                @if($log->elevator)
                                                    {{ $log->elevator->floors_count }}
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>السعة</th>
                                            <td>
                                                @if($log->elevator)
                                                    {{ $log->elevator->capacity }} كجم
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">المشاكل المكتشفة</h5>
                                </div>
                                <div class="card-body">
                                    @if($log->issues_found)
                                        {!! nl2br(e($log->issues_found)) !!}
                                    @else
                                        <span class="text-muted">لا توجد مشاكل مسجلة</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">الإجراءات المتخذة</h5>
                                </div>
                                <div class="card-body">
                                    @if($log->actions_taken)
                                        {!! nl2br(e($log->actions_taken)) !!}
                                    @else
                                        <span class="text-muted">لا توجد إجراءات مسجلة</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">قطع الغيار المستبدلة</h5>
                                </div>
                                <div class="card-body">
                                    @if($log->parts_replaced)
                                        {!! nl2br(e($log->parts_replaced)) !!}
                                    @else
                                        <span class="text-muted">لا توجد قطع غيار مستبدلة</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">توصيات الصيانة القادمة</h5>
                                </div>
                                <div class="card-body">
                                    @if($log->next_maintenance_recommendation)
                                        {!! nl2br(e($log->next_maintenance_recommendation)) !!}
                                    @else
                                        <span class="text-muted">لا توجد توصيات مسجلة</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    @media print {
        .card-tools, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        .content-wrapper {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        .card {
            box-shadow: none !important;
            border: 1px solid #ddd;
        }
    }
</style>
@endpush