@extends('layouts.modern')

@section('title', 'سجلات الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">سجلات الصيانة</h4>
                    <div class="card-tools">
                        @can('export-maintenance-log')
                        <a href="{{ route('maintenance-logs.export') }}" class="btn btn-success mr-2">
                            <i class="fas fa-file-export"></i> تصدير سجلات الصيانة
                        </a>
                        @endcan
                        @can('create-maintenance-log')
                        <a href="{{ route('maintenance-logs.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة سجل صيانة
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <form action="{{ route('maintenance-logs.index') }}" method="GET" class="row">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control">
                                        <option value="">الكل</option>
                                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="partial" {{ request('status') == 'partial' ? 'selected' : '' }}>جزئي</option>
                                        <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>فشل</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <select name="elevator_id" id="elevator_id" class="form-control">
                                        <option value="">الكل</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ request('elevator_id') == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->model }} ({{ $elevator->serial_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="technician_id">الفني</label>
                                    <select name="technician_id" id="technician_id" class="form-control">
                                        <option value="">الكل</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ request('technician_id') == $technician->id ? 'selected' : '' }}>
                                                {{ $technician->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="start_date">من تاريخ</label>
                                    <input type="date" name="start_date" id="start_date" class="form-control" value="{{ request('start_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="end_date">إلى تاريخ</label>
                                    <input type="date" name="end_date" id="end_date" class="form-control" value="{{ request('end_date') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>&nbsp;</label>
                                    <button type="submit" class="btn btn-primary form-control">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>المصعد</th>
                                    <th>تاريخ الصيانة</th>
                                    <th>الفني</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($logs as $log)
                                <tr>
                                    <td>{{ $log->id }}</td>
                                    <td>
                                        @if($log->elevator)
                                            {{ $log->elevator->model }} ({{ $log->elevator->serial_number }})
                                        @else
                                            <span class="text-muted">غير محدد</span>
                                        @endif
                                    </td>
                                    <td>{{ $log->maintenance_date->format('Y-m-d') }}</td>
                                    <td>{{ $log->technician ? $log->technician->name : 'غير محدد' }}</td>
                                    <td>
                                        @if($log->status == 'completed')
                                            <span class="badge badge-success">مكتمل</span>
                                        @elseif($log->status == 'partial')
                                            <span class="badge badge-warning">جزئي</span>
                                        @elseif($log->status == 'failed')
                                            <span class="badge badge-danger">فشل</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('maintenance-logs.show', $log->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @can('edit-maintenance-log')
                                            <a href="{{ route('maintenance-logs.edit', $log->id) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            @can('delete-maintenance-log')
                                            <form action="{{ route('maintenance-logs.destroy', $log->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا السجل؟')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد سجلات صيانة</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $logs->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection