@extends('layouts.modern')

@section('title', 'سجل صيانة المصعد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">سجل صيانة المصعد: {{ $elevator->model }} ({{ $elevator->serial_number }})</h4>
                    <div class="card-tools">
                        <a href="{{ route('elevators.show', $elevator->id) }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة لتفاصيل المصعد
                        </a>
                        @can('create-maintenance-log')
                        <a href="{{ route('maintenance-logs.create', ['elevator_id' => $elevator->id]) }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة سجل صيانة
                        </a>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معلومات المصعد</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">الموديل</th>
                                            <td>{{ $elevator->model }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم التسلسلي</th>
                                            <td>{{ $elevator->serial_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>
                                                @if($elevator->customer)
                                                    <a href="{{ route('customers.show', $elevator->customer->id) }}">
                                                        {{ $elevator->customer->name }}
                                                    </a>
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الموقع</th>
                                            <td>
                                                @if($elevator->location)
                                                    {{ $elevator->location->name }}
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ التركيب</th>
                                            <td>
                                                @if($elevator->installation_date)
                                                    {{ $elevator->installation_date->format('Y-m-d') }}
                                                @else
                                                    <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">إحصائيات الصيانة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="info-box bg-success">
                                                <div class="info-box-content">
                                                    <span class="info-box-text">صيانات مكتملة</span>
                                                    <span class="info-box-number">{{ $logs->where('status', 'completed')->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="info-box bg-warning">
                                                <div class="info-box-content">
                                                    <span class="info-box-text">صيانات جزئية</span>
                                                    <span class="info-box-number">{{ $logs->where('status', 'partial')->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="info-box bg-danger">
                                                <div class="info-box-content">
                                                    <span class="info-box-text">صيانات فاشلة</span>
                                                    <span class="info-box-number">{{ $logs->where('status', 'failed')->count() }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mt-3">
                                        <p><strong>آخر صيانة:</strong> 
                                            @if($logs->count() > 0)
                                                {{ $logs->first()->maintenance_date->format('Y-m-d') }}
                                            @else
                                                <span class="text-muted">لا توجد صيانات مسجلة</span>
                                            @endif
                                        </p>
                                        <p><strong>إجمالي الصيانات:</strong> {{ $logs->count() }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>تاريخ الصيانة</th>
                                    <th>الفني</th>
                                    <th>الحالة</th>
                                    <th>المشاكل المكتشفة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($logs as $log)
                                <tr>
                                    <td>{{ $log->id }}</td>
                                    <td>{{ $log->maintenance_date->format('Y-m-d') }}</td>
                                    <td>{{ $log->technician ? $log->technician->name : 'غير محدد' }}</td>
                                    <td>
                                        @if($log->status == 'completed')
                                            <span class="badge badge-success">مكتمل</span>
                                        @elseif($log->status == 'partial')
                                            <span class="badge badge-warning">جزئي</span>
                                        @elseif($log->status == 'failed')
                                            <span class="badge badge-danger">فشل</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($log->issues_found)
                                            {{ Str::limit($log->issues_found, 50) }}
                                        @else
                                            <span class="text-muted">لا توجد مشاكل مسجلة</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('maintenance-logs.show', $log->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i> عرض
                                        </a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">لا توجد سجلات صيانة لهذا المصعد</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $logs->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection