@extends('layouts.modern')

@section('title', 'تعديل سجل صيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">تعديل سجل صيانة</h4>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-logs.index') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('maintenance-logs.update', $log->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_schedule_id">جدول الصيانة (اختياري)</label>
                                    <select name="maintenance_schedule_id" id="maintenance_schedule_id" class="form-control @error('maintenance_schedule_id') is-invalid @enderror">
                                        <option value="">بدون جدول</option>
                                        @foreach($schedules as $schedule)
                                            <option value="{{ $schedule->id }}" {{ old('maintenance_schedule_id', $log->maintenance_schedule_id) == $schedule->id ? 'selected' : '' }}>
                                                {{ $schedule->id }} - {{ $schedule->scheduled_date->format('Y-m-d') }} - 
                                                @if($schedule->elevator)
                                                    {{ $schedule->elevator->model }} ({{ $schedule->elevator->serial_number }})
                                                @else
                                                    غير محدد
                                                @endif
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('maintenance_schedule_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="elevator_id">المصعد</label>
                                    <select name="elevator_id" id="elevator_id" class="form-control @error('elevator_id') is-invalid @enderror" required>
                                        <option value="">اختر المصعد</option>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ old('elevator_id', $log->elevator_id) == $elevator->id ? 'selected' : '' }}>
                                                {{ $elevator->model }} ({{ $elevator->serial_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('elevator_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_date">تاريخ الصيانة</label>
                                    <input type="date" name="maintenance_date" id="maintenance_date" class="form-control @error('maintenance_date') is-invalid @enderror" value="{{ old('maintenance_date', $log->maintenance_date->format('Y-m-d')) }}" required>
                                    @error('maintenance_date')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="technician_id">الفني</label>
                                    <select name="technician_id" id="technician_id" class="form-control @error('technician_id') is-invalid @enderror" required>
                                        <option value="">اختر الفني</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ old('technician_id', $log->technician_id) == $technician->id ? 'selected' : '' }}>
                                                {{ $technician->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('technician_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="status">حالة الصيانة</label>
                                    <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" required>
                                        <option value="completed" {{ old('status', $log->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="partial" {{ old('status', $log->status) == 'partial' ? 'selected' : '' }}>جزئي</option>
                                        <option value="failed" {{ old('status', $log->status) == 'failed' ? 'selected' : '' }}>فشل</option>
                                    </select>
                                    @error('status')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="issues_found">المشاكل المكتشفة</label>
                                    <textarea name="issues_found" id="issues_found" class="form-control @error('issues_found') is-invalid @enderror" rows="3">{{ old('issues_found', $log->issues_found) }}</textarea>
                                    @error('issues_found')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="actions_taken">الإجراءات المتخذة</label>
                                    <textarea name="actions_taken" id="actions_taken" class="form-control @error('actions_taken') is-invalid @enderror" rows="3">{{ old('actions_taken', $log->actions_taken) }}</textarea>
                                    @error('actions_taken')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="parts_replaced">قطع الغيار المستبدلة</label>
                                    <textarea name="parts_replaced" id="parts_replaced" class="form-control @error('parts_replaced') is-invalid @enderror" rows="3">{{ old('parts_replaced', $log->parts_replaced) }}</textarea>
                                    @error('parts_replaced')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="next_maintenance_recommendation">توصيات الصيانة القادمة</label>
                                    <textarea name="next_maintenance_recommendation" id="next_maintenance_recommendation" class="form-control @error('next_maintenance_recommendation') is-invalid @enderror" rows="3">{{ old('next_maintenance_recommendation', $log->next_maintenance_recommendation) }}</textarea>
                                    @error('next_maintenance_recommendation')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ التغييرات
                            </button>
                            <a href="{{ route('maintenance-logs.index') }}" class="btn btn-default">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // When maintenance schedule is selected, update elevator and date
        $('#maintenance_schedule_id').change(function() {
            var scheduleId = $(this).val();
            if (scheduleId) {
                $.ajax({
                    url: '/api/maintenance-schedules/' + scheduleId,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        $('#elevator_id').val(data.elevator_id);
                        $('#maintenance_date').val(data.scheduled_date);
                    }
                });
            }
        });
    });
</script>
@endpush