@extends('layouts.app')

@section('title', 'تفاصيل فاتورة الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل فاتورة الصيانة #{{ $maintenanceInvoice->id }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-invoices.edit', $maintenanceInvoice->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('maintenance-invoices.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="invoice-info">
                                <h4>معلومات الفاتورة</h4>
                                <table class="table table-bordered">
                                    <tr>
                                        <th style="width: 30%">رقم الفاتورة</th>
                                        <td>{{ $maintenanceInvoice->id }}</td>
                                    </tr>
                                    <tr>
                                        <th>تاريخ الفاتورة</th>
                                        <td>{{ $maintenanceInvoice->invoice_date }}</td>
                                    </tr>
                                    <tr>
                                        <th>تاريخ الاستحقاق</th>
                                        <td>{{ $maintenanceInvoice->due_date }}</td>
                                    </tr>
                                    <tr>
                                        <th>الحالة</th>
                                        <td>
                                            @php
                                                $statusClass = [
                                                    'draft' => 'secondary',
                                                    'sent' => 'info',
                                                    'paid' => 'success',
                                                    'cancelled' => 'danger'
                                                ][$maintenanceInvoice->status] ?? 'secondary';
                                                
                                                $statusText = [
                                                    'draft' => 'مسودة',
                                                    'sent' => 'مرسلة',
                                                    'paid' => 'مدفوعة',
                                                    'cancelled' => 'ملغاة'
                                                ][$maintenanceInvoice->status] ?? $maintenanceInvoice->status;
                                            @endphp
                                            <span class="badge badge-{{ $statusClass }}">{{ $statusText }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>تم إنشاؤها بواسطة</th>
                                        <td>{{ $maintenanceInvoice->createdBy->name }}</td>
                                    </tr>
                                    <tr>
                                        <th>تاريخ الإنشاء</th>
                                        <td>{{ $maintenanceInvoice->created_at }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="customer-info">
                                <h4>معلومات العميل</h4>
                                <table class="table table-bordered">
                                    <tr>
                                        <th style="width: 30%">اسم العميل</th>
                                        <td>{{ $maintenanceInvoice->customer->name }}</td>
                                    </tr>
                                    <tr>
                                        <th>رقم الهاتف</th>
                                        <td>{{ $maintenanceInvoice->customer->phone }}</td>
                                    </tr>
                                    <tr>
                                        <th>البريد الإلكتروني</th>
                                        <td>{{ $maintenanceInvoice->customer->email }}</td>
                                    </tr>
                                    <tr>
                                        <th>العنوان</th>
                                        <td>{{ $maintenanceInvoice->customer->address }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <h4>تفاصيل سجل الصيانة</h4>
                            @if($maintenanceInvoice->maintenanceLog)
                                <table class="table table-bordered">
                                    <tr>
                                        <th style="width: 20%">رقم سجل الصيانة</th>
                                        <td>{{ $maintenanceInvoice->maintenanceLog->id }}</td>
                                    </tr>
                                    <tr>
                                        <th>المصعد</th>
                                        <td>{{ $maintenanceInvoice->maintenanceLog->elevator->name ?? 'غير محدد' }}</td>
                                    </tr>
                                    <tr>
                                        <th>تاريخ الخدمة</th>
                                        <td>{{ $maintenanceInvoice->maintenanceLog->service_date }}</td>
                                    </tr>
                                    <tr>
                                        <th>نوع الصيانة</th>
                                        <td>{{ $maintenanceInvoice->maintenanceLog->maintenance_type }}</td>
                                    </tr>
                                    <tr>
                                        <th>الوصف</th>
                                        <td>{{ $maintenanceInvoice->maintenanceLog->description }}</td>
                                    </tr>
                                    <tr>
                                        <th>الفني</th>
                                        <td>{{ $maintenanceInvoice->maintenanceLog->technician->name ?? 'غير محدد' }}</td>
                                    </tr>
                                </table>
                            @else
                                <div class="alert alert-warning">
                                    لا يوجد سجل صيانة مرتبط بهذه الفاتورة
                                </div>
                            @endif
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-12">
                            <h4>تفاصيل المبالغ</h4>
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 70%">المبلغ الأساسي</th>
                                    <td class="text-left">{{ number_format($maintenanceInvoice->amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <th>ضريبة القيمة المضافة ({{ $maintenanceInvoice->tax_rate }}%)</th>
                                    <td class="text-left">{{ number_format($maintenanceInvoice->tax_amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <th>المبلغ الإجمالي</th>
                                    <td class="text-left"><strong>{{ number_format($maintenanceInvoice->total_amount, 2) }}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    @if($maintenanceInvoice->notes)
                    <div class="row mt-4">
                        <div class="col-12">
                            <h4>ملاحظات</h4>
                            <div class="p-3 bg-light">
                                {{ $maintenanceInvoice->notes }}
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <div class="row mt-4">
                        <div class="col-12 text-center">
                            <a href="{{ route('maintenance-invoices.print', $maintenanceInvoice->id) }}" class="btn btn-primary" target="_blank">
                                <i class="fas fa-print"></i> طباعة الفاتورة
                            </a>
                            
                            <a href="{{ route('maintenance-invoices.send', $maintenanceInvoice->id) }}" class="btn btn-info">
                                <i class="fas fa-envelope"></i> إرسال الفاتورة بالبريد الإلكتروني
                            </a>
                            
                            @if($maintenanceInvoice->status != 'paid')
                            <a href="{{ route('maintenance-invoices.mark-as-paid', $maintenanceInvoice->id) }}" class="btn btn-success">
                                <i class="fas fa-check-circle"></i> تحديد كمدفوعة
                            </a>
                            @endif
                            
                            @if($maintenanceInvoice->status != 'cancelled')
                            <a href="{{ route('maintenance-invoices.mark-as-cancelled', $maintenanceInvoice->id) }}" class="btn btn-danger">
                                <i class="fas fa-times-circle"></i> إلغاء الفاتورة
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection