<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة صيانة #{{ $maintenanceInvoice->id }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
            direction: rtl;
        }
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .invoice-header {
            border-bottom: 2px solid #ddd;
            padding-bottom: 20px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
        }
        .company-info {
            text-align: right;
        }
        .invoice-info {
            text-align: left;
        }
        .invoice-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
            color: #2c3e50;
            text-align: center;
        }
        .customer-info {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: right;
        }
        th {
            background-color: #f2f2f2;
        }
        .amount-table th {
            width: 70%;
        }
        .amount-table td {
            text-align: left;
        }
        .total-row {
            font-weight: bold;
            background-color: #f9f9f9;
        }
        .notes {
            margin-top: 30px;
            padding: 15px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        @media print {
            body {
                padding: 0;
            }
            .invoice-container {
                box-shadow: none;
                border: none;
                padding: 0;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="invoice-header">
            <div class="company-info">
                <h2>شركة المصاعد</h2>
                <p>العنوان: {{ $company->address ?? 'عنوان الشركة' }}</p>
                <p>الهاتف: {{ $company->phone ?? 'هاتف الشركة' }}</p>
                <p>البريد الإلكتروني: {{ $company->email ?? 'بريد الشركة الإلكتروني' }}</p>
            </div>
            <div class="invoice-info">
                <h3>فاتورة صيانة</h3>
                <p>رقم الفاتورة: {{ $maintenanceInvoice->id }}</p>
                <p>تاريخ الفاتورة: {{ $maintenanceInvoice->invoice_date }}</p>
                <p>تاريخ الاستحقاق: {{ $maintenanceInvoice->due_date }}</p>
                <p>الحالة: 
                    @php
                        $statusText = [
                            'draft' => 'مسودة',
                            'sent' => 'مرسلة',
                            'paid' => 'مدفوعة',
                            'cancelled' => 'ملغاة'
                        ][$maintenanceInvoice->status] ?? $maintenanceInvoice->status;
                    @endphp
                    {{ $statusText }}
                </p>
            </div>
        </div>
        
        <div class="invoice-title">فاتورة صيانة #{{ $maintenanceInvoice->id }}</div>
        
        <div class="customer-info">
            <h3>معلومات العميل</h3>
            <p><strong>الاسم:</strong> {{ $maintenanceInvoice->customer->name }}</p>
            <p><strong>الهاتف:</strong> {{ $maintenanceInvoice->customer->phone }}</p>
            <p><strong>البريد الإلكتروني:</strong> {{ $maintenanceInvoice->customer->email }}</p>
            <p><strong>العنوان:</strong> {{ $maintenanceInvoice->customer->address }}</p>
        </div>
        
        <h3>تفاصيل سجل الصيانة</h3>
        @if($maintenanceInvoice->maintenanceLog)
            <table>
                <tr>
                    <th>رقم سجل الصيانة</th>
                    <td>{{ $maintenanceInvoice->maintenanceLog->id }}</td>
                </tr>
                <tr>
                    <th>المصعد</th>
                    <td>{{ $maintenanceInvoice->maintenanceLog->elevator->name ?? 'غير محدد' }}</td>
                </tr>
                <tr>
                    <th>تاريخ الخدمة</th>
                    <td>{{ $maintenanceInvoice->maintenanceLog->service_date }}</td>
                </tr>
                <tr>
                    <th>نوع الصيانة</th>
                    <td>{{ $maintenanceInvoice->maintenanceLog->maintenance_type }}</td>
                </tr>
                <tr>
                    <th>الوصف</th>
                    <td>{{ $maintenanceInvoice->maintenanceLog->description }}</td>
                </tr>
                <tr>
                    <th>الفني</th>
                    <td>{{ $maintenanceInvoice->maintenanceLog->technician->name ?? 'غير محدد' }}</td>
                </tr>
            </table>
        @else
            <p>لا يوجد سجل صيانة مرتبط بهذه الفاتورة</p>
        @endif
        
        <h3>تفاصيل المبالغ</h3>
        <table class="amount-table">
            <tr>
                <th>المبلغ الأساسي</th>
                <td>{{ number_format($maintenanceInvoice->amount, 2) }}</td>
            </tr>
            <tr>
                <th>ضريبة القيمة المضافة ({{ $maintenanceInvoice->tax_rate }}%)</th>
                <td>{{ number_format($maintenanceInvoice->tax_amount, 2) }}</td>
            </tr>
            <tr class="total-row">
                <th>المبلغ الإجمالي</th>
                <td>{{ number_format($maintenanceInvoice->total_amount, 2) }}</td>
            </tr>
        </table>
        
        @if($maintenanceInvoice->notes)
        <div class="notes">
            <h3>ملاحظات</h3>
            <p>{{ $maintenanceInvoice->notes }}</p>
        </div>
        @endif
        
        <div class="footer">
            <p>شكراً لتعاملكم معنا</p>
            <p>تم إنشاء هذه الفاتورة بواسطة: {{ $maintenanceInvoice->createdBy->name }} في {{ $maintenanceInvoice->created_at }}</p>
        </div>
        
        <div class="no-print" style="margin-top: 30px; text-align: center;">
            <button onclick="window.print()" style="padding: 10px 20px; background-color: #3498db; color: white; border: none; border-radius: 5px; cursor: pointer;">
                طباعة الفاتورة
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; background-color: #7f8c8d; color: white; border: none; border-radius: 5px; cursor: pointer; margin-right: 10px;">
                إغلاق
            </button>
        </div>
    </div>
</body>
</html>