@extends('layouts.app')

@section('title', 'فواتير الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">فواتير الصيانة</h3>
                    <div class="card-tools">
                        <a href="{{ route('maintenance-invoices.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إنشاء فاتورة جديدة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العميل</th>
                                    <th>سجل الصيانة</th>
                                    <th>تاريخ الفاتورة</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>المبلغ</th>
                                    <th>الضريبة</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>الحالة</th>
                                    <th>تم إنشاؤها بواسطة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($maintenanceInvoices as $invoice)
                                    <tr>
                                        <td>{{ $invoice->id }}</td>
                                        <td>{{ $invoice->customer->name }}</td>
                                        <td>
                                            @if($invoice->maintenanceLog)
                                                <a href="{{ route('maintenance-logs.show', $invoice->maintenanceLog->id) }}">
                                                    #{{ $invoice->maintenanceLog->id }}
                                                </a>
                                            @else
                                                غير متوفر
                                            @endif
                                        </td>
                                        <td>{{ $invoice->invoice_date }}</td>
                                        <td>{{ $invoice->due_date }}</td>
                                        <td>{{ number_format($invoice->amount, 2) }}</td>
                                        <td>{{ number_format($invoice->tax_amount, 2) }} ({{ $invoice->tax_rate }}%)</td>
                                        <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                        <td>
                                            @php
                                                $statusClass = [
                                                    'draft' => 'secondary',
                                                    'sent' => 'info',
                                                    'paid' => 'success',
                                                    'cancelled' => 'danger'
                                                ][$invoice->status] ?? 'secondary';
                                                
                                                $statusText = [
                                                    'draft' => 'مسودة',
                                                    'sent' => 'مرسلة',
                                                    'paid' => 'مدفوعة',
                                                    'cancelled' => 'ملغاة'
                                                ][$invoice->status] ?? $invoice->status;
                                            @endphp
                                            <span class="badge badge-{{ $statusClass }}">{{ $statusText }}</span>
                                        </td>
                                        <td>{{ $invoice->createdBy->name }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('maintenance-invoices.show', $invoice->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('maintenance-invoices.edit', $invoice->id) }}" class="btn btn-sm btn-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $invoice->id }}">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                            
                                            <!-- Delete Modal -->
                                            <div class="modal fade" id="deleteModal{{ $invoice->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $invoice->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="deleteModalLabel{{ $invoice->id }}">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من رغبتك في حذف هذه الفاتورة؟
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                            <form action="{{ route('maintenance-invoices.destroy', $invoice->id) }}" method="POST" style="display: inline-block;">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="11" class="text-center">لا توجد فواتير صيانة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $maintenanceInvoices->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection