@extends('layouts.app')

@section('title', 'تعديل فاتورة الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل فاتورة الصيانة #{{ $maintenanceInvoice->id }}</h3>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('maintenance-invoices.update', $maintenanceInvoice->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="customer_id">العميل</label>
                                    <select name="customer_id" id="customer_id" class="form-control select2" required>
                                        <option value="">اختر العميل</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ old('customer_id', $maintenanceInvoice->customer_id) == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }} - {{ $customer->phone }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="maintenance_log_id">سجل الصيانة</label>
                                    <select name="maintenance_log_id" id="maintenance_log_id" class="form-control select2" required>
                                        <option value="">اختر سجل الصيانة</option>
                                        @foreach($maintenanceLogs as $log)
                                            <option value="{{ $log->id }}" {{ old('maintenance_log_id', $maintenanceInvoice->maintenance_log_id) == $log->id ? 'selected' : '' }}>
                                                #{{ $log->id }} - {{ $log->elevator->name ?? 'غير محدد' }} - {{ $log->service_date }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="invoice_date">تاريخ الفاتورة</label>
                                    <input type="date" name="invoice_date" id="invoice_date" class="form-control" value="{{ old('invoice_date', $maintenanceInvoice->invoice_date) }}" required>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="due_date">تاريخ الاستحقاق</label>
                                    <input type="date" name="due_date" id="due_date" class="form-control" value="{{ old('due_date', $maintenanceInvoice->due_date) }}" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="amount">المبلغ</label>
                                    <input type="number" name="amount" id="amount" class="form-control" step="0.01" min="0" value="{{ old('amount', $maintenanceInvoice->amount) }}" required>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="tax_rate">نسبة الضريبة (%)</label>
                                    <input type="number" name="tax_rate" id="tax_rate" class="form-control" step="0.01" min="0" value="{{ old('tax_rate', $maintenanceInvoice->tax_rate) }}" required>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="total_amount">المبلغ الإجمالي</label>
                                    <input type="number" name="total_amount" id="total_amount" class="form-control" step="0.01" min="0" value="{{ old('total_amount', $maintenanceInvoice->total_amount) }}" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status">الحالة</label>
                                    <select name="status" id="status" class="form-control" required>
                                        <option value="draft" {{ old('status', $maintenanceInvoice->status) == 'draft' ? 'selected' : '' }}>مسودة</option>
                                        <option value="sent" {{ old('status', $maintenanceInvoice->status) == 'sent' ? 'selected' : '' }}>مرسلة</option>
                                        <option value="paid" {{ old('status', $maintenanceInvoice->status) == 'paid' ? 'selected' : '' }}>مدفوعة</option>
                                        <option value="cancelled" {{ old('status', $maintenanceInvoice->status) == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control" rows="3">{{ old('notes', $maintenanceInvoice->notes) }}</textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                            <a href="{{ route('maintenance-invoices.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    $(document).ready(function() {
        // حساب المبلغ الإجمالي عند تغيير المبلغ أو نسبة الضريبة
        $('#amount, #tax_rate').on('input', function() {
            calculateTotal();
        });
        
        // حساب المبلغ الإجمالي عند تحميل الصفحة
        calculateTotal();
        
        // دالة حساب المبلغ الإجمالي
        function calculateTotal() {
            var amount = parseFloat($('#amount').val()) || 0;
            var taxRate = parseFloat($('#tax_rate').val()) || 0;
            var taxAmount = amount * (taxRate / 100);
            var totalAmount = amount + taxAmount;
            
            // تحديث حقل المبلغ الإجمالي
            $('#total_amount').val(totalAmount.toFixed(2));
        }
        
        // تحديث قائمة سجلات الصيانة عند تغيير العميل
        $('#customer_id').on('change', function() {
            var customerId = $(this).val();
            if (customerId) {
                $.ajax({
                    url: "{{ route('maintenance-logs.by-customer') }}",
                    type: "GET",
                    data: { customer_id: customerId },
                    success: function(data) {
                        $('#maintenance_log_id').empty();
                        $('#maintenance_log_id').append('<option value="">اختر سجل الصيانة</option>');
                        $.each(data, function(key, value) {
                            $('#maintenance_log_id').append('<option value="' + value.id + '">#' + value.id + ' - ' + (value.elevator ? value.elevator.name : 'غير محدد') + ' - ' + value.service_date + '</option>');
                        });
                    }
                });
            } else {
                $('#maintenance_log_id').empty();
                $('#maintenance_log_id').append('<option value="">اختر سجل الصيانة</option>');
            }
        });
    });
</script>
@endpush