@extends('layouts.modern')

@section('title', 'تقارير أداء الفنيين')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقارير أداء الفنيين</h3>
                </div>
                <div class="card-body">
                    <!-- نموذج البحث -->
                    <form action="{{ route('maintenance-financial.technician-performance') }}" method="POST" class="mb-4">
                        @csrf
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البداية</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">تاريخ النهاية</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="technician_id">الفني</label>
                                    <select class="form-control" id="technician_id" name="technician_id">
                                        <option value="">جميع الفنيين</option>
                                        @foreach($technicians as $technician)
                                            <option value="{{ $technician->id }}" {{ isset($selectedTechnicianId) && $selectedTechnicianId == $technician->id ? 'selected' : '' }}>
                                                {{ $technician->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="d-block">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary">عرض التقرير</button>
                                    
                                    @can('export_financial_reports')
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            تصدير
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('maintenance-financial.export-reports', [
                                                'start_date' => $startDate,
                                                'end_date' => $endDate,
                                                'technician_id' => $selectedTechnicianId ?? '',
                                                'export_type' => 'excel',
                                                'report_type' => 'technician'
                                            ]) }}">Excel</a>
                                            <a class="dropdown-item" href="{{ route('maintenance-financial.export-reports', [
                                                'start_date' => $startDate,
                                                'end_date' => $endDate,
                                                'technician_id' => $selectedTechnicianId ?? '',
                                                'export_type' => 'pdf',
                                                'report_type' => 'technician'
                                            ]) }}">PDF</a>
                                        </div>
                                    </div>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- ملخص التقرير -->
                    <div class="row">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $report['total_technicians'] }}</h3>
                                    <p>إجمالي الفنيين</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-users"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $report['total_completed_maintenance'] }}</h3>
                                    <p>إجمالي عمليات الصيانة المكتملة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ number_format($report['average_completion_time'], 1) }} ساعة</h3>
                                    <p>متوسط وقت الإنجاز</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $report['total_failed_maintenance'] }}</h3>
                                    <p>عمليات الصيانة الفاشلة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-times-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تفاصيل التقرير -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">عدد عمليات الصيانة لكل فني</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="maintenanceByTechnicianChart" style="height: 300px;"></canvas>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">متوسط وقت الإنجاز لكل فني (بالساعات)</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="completionTimeChart" style="height: 300px;"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول أداء الفنيين -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">تفاصيل أداء الفنيين</h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>اسم الفني</th>
                                            <th>عمليات الصيانة المكتملة</th>
                                            <th>عمليات الصيانة الفاشلة</th>
                                            <th>متوسط وقت الإنجاز (ساعة)</th>
                                            <th>عدد قطع الغيار المستبدلة</th>
                                            <th>نسبة النجاح</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($report['technicians'] as $performance)
                                            <tr>
                                                <td>{{ $performance['name'] }}</td>
                                                <td>{{ $performance['completed_maintenance'] }}</td>
                                                <td>{{ $performance['failed_maintenance'] }}</td>
                                                <td>{{ number_format($performance['average_completion_time'], 1) }}</td>
                                                <td>{{ $performance['parts_replaced'] }}</td>
                                                <td>
                                                    <div class="progress">
                                                        <div class="progress-bar bg-success" role="progressbar" style="width: {{ $performance['success_rate'] }}%">
                                                            {{ $performance['success_rate'] }}%
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <a href="{{ route('users.show', $performance['id']) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="7" class="text-center">لا توجد بيانات أداء في الفترة المحددة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // بيانات الرسم البياني لعدد عمليات الصيانة لكل فني
        const technicianData = @json($report['technicians']);
        const technicianLabels = technicianData.map(item => item.name);
        const completedValues = technicianData.map(item => item.completed_maintenance);
        const failedValues = technicianData.map(item => item.failed_maintenance);
        
        // إنشاء الرسم البياني لعدد عمليات الصيانة
        const maintenanceCtx = document.getElementById('maintenanceByTechnicianChart').getContext('2d');
        new Chart(maintenanceCtx, {
            type: 'bar',
            data: {
                labels: technicianLabels,
                datasets: [
                    {
                        label: 'عمليات مكتملة',
                        data: completedValues,
                        backgroundColor: 'rgba(40, 167, 69, 0.6)',
                        borderColor: 'rgba(40, 167, 69, 1)',
                        borderWidth: 1
                    },
                    {
                        label: 'عمليات فاشلة',
                        data: failedValues,
                        backgroundColor: 'rgba(220, 53, 69, 0.6)',
                        borderColor: 'rgba(220, 53, 69, 1)',
                        borderWidth: 1
                    }
                ]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
        
        // بيانات الرسم البياني لمتوسط وقت الإنجاز
        const completionTimeValues = technicianData.map(item => item.average_completion_time);
        
        // إنشاء الرسم البياني لمتوسط وقت الإنجاز
        const timeCtx = document.getElementById('completionTimeChart').getContext('2d');
        new Chart(timeCtx, {
            type: 'bar',
            data: {
                labels: technicianLabels,
                datasets: [{
                    label: 'متوسط وقت الإنجاز (ساعة)',
                    data: completionTimeValues,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    });
</script>
@endsection