@extends('layouts.modern')

@section('title', 'التقارير المالية للصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">التقارير المالية للصيانة</h3>
                </div>
                <div class="card-body">
                    <!-- نموذج البحث -->
                    <form action="{{ route('maintenance-financial.reports') }}" method="POST" class="mb-4">
                        @csrf
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البداية</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">تاريخ النهاية</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}" required>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="customer_id">العميل</label>
                                    <select class="form-control" id="customer_id" name="customer_id">
                                        <option value="">جميع العملاء</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ isset($selectedCustomerId) && $selectedCustomerId == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="d-block">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary">عرض التقرير</button>
                                    
                                    @can('export_financial_reports')
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            تصدير
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="{{ route('maintenance-financial.export-reports', [
                                                'start_date' => $startDate,
                                                'end_date' => $endDate,
                                                'customer_id' => $selectedCustomerId ?? '',
                                                'export_type' => 'excel'
                                            ]) }}">Excel</a>
                                            <a class="dropdown-item" href="{{ route('maintenance-financial.export-reports', [
                                                'start_date' => $startDate,
                                                'end_date' => $endDate,
                                                'customer_id' => $selectedCustomerId ?? '',
                                                'export_type' => 'pdf'
                                            ]) }}">PDF</a>
                                        </div>
                                    </div>
                                    @endcan
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- ملخص التقرير -->
                    <div class="row">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ number_format($report['revenue']['total_revenue']) }} ر.س</h3>
                                    <p>إجمالي الإيرادات</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $report['maintenance']['completed'] }}</h3>
                                    <p>عمليات الصيانة المكتملة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $report['contracts']['active'] }}</h3>
                                    <p>العقود النشطة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $report['maintenance']['failed'] }}</h3>
                                    <p>عمليات الصيانة الفاشلة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-times-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تفاصيل التقرير -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">إيرادات الصيانة حسب العقد</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="revenueByContractChart" style="height: 300px;"></canvas>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">حالة عمليات الصيانة</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="maintenanceStatusChart" style="height: 300px;"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول الفواتير -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">فواتير الصيانة</h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>رقم الفاتورة</th>
                                            <th>العميل</th>
                                            <th>عقد الصيانة</th>
                                            <th>تاريخ الفاتورة</th>
                                            <th>المبلغ</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($report['invoices'] as $invoice)
                                            <tr>
                                                <td>{{ $invoice->invoice_number }}</td>
                                                <td>{{ $invoice->customer->name ?? 'غير محدد' }}</td>
                                                <td>{{ $invoice->maintenance_contract->title ?? 'غير محدد' }}</td>
                                                <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                                                <td>{{ number_format($invoice->total_amount) }} ر.س</td>
                                                <td>
                                                    @if($invoice->status == 'paid')
                                                        <span class="badge badge-success">مدفوعة</span>
                                                    @elseif($invoice->status == 'partially_paid')
                                                        <span class="badge badge-warning">مدفوعة جزئياً</span>
                                                    @elseif($invoice->status == 'unpaid')
                                                        <span class="badge badge-danger">غير مدفوعة</span>
                                                    @else
                                                        <span class="badge badge-secondary">{{ $invoice->status }}</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="7" class="text-center">لا توجد فواتير في الفترة المحددة</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // بيانات الرسم البياني للإيرادات حسب العقد
        const revenueData = @json($report['revenue_by_contract']);
        const revenueLabels = revenueData.map(item => item.contract_name || 'بدون عقد');
        const revenueValues = revenueData.map(item => item.total_revenue);
        
        // إنشاء الرسم البياني للإيرادات
        const revenueCtx = document.getElementById('revenueByContractChart').getContext('2d');
        new Chart(revenueCtx, {
            type: 'bar',
            data: {
                labels: revenueLabels,
                datasets: [{
                    label: 'الإيرادات (ر.س)',
                    data: revenueValues,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
        
        // بيانات الرسم البياني لحالة عمليات الصيانة
        const statusData = [
            { label: 'مكتملة', value: {{ $report['maintenance']['completed'] }}, color: 'rgba(40, 167, 69, 0.6)' },
            { label: 'عقود نشطة', value: {{ $report['contracts']['active'] }}, color: 'rgba(255, 193, 7, 0.6)' },
            { label: 'فاشلة', value: {{ $report['maintenance']['failed'] }}, color: 'rgba(220, 53, 69, 0.6)' }
        ];
        
        // إنشاء الرسم البياني لحالة عمليات الصيانة
        const statusCtx = document.getElementById('maintenanceStatusChart').getContext('2d');
        new Chart(statusCtx, {
            type: 'pie',
            data: {
                labels: statusData.map(item => item.label),
                datasets: [{
                    data: statusData.map(item => item.value),
                    backgroundColor: statusData.map(item => item.color),
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true
            }
        });
    });
</script>
@endsection