@extends('layouts.modern')

@section('title', 'إنشاء فواتير الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إنشاء فواتير من سجلات الصيانة المكتملة</h3>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('stats'))
                        <div class="alert alert-info">
                            <h5><i class="icon fas fa-info"></i> إحصائيات إنشاء الفواتير</h5>
                            <ul>
                                <li>عدد سجلات الصيانة المكتملة: {{ session('stats')['total'] }}</li>
                                <li>عدد الفواتير التي تم إنشاؤها: {{ session('stats')['success'] }}</li>
                                <li>عدد سجلات الصيانة التي تم تجاهلها: {{ session('stats')['total'] - session('stats')['success'] - session('stats')['failed'] }}</li>
                                <li>عدد سجلات الصيانة التي فشل إنشاء فواتير لها: {{ session('stats')['failed'] }}</li>
                            </ul>
                        </div>
                    @endif

                    <!-- نموذج إنشاء الفواتير -->
                    <form action="{{ route('maintenance-financial.process-generate-invoices') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="start_date">تاريخ البداية</label>
                                    <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}" required>
                                    <small class="form-text text-muted">سيتم البحث عن سجلات الصيانة المكتملة بدءاً من هذا التاريخ</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="end_date">تاريخ النهاية</label>
                                    <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}" required>
                                    <small class="form-text text-muted">سيتم البحث عن سجلات الصيانة المكتملة حتى هذا التاريخ</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="d-block">&nbsp;</label>
                                    <button type="submit" class="btn btn-primary">إنشاء الفواتير</button>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- معلومات عن العملية -->
                    <div class="alert alert-warning mt-4">
                        <h5><i class="icon fas fa-exclamation-triangle"></i> ملاحظات هامة</h5>
                        <ul>
                            <li>سيتم إنشاء فواتير فقط لسجلات الصيانة المكتملة التي لم يتم إنشاء فواتير لها من قبل.</li>
                            <li>سيتم استخدام أسعار الصيانة من عقود الصيانة إذا كانت متوفرة، وإلا سيتم استخدام الأسعار الافتراضية.</li>
                            <li>سيتم إضافة تكلفة قطع الغيار المستبدلة إلى الفاتورة إذا كانت متوفرة.</li>
                            <li>يمكنك تعديل الفواتير بعد إنشائها من خلال نظام الفواتير.</li>
                        </ul>
                    </div>

                    <!-- إحصائيات سجلات الصيانة -->
                    <div class="card mt-4">
                        <div class="card-header">
                            <h3 class="card-title">إحصائيات سجلات الصيانة المكتملة</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info"><i class="fas fa-clipboard-check"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">سجلات الصيانة المكتملة بدون فواتير</span>
                                            <span class="info-box-number">{{ $completedMaintenanceCount }}</span>
                                            <div class="progress">
                                                <div class="progress-bar bg-info" style="width: 100%"></div>
                                            </div>
                                            <span class="progress-description">
                                                في الفترة من {{ $startDate }} إلى {{ $endDate }}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success"><i class="fas fa-file-invoice-dollar"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الفواتير التي سيتم إنشاؤها</span>
                                            <span class="info-box-number">{{ $completedMaintenanceCount }}</span>
                                            <div class="progress">
                                                <div class="progress-bar bg-success" style="width: 100%"></div>
                                            </div>
                                            <span class="progress-description">
                                                سيتم إنشاء فاتورة لكل سجل صيانة مكتمل
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection