@extends('layouts.app')

@section('title', 'تقويم الصيانة')

@section('styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.min.css">
<style>
    #calendar {
        max-width: 1100px;
        margin: 0 auto;
        background-color: #fff;
        padding: 20px;
        border-radius: 5px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .fc-event {
        cursor: pointer;
    }
    .team-filter {
        margin-bottom: 20px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقويم الصيانة</h3>
                </div>
                <div class="card-body">
                    <div class="team-filter">
                        <form id="team-filter-form" class="form-inline">
                            <div class="form-group mb-2">
                                <label for="team_id" class="ml-2">فريق الصيانة:</label>
                                <select id="team_id" name="team_id" class="form-control">
                                    <option value="">جميع الفرق</option>
                                    @foreach($teams as $team)
                                        <option value="{{ $team->id }}">{{ $team->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary mb-2 mr-2">تصفية</button>
                        </form>
                    </div>
                    
                    <div id="calendar"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Event Details -->
<div class="modal fade" id="eventModal" tabindex="-1" role="dialog" aria-labelledby="eventModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="eventModalLabel">تفاصيل الحدث</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="eventModalBody">
                <!-- Event details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
                <a href="#" id="viewEventLink" class="btn btn-primary">عرض التفاصيل</a>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.10.1/locales/ar.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');
        var teamId = '';
        
        // Initialize the calendar
        var calendar = new FullCalendar.Calendar(calendarEl, {
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,timeGridDay,listMonth'
            },
            initialView: 'dayGridMonth',
            locale: 'ar',
            direction: 'rtl',
            events: function(info, successCallback, failureCallback) {
                // Fetch events from the server
                fetch('/maintenance-calendar/events?start=' + info.startStr + '&end=' + info.endStr + '&team_id=' + teamId)
                    .then(response => response.json())
                    .then(data => {
                        successCallback(data);
                    })
                    .catch(error => {
                        console.error('Error fetching events:', error);
                        failureCallback(error);
                    });
            },
            eventClick: function(info) {
                // Show event details in modal
                var event = info.event;
                var modalBody = document.getElementById('eventModalBody');
                
                // Format the event details
                var content = '<div class="event-details">';
                content += '<p><strong>العنوان:</strong> ' + event.title + '</p>';
                content += '<p><strong>البداية:</strong> ' + formatDate(event.start) + '</p>';
                if (event.end) {
                    content += '<p><strong>النهاية:</strong> ' + formatDate(event.end) + '</p>';
                }
                if (event.extendedProps.description) {
                    content += '<p><strong>الوصف:</strong> ' + event.extendedProps.description + '</p>';
                }
                if (event.extendedProps.team) {
                    content += '<p><strong>الفريق:</strong> ' + event.extendedProps.team + '</p>';
                }
                if (event.extendedProps.status) {
                    content += '<p><strong>الحالة:</strong> ' + event.extendedProps.status + '</p>';
                }
                content += '</div>';
                
                modalBody.innerHTML = content;
                
                // Set the link to view full details
                var viewLink = document.getElementById('viewEventLink');
                if (event.extendedProps.url) {
                    viewLink.href = event.extendedProps.url;
                    viewLink.style.display = 'block';
                } else {
                    viewLink.style.display = 'none';
                }
                
                // Show the modal
                $('#eventModal').modal('show');
            }
        });
        
        calendar.render();
        
        // Handle team filter form submission
        document.getElementById('team-filter-form').addEventListener('submit', function(e) {
            e.preventDefault();
            teamId = document.getElementById('team_id').value;
            calendar.refetchEvents();
        });
        
        // Helper function to format dates
        function formatDate(date) {
            if (!date) return '';
            return new Date(date).toLocaleString('ar-SA', {
                year: 'numeric',
                month: 'long',
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            });
        }
    });
</script>
@endsection