@extends('layouts.modern')

@section('title', 'تقويم الصيانة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تقويم الصيانة</h3>
                    <div>
                        <a href="{{ route('maintenance-schedules.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-list"></i> عرض القائمة
                        </a>
                        <a href="{{ route('maintenance-schedules.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة جدولة جديدة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-outline-primary" id="prevMonth">
                                    <i class="fas fa-chevron-right"></i> الشهر السابق
                                </button>
                                <button type="button" class="btn btn-outline-primary" id="currentMonth">
                                    الشهر الحالي
                                </button>
                                <button type="button" class="btn btn-outline-primary" id="nextMonth">
                                    الشهر التالي <i class="fas fa-chevron-left"></i>
                                </button>
                            </div>
                            <h4 class="text-center mt-3" id="calendarTitle"></h4>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="calendar-container">
                                <table class="table table-bordered calendar-table">
                                    <thead>
                                        <tr>
                                            <th>الأحد</th>
                                            <th>الإثنين</th>
                                            <th>الثلاثاء</th>
                                            <th>الأربعاء</th>
                                            <th>الخميس</th>
                                            <th>الجمعة</th>
                                            <th>السبت</th>
                                        </tr>
                                    </thead>
                                    <tbody id="calendarBody">
                                        <!-- سيتم ملء التقويم بواسطة JavaScript -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="calendar-legend d-flex justify-content-center">
                                <div class="legend-item mr-4">
                                    <span class="badge badge-info p-2">صيانة مجدولة</span>
                                </div>
                                <div class="legend-item mr-4">
                                    <span class="badge badge-success p-2">صيانة مكتملة</span>
                                </div>
                                <div class="legend-item mr-4">
                                    <span class="badge badge-danger p-2">صيانة متأخرة</span>
                                </div>
                                <div class="legend-item">
                                    <span class="badge badge-warning p-2">صيانة ملغاة</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Maintenance Details -->
<div class="modal fade" id="maintenanceModal" tabindex="-1" role="dialog" aria-labelledby="maintenanceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="maintenanceModalLabel">تفاصيل الصيانة</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="maintenanceModalBody">
                <!-- سيتم ملء المحتوى بواسطة JavaScript -->
                <div class="text-center">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">جاري التحميل...</span>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
                <a href="#" class="btn btn-primary" id="viewDetailsBtn">عرض التفاصيل</a>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تهيئة المتغيرات
        let currentDate = new Date();
        let currentMonth = currentDate.getMonth();
        let currentYear = currentDate.getFullYear();
        
        // عرض التقويم عند تحميل الصفحة
        showCalendar(currentMonth, currentYear);
        
        // أزرار التنقل بين الشهور
        $('#prevMonth').click(function() {
            currentMonth--;
            if (currentMonth < 0) {
                currentMonth = 11;
                currentYear--;
            }
            showCalendar(currentMonth, currentYear);
        });
        
        $('#currentMonth').click(function() {
            currentMonth = new Date().getMonth();
            currentYear = new Date().getFullYear();
            showCalendar(currentMonth, currentYear);
        });
        
        $('#nextMonth').click(function() {
            currentMonth++;
            if (currentMonth > 11) {
                currentMonth = 0;
                currentYear++;
            }
            showCalendar(currentMonth, currentYear);
        });
        
        // عرض التقويم
        function showCalendar(month, year) {
            // تحديث عنوان التقويم
            const monthNames = ["يناير", "فبراير", "مارس", "إبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
            $('#calendarTitle').text(monthNames[month] + ' ' + year);
            
            // الحصول على اليوم الأول من الشهر
            let firstDay = new Date(year, month, 1).getDay();
            
            // الحصول على عدد أيام الشهر
            let daysInMonth = 32 - new Date(year, month, 32).getDate();
            
            // تفريغ جسم التقويم
            let calendarBody = $('#calendarBody');
            calendarBody.empty();
            
            // بناء التقويم
            let date = 1;
            for (let i = 0; i < 6; i++) {
                // إنشاء صف جديد
                let row = $('<tr>');
                
                // إنشاء خلايا الأيام
                for (let j = 0; j < 7; j++) {
                    if (i === 0 && j < firstDay) {
                        // خلايا فارغة قبل اليوم الأول من الشهر
                        let cell = $('<td>').addClass('empty-day');
                        row.append(cell);
                    } else if (date > daysInMonth) {
                        // خلايا فارغة بعد آخر يوم من الشهر
                        break;
                    } else {
                        // خلايا الأيام
                        let cell = $('<td>');
                        let dayDiv = $('<div>').addClass('calendar-day');
                        
                        // إضافة رقم اليوم
                        let dayNumber = $('<div>').addClass('day-number').text(date);
                        dayDiv.append(dayNumber);
                        
                        // إضافة حاوية للأحداث
                        let eventsContainer = $('<div>').addClass('day-events');
                        dayDiv.append(eventsContainer);
                        
                        // تحديد اليوم الحالي
                        if (date === new Date().getDate() && month === new Date().getMonth() && year === new Date().getFullYear()) {
                            cell.addClass('current-day');
                        }
                        
                        // إضافة معرف اليوم للبحث عن الأحداث
                        let formattedDate = year + '-' + String(month + 1).padStart(2, '0') + '-' + String(date).padStart(2, '0');
                        cell.attr('data-date', formattedDate);
                        
                        cell.append(dayDiv);
                        row.append(cell);
                        date++;
                    }
                }
                
                calendarBody.append(row);
                
                // إذا انتهت أيام الشهر، توقف عن إنشاء صفوف جديدة
                if (date > daysInMonth) {
                    break;
                }
            }
            
            // تحميل أحداث الصيانة للشهر
            loadMaintenanceEvents(month + 1, year);
        }
        
        // تحميل أحداث الصيانة
        function loadMaintenanceEvents(month, year) {
            $.ajax({
                url: '/api/maintenance-schedules/monthly',
                type: 'GET',
                data: {
                    month: month,
                    year: year
                },
                success: function(response) {
                    if (response.status === 'success') {
                        // إضافة أحداث الصيانة إلى التقويم
                        $.each(response.data, function(date, schedules) {
                            let cell = $('td[data-date="' + date + '"]');
                            let eventsContainer = cell.find('.day-events');
                            
                            // إضافة كل حدث صيانة
                            $.each(schedules, function(index, schedule) {
                                let eventClass = '';
                                switch(schedule.status) {
                                    case 'scheduled':
                                        eventClass = 'bg-info';
                                        break;
                                    case 'completed':
                                        eventClass = 'bg-success';
                                        break;
                                    case 'missed':
                                        eventClass = 'bg-danger';
                                        break;
                                    case 'cancelled':
                                        eventClass = 'bg-warning';
                                        break;
                                    default:
                                        eventClass = 'bg-secondary';
                                }
                                
                                let eventDiv = $('<div>')
                                    .addClass('calendar-event ' + eventClass)
                                    .attr('data-schedule-id', schedule.id)
                                    .text(schedule.elevator.model + ' - ' + schedule.elevator.serial_number);
                                
                                eventsContainer.append(eventDiv);
                            });
                        });
                        
                        // إضافة معالج النقر على أحداث الصيانة
                        $('.calendar-event').click(function() {
                            let scheduleId = $(this).data('schedule-id');
                            showMaintenanceDetails(scheduleId);
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading maintenance events:', error);
                }
            });
        }
        
        // عرض تفاصيل الصيانة
        function showMaintenanceDetails(scheduleId) {
            // عرض النافذة المنبثقة
            $('#maintenanceModal').modal('show');
            
            // تحميل تفاصيل الصيانة
            $.ajax({
                url: '/api/maintenance-schedules/' + scheduleId,
                type: 'GET',
                success: function(response) {
                    // تحديث رابط عرض التفاصيل
                    $('#viewDetailsBtn').attr('href', '/maintenance-schedules/' + scheduleId);
                    
                    // بناء محتوى النافذة المنبثقة
                    let content = `
                        <div class="row">
                            <div class="col-md-6">
                                <h6>معلومات المصعد</h6>
                                <p><strong>الطراز:</strong> ${response.elevator.model}</p>
                                <p><strong>الرقم التسلسلي:</strong> ${response.elevator.serial_number}</p>
                                <p><strong>الموقع:</strong> ${response.elevator.location ? response.elevator.location.name : 'غير محدد'}</p>
                            </div>
                            <div class="col-md-6">
                                <h6>معلومات الصيانة</h6>
                                <p><strong>تاريخ الصيانة:</strong> ${response.scheduled_date}</p>
                                <p><strong>الحالة:</strong> 
                                    ${response.status === 'scheduled' ? '<span class="badge badge-info">مجدولة</span>' : 
                                     (response.status === 'completed' ? '<span class="badge badge-success">مكتملة</span>' : 
                                     (response.status === 'missed' ? '<span class="badge badge-danger">متأخرة</span>' : 
                                     '<span class="badge badge-warning">ملغاة</span>'))}
                                </p>
                                <p><strong>العقد:</strong> ${response.maintenance_contract ? response.maintenance_contract.contract_number : 'غير مرتبط بعقد'}</p>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <h6>ملاحظات</h6>
                                <p>${response.notes || 'لا توجد ملاحظات'}</p>
                            </div>
                        </div>
                    `;
                    
                    // تحديث محتوى النافذة المنبثقة
                    $('#maintenanceModalBody').html(content);
                },
                error: function(xhr, status, error) {
                    console.error('Error loading maintenance details:', error);
                    $('#maintenanceModalBody').html('<div class="alert alert-danger">حدث خطأ أثناء تحميل التفاصيل</div>');
                }
            });
        }
    });
</script>
@endsection

@section('styles')
<style>
    .calendar-table {
        table-layout: fixed;
    }
    
    .calendar-table th {
        text-align: center;
        background-color: #f8f9fa;
    }
    
    .calendar-day {
        min-height: 100px;
        padding: 5px;
    }
    
    .day-number {
        font-weight: bold;
        margin-bottom: 5px;
    }
    
    .day-events {
        display: flex;
        flex-direction: column;
        gap: 5px;
    }
    
    .calendar-event {
        padding: 3px 5px;
        border-radius: 3px;
        font-size: 0.8rem;
        color: white;
        cursor: pointer;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .calendar-event:hover {
        opacity: 0.8;
    }
    
    .current-day {
        background-color: rgba(0, 123, 255, 0.1);
    }
    
    .empty-day {
        background-color: #f8f9fa;
    }
    
    .calendar-legend {
        display: flex;
        justify-content: center;
        margin-top: 20px;
    }
    
    .legend-item {
        display: flex;
        align-items: center;
        margin-right: 15px;
    }
</style>
@endsection