@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('قائمة عقود الصيانة') }}</span>
                    <a href="{{ route('maintenance-contracts.create') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus"></i> {{ __('إضافة عقد صيانة جديد') }}
                    </a>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    @if(count($contracts) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('رقم العقد') }}</th>
                                        <th>{{ __('العنوان') }}</th>
                                        <th>{{ __('العميل') }}</th>
                                        <th>{{ __('تاريخ البدء') }}</th>
                                        <th>{{ __('تاريخ الانتهاء') }}</th>
                                        <th>{{ __('المبلغ الإجمالي') }}</th>
                                        <th>{{ __('دورة الفوترة') }}</th>
                                        <th>{{ __('الحالة') }}</th>
                                        <th>{{ __('الإجراءات') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($contracts as $index => $contract)
                                        <tr>
                                            <td>{{ $index + 1 + ($contracts->currentPage() - 1) * $contracts->perPage() }}</td>
                                            <td>{{ $contract->contract_number }}</td>
                                            <td>{{ $contract->title }}</td>
                                            <td>{{ $contract->customer ? $contract->customer->name : 'غير محدد' }}</td>
                                            <td>{{ $contract->start_date ? $contract->start_date->format('Y-m-d') : 'غير محدد' }}</td>
                                            <td>{{ $contract->end_date ? $contract->end_date->format('Y-m-d') : 'غير محدد' }}</td>
                                            <td>{{ number_format($contract->total_amount, 2) }}</td>
                                            <td>
                                                @if($contract->billing_cycle == 'monthly')
                                                    <span>شهري</span>
                                                @elseif($contract->billing_cycle == 'quarterly')
                                                    <span>ربع سنوي</span>
                                                @elseif($contract->billing_cycle == 'semi_annually')
                                                    <span>نصف سنوي</span>
                                                @elseif($contract->billing_cycle == 'annually')
                                                    <span>سنوي</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($contract->status == 'active')
                                                    <span class="badge bg-success">نشط</span>
                                                @elseif($contract->status == 'draft')
                                                    <span class="badge bg-warning">مسودة</span>
                                                @elseif($contract->status == 'expired')
                                                    <span class="badge bg-danger">منتهي</span>
                                                @elseif($contract->status == 'cancelled')
                                                    <span class="badge bg-secondary">ملغي</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('maintenance-contracts.show', $contract->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('maintenance-contracts.edit', $contract->id) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('maintenance-contracts.destroy', $contract->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا العقد؟');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-center mt-4">
                            {{ $contracts->links() }}
                        </div>
                    @else
                        <div class="alert alert-info text-center">
                            {{ __('لا توجد عقود صيانة مسجلة حتى الآن') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection