@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('إضافة عقد صيانة جديد') }}</span>
                    <a href="{{ route('maintenance-contracts.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-right"></i> {{ __('العودة إلى قائمة العقود') }}
                    </a>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    <form method="POST" action="{{ route('maintenance-contracts.store') }}">
                        @csrf

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="customer_id" class="form-label">{{ __('العميل') }} <span class="text-danger">*</span></label>
                                    <select class="form-control @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                        <option value="">{{ __('اختر العميل') }}</option>
                                        @foreach($customers as $customer)
                                            <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>
                                                {{ $customer->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('customer_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="contract_number" class="form-label">{{ __('رقم العقد') }} <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('contract_number') is-invalid @enderror" id="contract_number" name="contract_number" value="{{ old('contract_number') }}" required>
                                    @error('contract_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="title" class="form-label">{{ __('عنوان العقد') }} <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required>
                                    @error('title')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="start_date" class="form-label">{{ __('تاريخ بدء العقد') }} <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date') }}" required>
                                    @error('start_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="end_date" class="form-label">{{ __('تاريخ انتهاء العقد') }} <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('end_date') is-invalid @enderror" id="end_date" name="end_date" value="{{ old('end_date') }}" required>
                                    @error('end_date')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="total_amount" class="form-label">{{ __('المبلغ الإجمالي') }} <span class="text-danger">*</span></label>
                                    <input type="number" step="0.01" min="0" class="form-control @error('total_amount') is-invalid @enderror" id="total_amount" name="total_amount" value="{{ old('total_amount') }}" required>
                                    @error('total_amount')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="billing_cycle" class="form-label">{{ __('دورة الفوترة') }} <span class="text-danger">*</span></label>
                                    <select class="form-control @error('billing_cycle') is-invalid @enderror" id="billing_cycle" name="billing_cycle" required>
                                        <option value="">{{ __('اختر دورة الفوترة') }}</option>
                                        <option value="monthly" {{ old('billing_cycle') == 'monthly' ? 'selected' : '' }}>{{ __('شهري') }}</option>
                                        <option value="quarterly" {{ old('billing_cycle') == 'quarterly' ? 'selected' : '' }}>{{ __('ربع سنوي') }}</option>
                                        <option value="semi_annually" {{ old('billing_cycle') == 'semi_annually' ? 'selected' : '' }}>{{ __('نصف سنوي') }}</option>
                                        <option value="annually" {{ old('billing_cycle') == 'annually' ? 'selected' : '' }}>{{ __('سنوي') }}</option>
                                    </select>
                                    @error('billing_cycle')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group mb-3">
                                    <label for="visits_per_year" class="form-label">{{ __('عدد الزيارات في السنة') }} <span class="text-danger">*</span></label>
                                    <input type="number" min="1" class="form-control @error('visits_per_year') is-invalid @enderror" id="visits_per_year" name="visits_per_year" value="{{ old('visits_per_year') }}" required>
                                    @error('visits_per_year')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="elevator_ids" class="form-label">{{ __('المصاعد المشمولة في العقد') }} <span class="text-danger">*</span></label>
                                    <select class="form-control @error('elevator_ids') is-invalid @enderror" id="elevator_ids" name="elevator_ids[]" multiple required>
                                        @foreach($elevators as $elevator)
                                            <option value="{{ $elevator->id }}" {{ (is_array(old('elevator_ids')) && in_array($elevator->id, old('elevator_ids'))) ? 'selected' : '' }}>
                                                {{ $elevator->serial_number }} - {{ $elevator->model }} ({{ $elevator->customer ? $elevator->customer->name : 'غير محدد' }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">{{ __('يمكنك اختيار أكثر من مصعد باستخدام زر Ctrl أو Shift') }}</small>
                                    @error('elevator_ids')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="terms_conditions" class="form-label">{{ __('الشروط والأحكام') }}</label>
                                    <textarea class="form-control @error('terms_conditions') is-invalid @enderror" id="terms_conditions" name="terms_conditions" rows="4">{{ old('terms_conditions') }}</textarea>
                                    @error('terms_conditions')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-12">
                                <div class="form-group mb-3">
                                    <label for="notes" class="form-label">{{ __('ملاحظات') }}</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mb-0">
                            <div class="col-md-12 text-center">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> {{ __('حفظ العقد') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // عند تغيير العميل، قم بتحديث قائمة المصاعد
        $('#customer_id').change(function() {
            var customerId = $(this).val();
            if (customerId) {
                // يمكن إضافة طلب AJAX هنا لتحديث قائمة المصاعد بناءً على العميل المحدد
            }
        });
    });
</script>
@endsection