@extends('layouts.modern')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">نقاط الولاء للعميل: {{ $customer->name }}</h5>
                    <div>
                        <a href="{{ route('loyalty-points.create', ['customer_id' => $customer->id]) }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> إضافة نقاط
                        </a>
                        <a href="{{ route('customers.show', $customer->id) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة لصفحة العميل
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="alert alert-info">
                        <h5>إجمالي النقاط النشطة: <strong>{{ $totalPoints }}</strong></h5>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>النقاط</th>
                                    <th>النوع</th>
                                    <th>المصدر</th>
                                    <th>الوصف</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>المستخدم</th>
                                    <th>تاريخ الإضافة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($loyaltyPoints as $point)
                                    <tr>
                                        <td>{{ $point->id }}</td>
                                        <td>
                                            @if($point->amount > 0)
                                                <span class="text-success">+{{ $point->amount }}</span>
                                            @else
                                                <span class="text-danger">{{ $point->amount }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @switch($point->type)
                                                @case('earned')
                                                    <span class="badge bg-success">مكتسبة</span>
                                                    @break
                                                @case('redeemed')
                                                    <span class="badge bg-primary">مستخدمة</span>
                                                    @break
                                                @case('expired')
                                                    <span class="badge bg-danger">منتهية</span>
                                                    @break
                                                @case('adjusted')
                                                    <span class="badge bg-warning">تعديل</span>
                                                    @break
                                            @endswitch
                                        </td>
                                        <td>{{ $point->source }}</td>
                                        <td>{{ $point->description ?: 'لا يوجد' }}</td>
                                        <td>{{ $point->expiry_date ? $point->expiry_date->format('Y-m-d') : 'غير محدد' }}</td>
                                        <td>{{ $point->user->name }}</td>
                                        <td>{{ $point->created_at->format('Y-m-d H:i') }}</td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('loyalty-points.show', $point->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('loyalty-points.edit', $point->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('loyalty-points.destroy', $point->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه النقاط؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد نقاط ولاء لهذا العميل</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $loyaltyPoints->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection