@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('تفاصيل الموقع') }}</span>
                    <div>
                        <a href="{{ route('locations.edit', $location->id) }}" class="btn btn-primary btn-sm mx-1">
                            <i class="fas fa-edit"></i> {{ __('تعديل') }}
                        </a>
                        <a href="{{ route('locations.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-right"></i> {{ __('العودة إلى قائمة المواقع') }}
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="card">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">{{ __('معلومات الموقع الأساسية') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>{{ __('اسم الموقع:') }}</strong>
                                        <p>{{ $location->name }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('نوع الموقع:') }}</strong>
                                        <p>
                                            @if($location->location_type == 'residential')
                                                <span class="badge bg-primary">سكني</span>
                                            @elseif($location->location_type == 'commercial')
                                                <span class="badge bg-success">تجاري</span>
                                            @elseif($location->location_type == 'industrial')
                                                <span class="badge bg-warning">صناعي</span>
                                            @elseif($location->location_type == 'government')
                                                <span class="badge bg-info">حكومي</span>
                                            @elseif($location->location_type == 'educational')
                                                <span class="badge bg-secondary">تعليمي</span>
                                            @elseif($location->location_type == 'healthcare')
                                                <span class="badge bg-danger">رعاية صحية</span>
                                            @else
                                                <span class="badge bg-dark">أخرى</span>
                                            @endif
                                        </p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('العميل:') }}</strong>
                                        <p>{{ $location->customer ? $location->customer->name : 'غير محدد' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="card">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">{{ __('معلومات العنوان') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>{{ __('العنوان:') }}</strong>
                                        <p>{{ $location->address }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('المدينة:') }}</strong>
                                        <p>{{ $location->city }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('المنطقة/المحافظة:') }}</strong>
                                        <p>{{ $location->state ?: 'غير محدد' }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('الدولة:') }}</strong>
                                        <p>{{ $location->country }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('الرمز البريدي:') }}</strong>
                                        <p>{{ $location->postal_code ?: 'غير محدد' }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('رابط خرائط جوجل:') }}</strong>
                                        @if($location->google_maps_link)
                                            <p>
                                                <a href="{{ $location->google_maps_link }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-map-marker-alt"></i> {{ __('عرض الموقع على خرائط جوجل') }}
                                                </a>
                                            </p>
                                        @else
                                            <p>{{ __('غير محدد') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">{{ __('معلومات الاتصال') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>{{ __('الشخص المسؤول:') }}</strong>
                                        <p>{{ $location->contact_person ?: 'غير محدد' }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('رقم الهاتف:') }}</strong>
                                        <p>{{ $location->contact_phone ?: 'غير محدد' }}</p>
                                    </div>
                                    <div class="mb-3">
                                        <strong>{{ __('البريد الإلكتروني:') }}</strong>
                                        <p>{{ $location->contact_email ?: 'غير محدد' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="card">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="mb-0">{{ __('معلومات إضافية') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>{{ __('ملاحظات:') }}</strong>
                                        <p>{{ $location->notes ?: 'لا توجد ملاحظات' }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if($location->elevators->count() > 0)
                        <div class="col-md-12 mb-4">
                            <div class="card">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">{{ __('المصاعد في هذا الموقع') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>{{ __('الرقم التسلسلي') }}</th>
                                                    <th>{{ __('الموديل') }}</th>
                                                    <th>{{ __('الشركة المصنعة') }}</th>
                                                    <th>{{ __('النوع') }}</th>
                                                    <th>{{ __('الحالة') }}</th>
                                                    <th>{{ __('تاريخ التركيب') }}</th>
                                                    <th>{{ __('الإجراءات') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($location->elevators as $index => $elevator)
                                                    <tr>
                                                        <td>{{ $index + 1 }}</td>
                                                        <td>{{ $elevator->serial_number }}</td>
                                                        <td>{{ $elevator->model }}</td>
                                                        <td>{{ $elevator->manufacturer }}</td>
                                                        <td>
                                                            @if($elevator->type == 'passenger')
                                                                <span class="badge bg-primary">مصعد ركاب</span>
                                                            @elseif($elevator->type == 'freight')
                                                                <span class="badge bg-secondary">مصعد بضائع</span>
                                                            @elseif($elevator->type == 'hospital')
                                                                <span class="badge bg-danger">مصعد مستشفى</span>
                                                            @elseif($elevator->type == 'panoramic')
                                                                <span class="badge bg-info">مصعد بانورامي</span>
                                                            @elseif($elevator->type == 'residential')
                                                                <span class="badge bg-success">مصعد سكني</span>
                                                            @elseif($elevator->type == 'commercial')
                                                                <span class="badge bg-warning">مصعد تجاري</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if($elevator->status == 'operational')
                                                                <span class="badge bg-success">يعمل</span>
                                                            @elseif($elevator->status == 'maintenance')
                                                                <span class="badge bg-warning">تحت الصيانة</span>
                                                            @elseif($elevator->status == 'out_of_service')
                                                                <span class="badge bg-danger">خارج الخدمة</span>
                                                            @elseif($elevator->status == 'installation')
                                                                <span class="badge bg-info">قيد التركيب</span>
                                                            @endif
                                                        </td>
                                                        <td>{{ $elevator->installation_date ? $elevator->installation_date->format('Y-m-d') : 'غير محدد' }}</td>
                                                        <td>
                                                            <a href="{{ route('elevators.show', $elevator->id) }}" class="btn btn-info btn-sm">
                                                                <i class="fas fa-eye"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection