@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>{{ __('قائمة المواقع') }}</span>
                    <div>
                        <a href="{{ route('locations.import.form') }}" class="btn btn-success btn-sm me-2">
                            <i class="fas fa-file-excel"></i> {{ __('استيراد من اكسيل') }}
                        </a>
                        <a href="{{ route('locations.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> {{ __('إضافة موقع جديد') }}
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @include('layouts.alerts')

                    @if(count($locations) > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('اسم الموقع') }}</th>
                                        <th>{{ __('العميل') }}</th>
                                        <th>{{ __('المدينة') }}</th>
                                        <th>{{ __('نوع الموقع') }}</th>
                                        <th>{{ __('الشخص المسؤول') }}</th>
                                        <th>{{ __('رقم الهاتف') }}</th>
                                        <th>{{ __('الإجراءات') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($locations as $index => $location)
                                        <tr>
                                            <td>{{ $index + 1 + ($locations->currentPage() - 1) * $locations->perPage() }}</td>
                                            <td>{{ $location->name }}</td>
                                            <td>{{ $location->customer ? $location->customer->name : 'غير محدد' }}</td>
                                            <td>{{ $location->city }}</td>
                                            <td>
                                                @if($location->location_type == 'residential')
                                                    <span class="badge bg-primary">سكني</span>
                                                @elseif($location->location_type == 'commercial')
                                                    <span class="badge bg-success">تجاري</span>
                                                @elseif($location->location_type == 'industrial')
                                                    <span class="badge bg-warning">صناعي</span>
                                                @elseif($location->location_type == 'government')
                                                    <span class="badge bg-info">حكومي</span>
                                                @elseif($location->location_type == 'educational')
                                                    <span class="badge bg-secondary">تعليمي</span>
                                                @elseif($location->location_type == 'healthcare')
                                                    <span class="badge bg-danger">رعاية صحية</span>
                                                @else
                                                    <span class="badge bg-dark">أخرى</span>
                                                @endif
                                            </td>
                                            <td>{{ $location->contact_person ?: 'غير محدد' }}</td>
                                            <td>{{ $location->contact_phone ?: 'غير محدد' }}</td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="{{ route('locations.show', $location->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('locations.edit', $location->id) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="{{ route('locations.destroy', $location->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا الموقع؟');">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger btn-sm" title="حذف">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="d-flex justify-content-center mt-4">
                            {{ $locations->links() }}
                        </div>
                    @else
                        <div class="alert alert-info text-center">
                            {{ __('لا توجد مواقع مسجلة حتى الآن') }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection