@extends('layouts.modern')

@section('title', 'استيراد المواقع')

@section('header', 'استيراد المواقع من ملف Excel')

@section('content')
<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
        <h6 class="m-0 font-weight-bold text-primary">استيراد المواقع من ملف Excel</h6>
        <div>
            <a href="{{ route('locations.import.template') }}" class="btn btn-success btn-sm">
                <i class="bi bi-file-earmark-excel"></i> تحميل قالب الاستيراد
            </a>
            <a href="{{ route('locations.index') }}" class="btn btn-secondary btn-sm">
                <i class="bi bi-arrow-right"></i> العودة إلى قائمة المواقع
            </a>
        </div>
    </div>

    <div class="card-body">
        @include('layouts.alerts')

        <div class="alert alert-info">
            <h5><i class="bi bi-info-circle"></i> تعليمات الاستيراد:</h5>
            <ul>
                <li>يجب أن يكون الملف بتنسيق Excel (.xlsx, .xls) أو CSV.</li>
                <li>يجب أن يحتوي الملف على العناوين التالية في الصف الأول:
                    <ul>
                        <li><code>name</code> - اسم الموقع (إلزامي)</li>
                        <li><code>customer_id</code> - معرف العميل (إلزامي إذا لم يتوفر customer_name)</li>
                        <li><code>customer_name</code> - اسم العميل (إلزامي إذا لم يتوفر customer_id)</li>
                        <li><code>branch_id</code> - معرف الفرع (اختياري)</li>
                        <li><code>address</code> - العنوان (اختياري)</li>
                        <li><code>city</code> - المدينة (اختياري)</li>
                        <li><code>state</code> - المنطقة (اختياري)</li>
                        <li><code>country</code> - البلد (اختياري)</li>
                        <li><code>postal_code</code> - الرمز البريدي (اختياري)</li>
                        <li><code>contact_person</code> - الشخص المسؤول (اختياري)</li>
                        <li><code>contact_phone</code> - هاتف المسؤول (اختياري)</li>
                        <li><code>contact_email</code> - بريد المسؤول (اختياري)</li>
                        <li><code>google_maps_link</code> - رابط خرائط جوجل (اختياري)</li>
                        <li><code>notes</code> - ملاحظات (اختياري)</li>
                    </ul>
                </li>
                <li>سيتم تجاهل المواقع المكررة لنفس العميل.</li>
                <li>إذا تم استخدام <code>customer_name</code>، يجب أن يكون الاسم مطابقاً تماماً لاسم العميل الموجود في النظام.</li>
            </ul>
        </div>

        <div class="alert alert-warning">
            <h5><i class="bi bi-exclamation-triangle"></i> ملاحظة هامة:</h5>
            <p>يجب التأكد من صحة معرفات العملاء والفروع قبل الاستيراد. يمكنك الاطلاع على قائمة العملاء والفروع من خلال الروابط التالية:</p>
            <ul>
                <li><a href="{{ route('customers.index') }}" target="_blank">قائمة العملاء</a></li>
                <li><a href="{{ route('branches.index') }}" target="_blank">قائمة الفروع</a></li>
            </ul>
        </div>

        <form action="{{ route('locations.import') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="mb-3">
                <label for="file" class="form-label">ملف Excel</label>
                <input type="file" class="form-control @error('file') is-invalid @enderror" id="file" name="file" required>
                @error('file')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
            </div>

            <div class="mb-3">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-file-earmark-arrow-up"></i> استيراد
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
