<div class="sidebar">
    <nav class="mt-1">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
            <!-- لوحة التحكم -->
            <li class="nav-item">
                <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-tachometer-alt"></i>
                    <p>لوحة التحكم</p>
                </a>
            </li>

            <!-- نظام الإشعارات -->
            <li class="nav-item {{ request()->routeIs('notifications.*') || request()->routeIs('notification-settings.*') || request()->routeIs('notification-logs.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('notifications.*') || request()->routeIs('notification-settings.*') || request()->routeIs('notification-logs.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-bell"></i>
                    <p>
                        نظام الإشعارات
                        <span class="badge badge-danger right" id="sidebar-notification-count">0</span>
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('notifications.index') }}" class="nav-link {{ request()->routeIs('notifications.index') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الإشعارات</p>
                        </a>
                    </li>
                    
                    @if(auth()->check() && auth()->user()->hasPermission('view_urgent_notifications'))
                    <li class="nav-item">
                        <a href="{{ route('notifications.urgent') }}" class="nav-link {{ request()->routeIs('notifications.urgent') ? 'active' : '' }}">
                            <i class="fas fa-exclamation-circle nav-icon"></i>
                            <p>الإشعارات العاجلة</p>
                        </a>
                    </li>
                    @endif
                    
                    @if(auth()->check() && auth()->user()->hasPermission('manage_notification_settings'))
                    <li class="nav-item">
                        <a href="{{ route('notification-settings.index') }}" class="nav-link {{ request()->routeIs('notification-settings.*') ? 'active' : '' }}">
                            <i class="fas fa-cog nav-icon"></i>
                            <p>إعدادات الإشعارات</p>
                        </a>
                    </li>
                    @endif
                    
                    @if(auth()->check() && auth()->user()->hasPermission('view_notification_logs'))
                    <li class="nav-item">
                        <a href="{{ route('notification-logs.index') }}" class="nav-link {{ request()->routeIs('notification-logs.*') ? 'active' : '' }}">
                            <i class="fas fa-history nav-icon"></i>
                            <p>سجلات الإشعارات</p>
                        </a>
                    </li>
                    @endif
                    
                    @if(auth()->check() && auth()->user()->hasPermission('run_maintenance_notifications'))
                    <li class="nav-item">
                        <a href="{{ route('notifications.run-maintenance-check') }}" class="nav-link {{ request()->routeIs('notifications.run-maintenance-check') ? 'active' : '' }}">
                            <i class="fas fa-sync nav-icon"></i>
                            <p>تشغيل فحص الصيانة</p>
                        </a>
                    </li>
                    @endif
                </ul>
            </li>

            <!-- إدارة المستخدمين -->
            @if(auth()->check() && (auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')))
            <li class="nav-item {{ request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-users-cog"></i>
                    <p>
                        إدارة المستخدمين
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('users.index') }}" class="nav-link {{ request()->routeIs('users.index') ? 'active' : '' }}">
                            <i class="fas fa-user-friends nav-icon"></i>
                            <p>قائمة المستخدمين</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('users.create') }}" class="nav-link {{ request()->routeIs('users.create') ? 'active' : '' }}">
                            <i class="fas fa-user-plus nav-icon"></i>
                            <p>إضافة مستخدم جديد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('roles.index') }}" class="nav-link {{ request()->routeIs('roles.index') ? 'active' : '' }}">
                            <i class="fas fa-user-shield nav-icon"></i>
                            <p>الأدوار والصلاحيات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('roles.manage-users') }}" class="nav-link {{ request()->routeIs('roles.manage-users') ? 'active' : '' }}">
                            <i class="fas fa-user-cog nav-icon"></i>
                            <p>إدارة أدوار المستخدمين</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('roles.edit-user-roles', ['user' => auth()->id()]) }}" class="nav-link {{ request()->routeIs('roles.edit-user-roles') ? 'active' : '' }}">
                            <i class="fas fa-user-tag nav-icon"></i>
                            <p>تعديل أدوار المستخدم</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('permissions.index') }}" class="nav-link {{ request()->routeIs('permissions.index') && !request()->routeIs('permissions.create') && !request()->routeIs('permissions.edit') && !request()->routeIs('permissions.show') ? 'active' : '' }}">
                            <i class="fas fa-key nav-icon"></i>
                            <p>قائمة الصلاحيات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('permissions.create') }}" class="nav-link {{ request()->routeIs('permissions.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة صلاحية جديدة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('permissions.manage-users') }}" class="nav-link {{ request()->routeIs('permissions.manage-users') ? 'active' : '' }}">
                            <i class="fas fa-user-lock nav-icon"></i>
                            <p>إدارة صلاحيات المستخدمين</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('permissions.edit-user-permissions', ['user' => auth()->id()]) }}" class="nav-link {{ request()->routeIs('permissions.edit-user-permissions') ? 'active' : '' }}">
                            <i class="fas fa-user-edit nav-icon"></i>
                            <p>تعديل صلاحيات المستخدم</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('permissions.generate-from-controllers') }}" class="nav-link {{ request()->routeIs('permissions.generate-from-controllers') ? 'active' : '' }}">
                            <i class="fas fa-sync nav-icon"></i>
                            <p>توليد الصلاحيات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('temp.permissions.manage-users') }}" class="nav-link {{ request()->routeIs('temp.permissions.*') ? 'active' : '' }}">
                            <i class="fas fa-key nav-icon"></i>
                            <p>إدارة صلاحيات المستخدمين (مؤقت)</p>
                        </a>
                    </li>
                </ul>
            </li>
            @endif

            <!-- الإعدادات -->
            @if(auth()->check() && (auth()->user()->hasPermission('manage_settings') || auth()->user()->hasPermission('view_settings') || auth()->user()->hasRole('super_admin') || auth()->user()->hasRole('admin')))
            <li class="nav-item {{ request()->routeIs('tax_settings.*') || request()->routeIs('settings.*') || request()->routeIs('notification-settings.*') || request()->routeIs('inventory.alerts.settings') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('tax_settings.*') || request()->routeIs('settings.*') || request()->routeIs('notification-settings.*') || request()->routeIs('inventory.alerts.settings') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-cogs"></i>
                    <p>
                        الإعدادات
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('tax_settings.index') }}" class="nav-link {{ request()->routeIs('tax_settings.index') ? 'active' : '' }}">    
                            <i class="fas fa-percent nav-icon"></i>
                            <p>إعدادات الضرائب</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('settings.index') }}" class="nav-link {{ request()->routeIs('settings.index') ? 'active' : '' }}">
                            <i class="fas fa-cog nav-icon"></i>
                            <p>الإعدادات العامة</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('notification-settings.index') }}" class="nav-link {{ request()->routeIs('notification-settings.index') ? 'active' : '' }}">
                            <i class="fas fa-bell nav-icon"></i>
                            <p>إعدادات الإشعارات</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('inventory.alerts.settings') }}" class="nav-link {{ request()->routeIs('inventory.alerts.settings') ? 'active' : '' }}">
                            <i class="fas fa-exclamation-triangle nav-icon"></i>
                            <p>إعدادات تنبيهات المخزون</p>
                        </a>
                    </li>
                </ul>
            </li>
            @endif
        </ul>
    </nav>
</div>