<div class="sidebar">
    <nav class="mt-1">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
            <!-- لوحة التحكم -->
            <li class="nav-item">
                <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-tachometer-alt"></i>
                    <p>لوحة التحكم</p>
                </a>
            </li>

            <!-- نظام الأمان -->
            <li class="nav-item {{ request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-shield-alt"></i>
                    <p>
                        نظام الأمان
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('roles.index') }}" class="nav-link {{ request()->routeIs('roles.index') ? 'active' : '' }}">
                            <i class="fas fa-user-tag nav-icon"></i>
                            <p>إدارة الأدوار</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('roles.create') }}" class="nav-link {{ request()->routeIs('roles.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة دور جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('roles.manage-users') }}" class="nav-link {{ request()->routeIs('roles.manage-users') ? 'active' : '' }}">
                            <i class="fas fa-users-cog nav-icon"></i>
                            <p>إدارة أدوار المستخدمين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.index') }}" class="nav-link {{ request()->routeIs('permissions.index') ? 'active' : '' }}">
                            <i class="fas fa-key nav-icon"></i>
                            <p>إدارة الصلاحيات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.create') }}" class="nav-link {{ request()->routeIs('permissions.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة صلاحية جديدة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.manage-users') }}" class="nav-link {{ request()->routeIs('permissions.manage-users') ? 'active' : '' }}">
                            <i class="fas fa-user-lock nav-icon"></i>
                            <p>إدارة صلاحيات المستخدمين</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- نظام الإشعارات -->
            <li class="nav-item {{ request()->routeIs('notifications.*') || request()->routeIs('notification-settings.*') || request()->routeIs('notification-logs.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('notifications.*') || request()->routeIs('notification-settings.*') || request()->routeIs('notification-logs.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-bell"></i>
                    <p>
                        نظام الإشعارات
                        <span class="badge badge-danger right" id="sidebar-notification-count">0</span>
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('notifications.index') }}" class="nav-link {{ request()->routeIs('notifications.index') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الإشعارات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('notifications.urgent') }}" class="nav-link {{ request()->routeIs('notifications.urgent') ? 'active' : '' }}">
                            <i class="fas fa-exclamation-circle nav-icon"></i>
                            <p>الإشعارات العاجلة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('notification-settings.index') }}" class="nav-link {{ request()->routeIs('notification-settings.*') ? 'active' : '' }}">
                            <i class="fas fa-cog nav-icon"></i>
                            <p>إعدادات الإشعارات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('notification-logs.index') }}" class="nav-link {{ request()->routeIs('notification-logs.*') ? 'active' : '' }}">
                            <i class="fas fa-history nav-icon"></i>
                            <p>سجلات الإشعارات</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- النظام المحاسبي -->
            <li class="nav-item {{ request()->routeIs('accounting.*') || request()->routeIs('chart-of-accounts.*') || request()->routeIs('journal-entries.*') || request()->routeIs('journal-templates.*') || request()->routeIs('fiscal-years.*') || request()->routeIs('accounting-periods.*') || request()->routeIs('financial-statements.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('accounting.*') || request()->routeIs('chart-of-accounts.*') || request()->routeIs('journal-entries.*') || request()->routeIs('journal-templates.*') || request()->routeIs('fiscal-years.*') || request()->routeIs('accounting-periods.*') || request()->routeIs('financial-statements.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-calculator"></i>
                    <p>
                        النظام المحاسبي
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('accounting.dashboard') }}" class="nav-link {{ request()->routeIs('accounting.dashboard') ? 'active' : '' }}">
                            <i class="fas fa-tachometer-alt nav-icon"></i>
                            <p>لوحة التحكم المحاسبية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('chart-of-accounts.index') }}" class="nav-link {{ request()->routeIs('chart-of-accounts.index') ? 'active' : '' }}">
                            <i class="fas fa-book nav-icon"></i>
                            <p>دليل الحسابات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('chart-of-accounts.create') }}" class="nav-link {{ request()->routeIs('chart-of-accounts.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة حساب جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('chart-of-accounts.tree') }}" class="nav-link {{ request()->routeIs('chart-of-accounts.tree') ? 'active' : '' }}">
                            <i class="fas fa-sitemap nav-icon"></i>
                            <p>شجرة الحسابات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('journal-entries.index') }}" class="nav-link {{ request()->routeIs('journal-entries.index') ? 'active' : '' }}">
                            <i class="fas fa-file-invoice nav-icon"></i>
                            <p>القيود المحاسبية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('journal-entries.create') }}" class="nav-link {{ request()->routeIs('journal-entries.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة قيد محاسبي</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('journal-templates.index') }}" class="nav-link {{ request()->routeIs('journal-templates.index') ? 'active' : '' }}">
                            <i class="fas fa-copy nav-icon"></i>
                            <p>قوالب القيود المحاسبية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('ledger.index') }}" class="nav-link {{ request()->routeIs('ledger.*') ? 'active' : '' }}">
                            <i class="fas fa-book nav-icon"></i>
                            <p>دفتر الأستاذ (كشف الحساب)</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('fiscal-years.index') }}" class="nav-link {{ request()->routeIs('fiscal-years.index') ? 'active' : '' }}">
                            <i class="fas fa-calendar-alt nav-icon"></i>
                            <p>السنوات المالية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('accounting-periods.index') }}" class="nav-link {{ request()->routeIs('accounting-periods.index') ? 'active' : '' }}">
                            <i class="fas fa-calendar-week nav-icon"></i>
                            <p>الفترات المحاسبية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('financial-statements.income-statement') }}" class="nav-link {{ request()->routeIs('financial-statements.income-statement') ? 'active' : '' }}">
                            <i class="fas fa-file-invoice-dollar nav-icon"></i>
                            <p>قائمة الدخل</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('financial-statements.balance-sheet') }}" class="nav-link {{ request()->routeIs('financial-statements.balance-sheet') ? 'active' : '' }}">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>الميزانية العمومية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('financial-statements.cash-flow') }}" class="nav-link {{ request()->routeIs('financial-statements.cash-flow') ? 'active' : '' }}">
                            <i class="fas fa-money-bill-wave nav-icon"></i>
                            <p>التدفقات النقدية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('chart-of-accounts.trial-balance') }}" class="nav-link {{ request()->routeIs('chart-of-accounts.trial-balance') ? 'active' : '' }}">
                            <i class="fas fa-list-ol nav-icon"></i>
                            <p>ميزان المراجعة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('account-balance-report.index') }}" class="nav-link {{ request()->routeIs('account-balance-report.index') ? 'active' : '' }}">
                            <i class="fas fa-coins nav-icon"></i>
                            <p>تقرير أرصدة الحسابات</p>
                        </a>
                    </li>
                </ul>
            </li>
            
            <!-- نظام محاضر تسليم المصاعد -->
            <li class="nav-item {{ request()->routeIs('elevator-deliveries.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('elevator-deliveries.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-clipboard-check"></i>
                    <p>
                        محاضر تسليم المصاعد
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('elevator-deliveries.index') }}" class="nav-link {{ request()->routeIs('elevator-deliveries.index') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة محاضر التسليم</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('elevator-deliveries.create') }}" class="nav-link {{ request()->routeIs('elevator-deliveries.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة محضر تسليم جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            
            <!-- نظام إدارة الخزينة -->
            <li class="nav-item {{ request()->routeIs('cash-registers.*') || request()->routeIs('cash-transactions.*') || request()->routeIs('cash-deposits.*') || request()->routeIs('cash-withdrawals.*') || request()->routeIs('cash-reports.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('cash-registers.*') || request()->routeIs('cash-transactions.*') || request()->routeIs('cash-deposits.*') || request()->routeIs('cash-withdrawals.*') || request()->routeIs('cash-reports.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-cash-register"></i>
                    <p>
                        إدارة الخزينة
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('cash-registers.index') }}" class="nav-link {{ request()->routeIs('cash-registers.index') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الخزائن</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-registers.create') }}" class="nav-link {{ request()->routeIs('cash-registers.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة خزينة جديدة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-deposits.index') }}" class="nav-link {{ request()->routeIs('cash-deposits.*') ? 'active' : '' }}">
                            <i class="fas fa-arrow-circle-down nav-icon"></i>
                            <p>إيداعات الخزينة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-withdrawals.index') }}" class="nav-link {{ request()->routeIs('cash-withdrawals.*') ? 'active' : '' }}">
                            <i class="fas fa-arrow-circle-up nav-icon"></i>
                            <p>سحوبات الخزينة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-deposits.create') }}" class="nav-link {{ request()->routeIs('cash-deposits.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة إيداع جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-withdrawals.create') }}" class="nav-link {{ request()->routeIs('cash-withdrawals.create') ? 'active' : '' }}">
                            <i class="fas fa-minus-circle nav-icon"></i>
                            <p>إضافة سحب جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-reports.index') }}" class="nav-link {{ request()->routeIs('cash-reports.index') ? 'active' : '' }}">
                            <i class="fas fa-chart-bar nav-icon"></i>
                            <p>تقارير الخزينة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-reports.daily-movement') }}" class="nav-link {{ request()->routeIs('cash-reports.daily-movement') ? 'active' : '' }}">
                            <i class="fas fa-calendar-day nav-icon"></i>
                            <p>الحركة اليومية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-reports.registers-summary') }}" class="nav-link {{ request()->routeIs('cash-reports.registers-summary') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-list nav-icon"></i>
                            <p>ملخص الخزائن</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-reports.transactions-by-period') }}" class="nav-link {{ request()->routeIs('cash-reports.transactions-by-period') ? 'active' : '' }}">
                            <i class="fas fa-calendar-alt nav-icon"></i>
                            <p>المعاملات حسب الفترة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cash-reports.daily-balance') }}" class="nav-link {{ request()->routeIs('cash-reports.daily-balance') ? 'active' : '' }}">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>الرصيد اليومي</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- نظام البنوك -->
            <li class="nav-item {{ request()->routeIs('banks.*') || request()->routeIs('bank-accounts.*') || request()->routeIs('bank-transactions.*') || request()->routeIs('cheques.*') || request()->routeIs('bank-reconciliations.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('banks.*') || request()->routeIs('bank-accounts.*') || request()->routeIs('bank-transactions.*') || request()->routeIs('cheques.*') || request()->routeIs('bank-reconciliations.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-university"></i>
                    <p>
                        نظام البنوك
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('banks.index') }}" class="nav-link {{ request()->routeIs('banks.index') ? 'active' : '' }}">
                            <i class="fas fa-university nav-icon"></i>
                            <p>قائمة البنوك</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('banks.create') }}" class="nav-link {{ request()->routeIs('banks.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة بنك جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-accounts.index') }}" class="nav-link {{ request()->routeIs('bank-accounts.index') ? 'active' : '' }}">
                            <i class="fas fa-money-check nav-icon"></i>
                            <p>الحسابات البنكية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-accounts.create') }}" class="nav-link {{ request()->routeIs('bank-accounts.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة حساب بنكي</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-transactions.index') }}" class="nav-link {{ request()->routeIs('bank-transactions.index') ? 'active' : '' }}">
                            <i class="fas fa-exchange-alt nav-icon"></i>
                            <p>المعاملات البنكية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-transactions.create-deposit') }}" class="nav-link {{ request()->routeIs('bank-transactions.create-deposit') ? 'active' : '' }}">
                            <i class="fas fa-arrow-circle-down nav-icon"></i>
                            <p>إيداع بنكي</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-transactions.create-withdrawal') }}" class="nav-link {{ request()->routeIs('bank-transactions.create-withdrawal') ? 'active' : '' }}">
                            <i class="fas fa-arrow-circle-up nav-icon"></i>
                            <p>سحب بنكي</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-transactions.create-transfer') }}" class="nav-link {{ request()->routeIs('bank-transactions.create-transfer') ? 'active' : '' }}">
                            <i class="fas fa-exchange-alt nav-icon"></i>
                            <p>تحويل بنكي</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cheques.index') }}" class="nav-link {{ request()->routeIs('cheques.index') ? 'active' : '' }}">
                            <i class="fas fa-money-check-alt nav-icon"></i>
                            <p>الشيكات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cheques.create-incoming') }}" class="nav-link {{ request()->routeIs('cheques.create-incoming') ? 'active' : '' }}">
                            <i class="fas fa-sign-in-alt nav-icon"></i>
                            <p>إضافة شيك وارد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('cheques.create-outgoing') }}" class="nav-link {{ request()->routeIs('cheques.create-outgoing') ? 'active' : '' }}">
                            <i class="fas fa-sign-out-alt nav-icon"></i>
                            <p>إضافة شيك صادر</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-reconciliations.index') }}" class="nav-link {{ request()->routeIs('bank-reconciliations.index') ? 'active' : '' }}">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>التسويات البنكية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('bank-reconciliations.create') }}" class="nav-link {{ request()->routeIs('bank-reconciliations.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إنشاء تسوية بنكية</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- إدارة المستخدمين -->
            <li class="nav-item {{ request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('users.*') || request()->routeIs('roles.*') || request()->routeIs('permissions.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-users"></i>
                    <p>
                        إدارة المستخدمين
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('users.index') }}" class="nav-link {{ request()->routeIs('users.index') ? 'active' : '' }}">
                            <i class="fas fa-user nav-icon"></i>
                            <p>المستخدمين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('roles.index') }}" class="nav-link {{ request()->routeIs('roles.index') && !request()->routeIs('roles.create') && !request()->routeIs('roles.edit') && !request()->routeIs('roles.show') ? 'active' : '' }}">
                            <i class="fas fa-user-tag nav-icon"></i>
                            <p>قائمة الأدوار</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('roles.create') }}" class="nav-link {{ request()->routeIs('roles.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة دور جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('roles.manage-users') }}" class="nav-link {{ request()->routeIs('roles.manage-users') ? 'active' : '' }}">
                            <i class="fas fa-user-cog nav-icon"></i>
                            <p>إدارة أدوار المستخدمين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('roles.edit-user-roles', ['user' => auth()->id()]) }}" class="nav-link {{ request()->routeIs('roles.edit-user-roles') ? 'active' : '' }}">
                            <i class="fas fa-user-edit nav-icon"></i>
                            <p>تعديل أدوار المستخدم</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.index') }}" class="nav-link {{ request()->routeIs('permissions.index') && !request()->routeIs('permissions.create') && !request()->routeIs('permissions.edit') && !request()->routeIs('permissions.show') ? 'active' : '' }}">
                            <i class="fas fa-key nav-icon"></i>
                            <p>قائمة الصلاحيات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.create') }}" class="nav-link {{ request()->routeIs('permissions.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة صلاحية جديدة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.manage-users') }}" class="nav-link {{ request()->routeIs('permissions.manage-users') ? 'active' : '' }}">
                            <i class="fas fa-user-lock nav-icon"></i>
                            <p>إدارة صلاحيات المستخدمين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.edit-user-permissions', ['user' => auth()->id()]) }}" class="nav-link {{ request()->routeIs('permissions.edit-user-permissions') ? 'active' : '' }}">
                            <i class="fas fa-user-edit nav-icon"></i>
                            <p>تعديل صلاحيات المستخدم</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('permissions.generate-from-controllers') }}" class="nav-link {{ request()->routeIs('permissions.generate-from-controllers') ? 'active' : '' }}">
                            <i class="fas fa-sync nav-icon"></i>
                            <p>توليد الصلاحيات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('test-permissions') }}" class="nav-link {{ request()->routeIs('test-permissions') ? 'active' : '' }}">
                            <i class="fas fa-check-circle nav-icon"></i>
                            <p>اختبار الصلاحيات</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- إدارة الشركات -->
            <li class="nav-item {{ request()->routeIs('companies.*') || request()->routeIs('branches.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('companies.*') || request()->routeIs('branches.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-building"></i>
                    <p>
                        إدارة الشركات
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('companies.index') }}" class="nav-link {{ request()->routeIs('companies.index') ? 'active' : '' }}">
                            <i class="fas fa-building nav-icon"></i>
                            <p>الشركات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('branches.index') }}" class="nav-link {{ request()->routeIs('branches.*') ? 'active' : '' }}">
                            <i class="fas fa-code-branch nav-icon"></i>
                            <p>الفروع</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- إدارة العملاء -->
            <li class="nav-item {{ request()->routeIs('customers.*') || request()->routeIs('customer-interactions.*') || request()->routeIs('customer-rewards.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('customers.*') || request()->routeIs('customer-interactions.*') || request()->routeIs('customer-rewards.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-user-tie"></i>
                    <p>
                        إدارة العملاء
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('customers.index') }}" class="nav-link {{ request()->routeIs('customers.index') ? 'active' : '' }}">
                            <i class="fas fa-users nav-icon"></i>
                            <p>قائمة العملاء</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('customers.create') }}" class="nav-link {{ request()->routeIs('customers.create') ? 'active' : '' }}">
                            <i class="fas fa-user-plus nav-icon"></i>
                            <p>إضافة عميل</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('locations.index') }}" class="nav-link {{ request()->routeIs('locations.index') ? 'active' : '' }}">
                            <i class="fas fa-map-marker-alt nav-icon"></i>
                            <p>المواقع</p>
                        </a>
                    </li>

                    <!-- تفاعلات العملاء -->
                    <li class="nav-item">
                        <a href="{{ route('customer-interactions.index') }}" class="nav-link {{ request()->routeIs('customer-interactions.*') ? 'active' : '' }}">
                            <i class="fas fa-comments nav-icon"></i>
                            <p>تفاعلات العملاء</p>
                        </a>
                    </li>

                    <!-- مكافآت العملاء -->
                    <li class="nav-item">
                        <a href="{{ route('customer-rewards.index') }}" class="nav-link {{ request()->routeIs('customer-rewards.*') ? 'active' : '' }}">
                            <i class="fas fa-gift nav-icon"></i>
                            <p>مكافآت العملاء</p>
                        </a>
                    </li>
                    
                    <!-- نقاط الولاء -->
                    <li class="nav-item">
                        <a href="{{ route('loyalty-points.index') }}" class="nav-link {{ request()->routeIs('loyalty-points.*') ? 'active' : '' }}">
                            <i class="fas fa-star nav-icon"></i>
                            <p>نقاط الولاء</p>
                        </a>
                    </li>
                    
                    <!-- الفرص التجارية -->
                    <li class="nav-item">
                        <a href="{{ route('opportunities.index') }}" class="nav-link {{ request()->routeIs('opportunities.*') ? 'active' : '' }}">
                            <i class="fas fa-handshake nav-icon"></i>
                            <p>الفرص التجارية</p>
                        </a>
                    </li>
                    
                    <!-- الحملات التسويقية -->
                    <li class="nav-item">
                        <a href="{{ route('marketing-campaigns.index') }}" class="nav-link {{ request()->routeIs('marketing-campaigns.*') ? 'active' : '' }}">
                            <i class="fas fa-bullhorn nav-icon"></i>
                            <p>الحملات التسويقية</p>
                        </a>
                    </li>
                    
                    <!-- استبيانات العملاء -->
                    <li class="nav-item">
                        <a href="{{ route('customer-surveys.index') }}" class="nav-link {{ request()->routeIs('customer-surveys.*') ? 'active' : '' }}">
                            <i class="fas fa-poll nav-icon"></i>
                            <p>استبيانات العملاء</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- إدارة المشاريع -->
            <li class="nav-item {{ request()->routeIs('installation-projects.*') || request()->routeIs('projects.*') || request()->routeIs('elevator-stages.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('installation-projects.*') || request()->routeIs('projects.*') || request()->routeIs('elevator-stages.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-project-diagram"></i>
                    <p>
                        إدارة المشاريع
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <!-- المشاريع الرئيسية -->
                    <li class="nav-header">المشاريع الرئيسية</li>
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}" class="nav-link {{ request()->routeIs('installation-projects.index') && !request('status') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة المشاريع</p>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('installation-projects.create') }}" class="nav-link {{ request()->routeIs('installation-projects.create') ? 'active' : '' }}">
                            <i class="fas fa-plus nav-icon"></i>
                            <p>إضافة مشروع جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}?status=in_progress" class="nav-link {{ request()->routeIs('installation-projects.index') && request('status') == 'in_progress' ? 'active' : '' }}">
                            <i class="fas fa-spinner nav-icon"></i>
                            <p>المشاريع الجارية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}?status=completed" class="nav-link {{ request()->routeIs('installation-projects.index') && request('status') == 'completed' ? 'active' : '' }}">
                            <i class="fas fa-check-circle nav-icon"></i>
                            <p>المشاريع المكتملة</p>
                        </a>
                    </li>
                    
                    <!-- مكونات المشاريع -->
                    <li class="nav-header">مكونات المشاريع</li>
                    <li class="nav-item">
                        <a href="{{ route('all-project-phases.index') }}" class="nav-link {{ request()->routeIs('all-project-phases.*') || request()->routeIs('installation-projects.phases.*') ? 'active' : '' }}">
                            <i class="fas fa-tasks nav-icon"></i>
                            <p>مراحل المشاريع</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('all-project-tasks.index') }}" class="nav-link {{ request()->routeIs('all-project-tasks.*') || request()->routeIs('installation-projects.phases.tasks.*') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-list nav-icon"></i>
                            <p>مهام المشاريع</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.gantt.safe', request()->route('installationProject') ?? 1) }}" class="nav-link {{ request()->routeIs('installation-projects.gantt') || request()->routeIs('installation-projects.gantt.safe') ? 'active' : '' }}">
                            <i class="fas fa-chart-bar nav-icon"></i>
                            <p>مخطط جانت</p>
                        </a>
                    </li>
                    
                    <!-- وثائق ومالية المشاريع -->
                    <li class="nav-header">وثائق ومالية المشاريع</li>
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}#documents" class="nav-link {{ request()->routeIs('installation-projects.documents.*') ? 'active' : '' }}">
                            <i class="fas fa-file-alt nav-icon"></i>
                            <p>مستندات المشاريع</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}#expenses" class="nav-link {{ request()->routeIs('installation-projects.expenses.*') ? 'active' : '' }}">
                            <i class="fas fa-money-bill-alt nav-icon"></i>
                            <p>مصروفات المشاريع</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}#payments" class="nav-link {{ request()->routeIs('installation-projects.payments.*') ? 'active' : '' }}">
                            <i class="fas fa-hand-holding-usd nav-icon"></i>
                            <p>مدفوعات المشاريع</p>
                        </a>
                    </li>
                    
                    <!-- إدارة المخاطر والموارد -->
                    <li class="nav-header">إدارة المخاطر والموارد</li>
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}#risks" class="nav-link {{ request()->routeIs('installation-projects.risks.*') ? 'active' : '' }}">
                            <i class="fas fa-exclamation-triangle nav-icon"></i>
                            <p>مخاطر المشاريع</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}#resources" class="nav-link {{ request()->routeIs('installation-projects.resources.*') ? 'active' : '' }}">
                            <i class="fas fa-boxes nav-icon"></i>
                            <p>موارد المشاريع</p>
                        </a>
                    </li>
                    
                    <!-- تقارير المشاريع -->
                    <li class="nav-header">تقارير المشاريع</li>
                    <li class="nav-item">
                        <a href="{{ route('installation-projects.index') }}#reports" class="nav-link {{ request()->routeIs('installation-projects.reports.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-pie nav-icon"></i>
                            <p>تقارير المشاريع</p>
                        </a>
                    </li>
                    
                    <!-- مراحل المصاعد -->
                    <li class="nav-header">مراحل المصاعد</li>
                    <li class="nav-item">
                        <a href="{{ route('elevator-stages.index') }}" class="nav-link {{ request()->routeIs('elevator-stages.index') ? 'active' : '' }}">
                            <i class="fas fa-layer-group nav-icon"></i>
                            <p>قائمة مراحل المصاعد</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('elevator-stages.create') }}" class="nav-link {{ request()->routeIs('elevator-stages.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة مرحلة جديدة</p>
                        </a>
                    </li>
                </ul>
            </li>
            
            <!-- إدارة الموردين -->
            <li class="nav-item {{ request()->routeIs('inventory.suppliers.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('inventory.suppliers.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-truck"></i>
                    <p>
                        إدارة الموردين
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('inventory.suppliers.index') }}" class="nav-link {{ request()->routeIs('inventory.suppliers.index') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة الموردين</p>
                        </a>
                    </li>

                    <li class="nav-item">
                        <a href="{{ route('inventory.suppliers.create') }}" class="nav-link {{ request()->routeIs('inventory.suppliers.create') ? 'active' : '' }}">
                            <i class="fas fa-plus nav-icon"></i>
                            <p>إضافة مورد</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- إدارة المخزون -->
            <li class="nav-item {{ request()->routeIs('inventory.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('inventory.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-warehouse"></i>
                    <p>
                        إدارة المخزون
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('inventory.warehouses.index') }}" class="nav-link {{ request()->routeIs('inventory.warehouses.*') ? 'active' : '' }}">
                            <i class="fas fa-warehouse nav-icon"></i>
                            <p>المستودعات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.suppliers.index') }}" class="nav-link {{ request()->routeIs('inventory.suppliers.*') ? 'active' : '' }}">
                            <i class="fas fa-truck-loading nav-icon"></i>
                            <p>الموردين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.categories.index') }}" class="nav-link {{ request()->routeIs('inventory.categories.*') ? 'active' : '' }}">
                            <i class="fas fa-tags nav-icon"></i>
                            <p>فئات المخزون</p>
                        </a>
                    </li>
                    
                    @can('view_inventory')
                    <li class="nav-item">
                        <a href="{{ route('inventory.units.index') }}" class="nav-link {{ request()->routeIs('inventory.units.*') ? 'active' : '' }}">
                            <i class="fas fa-ruler nav-icon"></i>
                            <p>وحدات المخزون</p>
                        </a>
                    </li>
                    @endcan
                    
                    @can('view_inventory')
                    <li class="nav-item">
                        <a href="{{ route('inventory.items.units.index', ['itemId' => 0]) }}" class="nav-link {{ request()->routeIs('inventory.items.units.*') ? 'active' : '' }}">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>وحدات الأصناف</p>
                        </a>
                    </li>
                    @endcan
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.items.index') }}" class="nav-link {{ request()->routeIs('inventory.items.index') ? 'active' : '' }}">
                            <i class="fas fa-boxes nav-icon"></i>
                            <p>عناصر المخزون</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.items.low-stock') }}" class="nav-link {{ request()->routeIs('inventory.items.low-stock') ? 'active' : '' }}">
                            <i class="fas fa-exclamation-triangle nav-icon"></i>
                            <p>المخزون المنخفض</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.stock.index') }}" class="nav-link {{ request()->routeIs('inventory.stock.index') ? 'active' : '' }}">
                            <i class="fas fa-cubes nav-icon"></i>
                            <p>المخزون</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.stock.adjust-form') }}" class="nav-link {{ request()->routeIs('inventory.stock.adjust-form') ? 'active' : '' }}">
                            <i class="fas fa-balance-scale nav-icon"></i>
                            <p>تعديل المخزون</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.counts.index') }}" class="nav-link {{ request()->routeIs('inventory.counts.*') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-check nav-icon"></i>
                            <p>جرد المخزون</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.alerts.settings') }}" class="nav-link {{ request()->routeIs('inventory.alerts.settings') ? 'active' : '' }}">
                            <i class="fas fa-bell nav-icon"></i>
                            <p>إعدادات التنبيهات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.alerts.low-stock') }}" class="nav-link {{ request()->routeIs('inventory.alerts.low-stock') ? 'active' : '' }}">
                            <i class="fas fa-exclamation-triangle nav-icon"></i>
                            <p>تنبيهات المخزون المنخفض</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.alerts.expiry') }}" class="nav-link {{ request()->routeIs('inventory.alerts.expiry') ? 'active' : '' }}">
                            <i class="fas fa-calendar-times nav-icon"></i>
                            <p>تنبيهات انتهاء الصلاحية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.stock.transfer-form') }}" class="nav-link {{ request()->routeIs('inventory.stock.transfer-form') ? 'active' : '' }}">
                            <i class="fas fa-exchange-alt nav-icon"></i>
                            <p>نقل المخزون</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.purchase-orders.index') }}" class="nav-link {{ request()->routeIs('inventory.purchase-orders.index') ? 'active' : '' }}">
                            <i class="fas fa-shopping-cart nav-icon"></i>
                            <p>أوامر الشراء</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.purchase-orders.create') }}" class="nav-link {{ request()->routeIs('inventory.purchase-orders.create') ? 'active' : '' }}">
                            <i class="fas fa-cart-plus nav-icon"></i>
                            <p>إنشاء أمر شراء</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.auto-purchase.index') }}" class="nav-link {{ request()->routeIs('inventory.auto-purchase.index') || request()->routeIs('inventory.auto-purchase.create') || request()->routeIs('inventory.auto-purchase.edit') || request()->routeIs('inventory.auto-purchase.show') ? 'active' : '' }}">
                            <i class="fas fa-robot nav-icon"></i>
                            <p>الشراء التلقائي</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link {{ request()->routeIs('inventory.auto-purchase.analytics') || request()->routeIs('inventory.auto-purchase.forecast') || request()->routeIs('inventory.auto-purchase.performance') || request()->routeIs('inventory.auto-purchase.recommendations') || request()->routeIs('inventory.auto-purchase.smart-recommendations') ? 'active' : '' }}" data-toggle="collapse" data-target="#auto-purchase-analytics-submenu" aria-expanded="{{ request()->routeIs('inventory.auto-purchase.analytics') || request()->routeIs('inventory.auto-purchase.forecast') || request()->routeIs('inventory.auto-purchase.performance') || request()->routeIs('inventory.auto-purchase.recommendations') || request()->routeIs('inventory.auto-purchase.smart-recommendations') ? 'true' : 'false' }}">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>
                                تحليلات الشراء التلقائي
                                <i class="fas fa-angle-left right"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview collapse {{ request()->routeIs('inventory.auto-purchase.analytics') || request()->routeIs('inventory.auto-purchase.forecast') || request()->routeIs('inventory.auto-purchase.performance') || request()->routeIs('inventory.auto-purchase.recommendations') || request()->routeIs('inventory.auto-purchase.smart-recommendations') ? 'show' : '' }}" id="auto-purchase-analytics-submenu">
                            <li class="nav-item">
                                <a href="{{ route('inventory.auto-purchase.analytics') }}" class="nav-link {{ request()->routeIs('inventory.auto-purchase.analytics') ? 'active' : '' }}">
                                    <i class="fas fa-tachometer-alt nav-icon"></i>
                                    <p>لوحة التحكم</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('inventory.auto-purchase.forecast') }}" class="nav-link {{ request()->routeIs('inventory.auto-purchase.forecast') ? 'active' : '' }}">
                                    <i class="fas fa-chart-area nav-icon"></i>
                                    <p>التنبؤ بالطلب</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('inventory.auto-purchase.performance') }}" class="nav-link {{ request()->routeIs('inventory.auto-purchase.performance') ? 'active' : '' }}">
                                    <i class="fas fa-chart-bar nav-icon"></i>
                                    <p>أداء الشراء التلقائي</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('inventory.auto-purchase.recommendations') }}" class="nav-link {{ request()->routeIs('inventory.auto-purchase.recommendations') ? 'active' : '' }}">
                                    <i class="fas fa-lightbulb nav-icon"></i>
                                    <p>التوصيات</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('inventory.auto-purchase.smart-recommendations') }}" class="nav-link {{ request()->routeIs('inventory.auto-purchase.smart-recommendations') ? 'active' : '' }}">
                                    <i class="fas fa-brain nav-icon"></i>
                                    <p>التوصيات الذكية</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.transactions.index') }}" class="nav-link {{ request()->routeIs('inventory.transactions.index') ? 'active' : '' }}">
                            <i class="fas fa-history nav-icon"></i>
                            <p>حركات المخزون</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory-issues.index') }}" class="nav-link {{ request()->routeIs('inventory-issues.*') ? 'active' : '' }}">
                            <i class="fas fa-file-export nav-icon"></i>
                            <p>أذونات صرف المخازن</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.valuation.index') }}" class="nav-link {{ request()->routeIs('inventory.valuation.*') ? 'active' : '' }}">
                            <i class="fas fa-calculator nav-icon"></i>
                            <p>تقييم المخزون</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('inventory.barcodes.index') }}" class="nav-link {{ request()->routeIs('inventory.barcodes.*') ? 'active' : '' }}">
                            <i class="fas fa-barcode nav-icon"></i>
                            <p>إدارة الباركود</p>
                        </a>
                    </li>
                    
                    <li class="nav-item {{ request()->routeIs('inventory.reports.*') ? 'menu-open' : '' }}">
                        <a href="#" class="nav-link {{ request()->routeIs('inventory.reports.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-pie nav-icon"></i>
                            <p>
                                تقارير المخزون
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ route('inventory.reports.stock-value') }}" class="nav-link {{ request()->routeIs('inventory.reports.stock-value') ? 'active' : '' }}">
                                    <i class="fas fa-coins nav-icon"></i>
                                    <p>تقرير قيمة المخزون</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('inventory.reports.stock-movement') }}" class="nav-link {{ request()->routeIs('inventory.reports.stock-movement') ? 'active' : '' }}">
                                    <i class="fas fa-exchange-alt nav-icon"></i>
                                    <p>تقرير حركة المخزون</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('inventory.reports.item-movement') }}" class="nav-link {{ request()->routeIs('inventory.reports.item-movement') ? 'active' : '' }}">
                                    <i class="fas fa-box-open nav-icon"></i>
                                    <p>تقرير حركة صنف</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('inventory.reports.low-stock') }}" class="nav-link {{ request()->routeIs('inventory.reports.low-stock') ? 'active' : '' }}">
                                    <i class="fas fa-exclamation-triangle nav-icon"></i>
                                    <p>تقرير الأصناف منخفضة المخزون</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </li>

            <!-- إدارة الصيانة -->
            <li class="nav-item {{ request()->routeIs('maintenance-*') || request()->routeIs('elevator-maintenance.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('maintenance-*') || request()->routeIs('elevator-maintenance.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-tools"></i>
                    <p>
                        إدارة الصيانة
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('maintenance-requests.index') }}" class="nav-link {{ request()->routeIs('maintenance-requests.*') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-list nav-icon text-danger"></i>
                            <p><span class="text-danger font-weight-bold">طلبات صيانة الأعطال</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('elevator-maintenance.index') }}" class="nav-link {{ request()->routeIs('elevator-maintenance.index') ? 'active' : '' }}">
                            <i class="fas fa-tools nav-icon text-danger"></i>
                            <p><span class="text-danger font-weight-bold">عمليات صيانة الأعطال</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('elevator-maintenance.create') }}" class="nav-link {{ request()->routeIs('elevator-maintenance.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon text-danger"></i>
                            <p><span class="text-danger font-weight-bold">إضافة بلاغ عطل جديد</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('elevator-maintenance.pending') }}" class="nav-link {{ request()->routeIs('elevator-maintenance.pending') ? 'active' : '' }}">
                            <i class="fas fa-clock nav-icon text-danger"></i>
                            <p><span class="text-danger font-weight-bold">بلاغات الأعطال المعلقة</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('elevator-maintenance.completed') }}" class="nav-link {{ request()->routeIs('elevator-maintenance.completed') ? 'active' : '' }}">
                            <i class="fas fa-check-circle nav-icon text-danger"></i>
                            <p><span class="text-danger font-weight-bold">صيانات الأعطال المكتملة</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('elevator-maintenance.periodic') }}" class="nav-link {{ request()->routeIs('elevator-maintenance.periodic') ? 'active' : '' }}">
                            <i class="fas fa-sync-alt nav-icon text-success"></i>
                            <p><span class="text-success font-weight-bold">الصيانات الدورية</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('maintenance-schedules.index') }}" class="nav-link {{ request()->routeIs('maintenance-schedules.*') ? 'active' : '' }}">
                            <i class="fas fa-calendar-alt nav-icon text-success"></i>
                            <p><span class="text-success font-weight-bold">جداول الصيانة الدورية</span></p>
                        </a>
                    </li>
                    
                    <!-- Elemento de menú eliminado: جداول الصيانة الدورية (Programaciones de mantenimiento periódicas) -->
                    <li class="nav-item">
                        <a href="{{ route('maintenance-schedules.index') }}?show_generate=1" class="nav-link">
                            <i class="fas fa-calendar-plus nav-icon text-success"></i>
                            <p><span class="text-success font-weight-bold">إنشاء جداول صيانة دورية متعددة</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('maintenance-logs.index') }}" class="nav-link {{ request()->routeIs('maintenance-logs.*') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-check nav-icon text-success"></i>
                            <p><span class="text-success font-weight-bold">سجلات الصيانة الدورية</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('maintenance-contracts.index') }}" class="nav-link {{ request()->routeIs('maintenance-contracts.*') ? 'active' : '' }}">
                            <i class="fas fa-file-contract nav-icon text-success"></i>
                            <p><span class="text-success font-weight-bold">عقود الصيانة الدورية</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('maintenance-teams.index') }}" class="nav-link {{ request()->routeIs('maintenance-teams.*') ? 'active' : '' }}">
                            <i class="fas fa-users-cog nav-icon"></i>
                            <p>فرق الصيانة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('maintenance-calendar.index') }}" class="nav-link {{ request()->routeIs('maintenance-calendar.*') ? 'active' : '' }}">
                            <i class="fas fa-calendar nav-icon text-success"></i>
                            <p><span class="text-success font-weight-bold">تقويم الصيانة الدورية</span></p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('maintenance-invoices.index') }}" class="nav-link {{ request()->routeIs('maintenance-invoices.*') ? 'active' : '' }}">
                            <i class="fas fa-file-invoice-dollar nav-icon"></i>
                            <p>فواتير الصيانة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('maintenance-reports.index') }}" class="nav-link {{ request()->routeIs('maintenance-reports.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>تقارير الصيانة</p>
                        </a>
                    </li>
                </ul>
            </li>



            <!-- إدارة الفواتير -->
            <li class="nav-item {{ request()->routeIs('invoices.*') || request()->routeIs('payments.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('invoices.*') || request()->routeIs('payments.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-file-invoice-dollar"></i>
                    <p>
                        إدارة الفواتير
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('invoices.index') }}" class="nav-link {{ request()->routeIs('invoices.index') ? 'active' : '' }}">
                            <i class="fas fa-file-invoice nav-icon"></i>
                            <p>قائمة الفواتير</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('invoices.create') }}" class="nav-link {{ request()->routeIs('invoices.create') ? 'active' : '' }}">
                            <i class="fas fa-plus nav-icon"></i>
                            <p>إنشاء فاتورة</p>
                        </a>
                    </li>
                    
                    <!-- قوالب الفواتير - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-file-alt nav-icon"></i>
                            <p>قوالب الفواتير</p>
                        </a>
                    </li>
                    
                    <!-- أقساط الفواتير - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-calendar-alt nav-icon"></i>
                            <p>أقساط الفواتير</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('payments.index') }}" class="nav-link {{ request()->routeIs('payments.*') ? 'active' : '' }}">
                            <i class="fas fa-money-bill-wave nav-icon"></i>
                            <p>المدفوعات</p>
                        </a>
                    </li>
                    
                    <!-- الفواتير المتكررة - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-redo nav-icon"></i>
                            <p>الفواتير المتكررة</p>
                        </a>
                    </li>
                    
                    <!-- الفوترة الإلكترونية (الزكاة) - داخل قائمة الفواتير -->
                    @if(auth()->check() && auth()->user()->hasPermission('view_zatca_invoices'))
                    <li class="nav-item">
                        <a href="{{ route('zatca.index') }}" class="nav-link {{ request()->routeIs('zatca.*') ? 'active' : '' }}">
                            <i class="fas fa-receipt nav-icon"></i>
                            <p>الفوترة الإلكترونية (الزكاة)</p>
                        </a>
                    </li>
                    @endif
                </ul>
            </li>

            <!-- الفوترة الإلكترونية (الزكاة) - كقائمة رئيسية -->
            @if(auth()->check() && auth()->user()->hasPermission('view_zatca_invoices'))
            <li class="nav-item {{ request()->routeIs('zatca.*') ? 'menu-open' : '' }}">
                <a href="{{ route('zatca.index') }}" class="nav-link {{ request()->routeIs('zatca.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-receipt"></i>
                    <p>الفوترة الإلكترونية (الزكاة)</p>
                </a>
            </li>
            @endif

            <!-- إدارة الموارد البشرية -->
            <li class="nav-item {{ request()->routeIs('hrm.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('hrm.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-user-friends"></i>
                    <p>
                        الموارد البشرية
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('hrm.employees.index') }}" class="nav-link {{ request()->routeIs('hrm.employees.*') ? 'active' : '' }}">
                            <i class="fas fa-users nav-icon"></i>
                            <p>الموظفين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('hrm.departments.index') }}" class="nav-link {{ request()->routeIs('hrm.departments.*') ? 'active' : '' }}">
                            <i class="fas fa-building nav-icon"></i>
                            <p>الأقسام</p>
                        </a>
                    </li>
                    
                    <!-- المناصب - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-id-badge nav-icon"></i>
                            <p>المناصب</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('hrm.attendance.index') }}" class="nav-link {{ request()->routeIs('hrm.attendance.*') ? 'active' : '' }}">
                            <i class="fas fa-calendar-check nav-icon"></i>
                            <p>الحضور والانصراف</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('hrm.leaves.index') }}" class="nav-link {{ request()->routeIs('hrm.leaves.*') ? 'active' : '' }}">
                            <i class="fas fa-calendar-minus nav-icon"></i>
                            <p>الإجازات</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('hrm.payroll.index') }}" class="nav-link {{ request()->routeIs('hrm.payroll.*') ? 'active' : '' }}">
                            <i class="fas fa-money-check-alt nav-icon"></i>
                            <p>الرواتب</p>
                        </a>
                    </li>
                    
                    <!-- سياسات الرواتب - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-dollar-sign nav-icon"></i>
                            <p>سياسات الرواتب</p>
                        </a>
                    </li>
                    
                    <!-- المكافآت - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-award nav-icon"></i>
                            <p>المكافآت</p>
                        </a>
                    </li>
                    
                    <!-- القروض - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-hand-holding-usd nav-icon"></i>
                            <p>القروض</p>
                        </a>
                    </li>
                    
                    <!-- التقييمات - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-star-half-alt nav-icon"></i>
                            <p>التقييمات</p>
                        </a>
                    </li>
                    
                    <!-- التدريب - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-graduation-cap nav-icon"></i>
                            <p>التدريب</p>
                        </a>
                    </li>
                    
                    <!-- المهام - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-tasks nav-icon"></i>
                            <p>المهام</p>
                        </a>
                    </li>
                    
                    <!-- المستندات - معلق حتى يتم تنفيذه -->
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-file-alt nav-icon"></i>
                            <p>المستندات</p>
                        </a>
                    </li>
                </ul>
            </li>

            <!-- التقارير المالية -->
            <li class="nav-item {{ request()->routeIs('financial-reports.*') || request()->routeIs('tax-reports.*') || request()->routeIs('customer-statements.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('financial-reports.*') || request()->routeIs('tax-reports.*') || request()->routeIs('customer-statements.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-chart-pie"></i>
                    <p>
                        التقارير المالية
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('financial-reports.index') }}" class="nav-link {{ request()->routeIs('financial-reports.index') ? 'active' : '' }}">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>التقارير المالية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('tax-reports.index') }}" class="nav-link {{ request()->routeIs('tax-reports.*') ? 'active' : '' }}">
                            <i class="fas fa-file-invoice-dollar nav-icon"></i>
                            <p>تقارير الضرائب</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('customer-statements.index') }}" class="nav-link {{ request()->routeIs('customer-statements.*') ? 'active' : '' }}">
                            <i class="fas fa-file-alt nav-icon"></i>
                            <p>كشوف العملاء</p>
                        </a>
                    </li>
                    
                    <!-- تم إزالة التقارير الإضافية مؤقتًا حتى يتم تنفيذها -->
                    <!--
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-money-bill nav-icon"></i>
                            <p>تقارير إضافية</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-users nav-icon"></i>
                            <p>تقارير الموارد البشرية</p>
                        </a>
                    </li>
                    -->
                </ul>
            </li>

            <!-- الإعدادات -->
            <li class="nav-item {{ request()->routeIs('tax_settings.*') || request()->routeIs('settings.*') || request()->routeIs('notification-settings.*') || request()->routeIs('inventory.alerts.settings') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('tax_settings.*') || request()->routeIs('settings.*') || request()->routeIs('notification-settings.*') || request()->routeIs('inventory.alerts.settings') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-cogs"></i>
                    <p>
                        الإعدادات
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('tax_settings.index') }}" class="nav-link {{ request()->routeIs('tax_settings.index') ? 'active' : '' }}">
                            <i class="fas fa-percent nav-icon"></i>
                            <p>إعدادات الضرائب</p>
                        </a>
                    </li>
                    
                    @if(auth()->check() && auth()->user()->hasPermission('manage_notification_settings'))
                    <li class="nav-item">
                        <a href="{{ route('notification-settings.index') }}" class="nav-link {{ request()->routeIs('notification-settings.*') ? 'active' : '' }}">
                            <i class="fas fa-bell nav-icon"></i>
                            <p>إعدادات الإشعارات</p>
                        </a>
                    </li>
                    @endif
                    
                    @if(auth()->check() && auth()->user()->hasPermission('manage_inventory'))
                    <li class="nav-item">
                        <a href="{{ route('inventory.alerts.settings') }}" class="nav-link {{ request()->routeIs('inventory.alerts.settings') ? 'active' : '' }}">
                            <i class="fas fa-warehouse nav-icon"></i>
                            <p>إعدادات المخزون</p>
                        </a>
                    </li>
                    @endif
                    
                    @if(auth()->check() && auth()->user()->hasPermission('manage_settings'))
                    <li class="nav-item">
                        <a href="{{ route('company_settings.index') }}" class="nav-link {{ request()->routeIs('company_settings.*') ? 'active' : '' }}">
                            <i class="fas fa-building nav-icon"></i>
                            <p>إعدادات الشركة</p>
                        </a>
                    </li>
                    @endif
                    
                    <!-- الإعدادات العامة - معلق حتى يتم تنفيذه -->
                    <!--
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-sliders-h nav-icon"></i>
                            <p>الإعدادات العامة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-envelope nav-icon"></i>
                            <p>إعدادات البريد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-file-invoice nav-icon"></i>
                            <p>إعدادات الفواتير</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-tools nav-icon"></i>
                            <p>إعدادات الصيانة</p>
                        </a>
                    </li>
                    -->
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-database nav-icon"></i>
                            <p>النسخ الاحتياطي</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-history nav-icon"></i>
                            <p>سجلات النظام</p>
                        </a>
                    </li>
                </ul>
            </li>
            
            <!-- الأمان -->
            <li class="nav-item {{ request()->routeIs('security.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('security.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-shield-alt"></i>
                    <p>
                        الأمان
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-sign-in-alt nav-icon"></i>
                            <p>سجلات الدخول</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-user-times nav-icon"></i>
                            <p>محاولات الدخول الفاشلة</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-users-cog nav-icon"></i>
                            <p>جلسات المستخدمين</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="#" class="nav-link">
                            <i class="fas fa-lock nav-icon"></i>
                            <p>إعدادات الأمان</p>
                        </a>
                    </li>
                </ul>
            </li>

           

            <!-- إدارة المصاعد -->
            <li class="nav-item {{ request()->routeIs('elevators.*') || request()->routeIs('elevator-types.*') || request()->routeIs('elevator-models.*') || request()->routeIs('elevator-maintenance.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('elevators.*') || request()->routeIs('elevator-types.*') || request()->routeIs('elevator-models.*') || request()->routeIs('elevator-maintenance.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-elevator"></i>
                    <p>
                        إدارة المصاعد
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ url('/elevators') }}" class="nav-link {{ request()->is('elevators') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة المصاعد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ url('/elevators/create') }}" class="nav-link {{ request()->is('elevators/create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة مصعد جديد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ route('elevator-types.index') }}" class="nav-link {{ request()->routeIs('elevator-types.*') ? 'active' : '' }}">
                            <i class="fas fa-tags nav-icon"></i>
                            <p>أنواع المصاعد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ url('/elevator-models') }}" class="nav-link {{ request()->is('elevator-models*') ? 'active' : '' }}">
                            <i class="fas fa-cubes nav-icon"></i>
                            <p>موديلات المصاعد</p>
                        </a>
                    </li>
                    
                    <li class="nav-item">
                        <a href="{{ url('/elevator-parts') }}" class="nav-link {{ request()->is('elevator-parts*') ? 'active' : '' }}">
                            <i class="fas fa-cogs nav-icon"></i>
                            <p>قطع غيار المصاعد</p>
                        </a>
                    </li>
                    
                    <!-- عمليات الفحص -->
                    <li class="nav-item {{ request()->routeIs('elevator-inspections.*') ? 'menu-open' : '' }}">
                        <a href="#" class="nav-link {{ request()->routeIs('elevator-inspections.*') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-check nav-icon"></i>
                            <p>
                                عمليات الفحص
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ route('elevator-inspections.index') }}" class="nav-link {{ request()->routeIs('elevator-inspections.index') && !request()->has('status') ? 'active' : '' }}">
                                    <i class="fas fa-list nav-icon"></i>
                                    <p>كل عمليات الفحص</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-inspections.pending') }}" class="nav-link {{ request()->routeIs('elevator-inspections.pending') ? 'active' : '' }}">
                                    <i class="fas fa-clock nav-icon"></i>
                                    <p>الفحص قيد الانتظار</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-inspections.completed') }}" class="nav-link {{ request()->routeIs('elevator-inspections.completed') ? 'active' : '' }}">
                                    <i class="fas fa-check-circle nav-icon"></i>
                                    <p>الفحص المكتمل</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-inspections.create') }}" class="nav-link {{ request()->routeIs('elevator-inspections.create') ? 'active' : '' }}">
                                    <i class="fas fa-plus-circle nav-icon"></i>
                                    <p>إضافة فحص جديد</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    
                    <!-- تقارير المصاعد -->
                    <li class="nav-item {{ request()->routeIs('elevator-reports.*') ? 'menu-open' : '' }}">
                        <a href="#" class="nav-link {{ request()->routeIs('elevator-reports.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-line nav-icon"></i>
                            <p>
                                تقارير المصاعد
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.index') }}" class="nav-link {{ request()->routeIs('elevator-reports.index') ? 'active' : '' }}">
                                    <i class="fas fa-tachometer-alt nav-icon"></i>
                                    <p>لوحة التقارير</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.elevator-status') }}" class="nav-link {{ request()->routeIs('elevator-reports.elevator-status') ? 'active' : '' }}">
                                    <i class="fas fa-list nav-icon"></i>
                                    <p>حالة المصاعد</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.maintenance') }}?type=corrective" class="nav-link {{ request()->routeIs('elevator-reports.maintenance') && request()->query('type') == 'corrective' ? 'active' : '' }}">
                                    <i class="fas fa-wrench nav-icon text-danger"></i>
                                    <p><span class="text-danger font-weight-bold">تقرير صيانة الأعطال</span></p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.maintenance') }}?type=preventive" class="nav-link {{ request()->routeIs('elevator-reports.maintenance') && request()->query('type') == 'preventive' ? 'active' : '' }}">
                                    <i class="fas fa-tools nav-icon text-success"></i>
                                    <p><span class="text-success font-weight-bold">تقرير الصيانة الدورية</span></p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.inspection') }}" class="nav-link {{ request()->routeIs('elevator-reports.inspection') ? 'active' : '' }}">
                                    <i class="fas fa-clipboard-check nav-icon"></i>
                                    <p>تقرير الفحص</p>
                                </a>
                            </li>
                            
                            <li class="nav-item">
                                <a href="{{ route('reports.elevator-payments') }}" class="nav-link {{ request()->routeIs('reports.elevator-payments') ? 'active' : '' }}">
                                    <i class="fas fa-money-bill-wave nav-icon text-primary"></i>
                                    <p><span class="text-primary font-weight-bold">تقرير مدفوعات المصاعد</span></p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.by-customer') }}" class="nav-link {{ request()->routeIs('elevator-reports.by-customer') ? 'active' : '' }}">
                                    <i class="fas fa-users nav-icon"></i>
                                    <p>حسب العميل</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.by-type') }}" class="nav-link {{ request()->routeIs('elevator-reports.by-type') ? 'active' : '' }}">
                                    <i class="fas fa-tags nav-icon"></i>
                                    <p>حسب النوع</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.by-model') }}" class="nav-link {{ request()->routeIs('elevator-reports.by-model') ? 'active' : '' }}">
                                    <i class="fas fa-cubes nav-icon"></i>
                                    <p>حسب الموديل</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.maintenance-elevators') }}?type=corrective" class="nav-link {{ request()->routeIs('elevator-reports.maintenance-elevators') && request()->query('type') == 'corrective' ? 'active' : '' }}">
                                    <i class="fas fa-exclamation-triangle nav-icon text-danger"></i>
                                    <p><span class="text-danger font-weight-bold">مصاعد صيانة الأعطال</span></p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.maintenance-elevators') }}?type=preventive" class="nav-link {{ request()->routeIs('elevator-reports.maintenance-elevators') && request()->query('type') == 'preventive' ? 'active' : '' }}">
                                    <i class="fas fa-calendar-check nav-icon text-success"></i>
                                    <p><span class="text-success font-weight-bold">مصاعد الصيانة الدورية</span></p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('elevator-reports.warranty') }}" class="nav-link {{ request()->routeIs('elevator-reports.warranty') ? 'active' : '' }}">
                                    <i class="fas fa-shield-alt nav-icon text-warning"></i>
                                    <p><span class="text-warning font-weight-bold">تقرير انتهاء الضمان</span></p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="{{ route('reports.elevator-payments') }}" class="nav-link {{ request()->routeIs('reports.elevator-payments') ? 'active' : '' }}">
                                    <i class="fas fa-money-bill-wave nav-icon text-info"></i>
                                    <p><span class="text-info font-weight-bold">تقرير مدفوعات المصاعد</span></p>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </li>
            
            <!-- نظام أوامر الشغل -->
            <li class="nav-item {{ request()->routeIs('work-orders.*') ? 'menu-open' : '' }}">
                <a href="#" class="nav-link {{ request()->routeIs('work-orders.*') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-tools"></i>
                    <p>
                        أوامر الشغل
                        <i class="right fas fa-angle-left"></i>
                    </p>
                </a>
                <ul class="nav nav-treeview">
                    <li class="nav-item">
                        <a href="{{ route('work-orders.index') }}" class="nav-link {{ request()->routeIs('work-orders.index') ? 'active' : '' }}">
                            <i class="fas fa-list nav-icon"></i>
                            <p>قائمة أوامر الشغل</p>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="{{ route('work-orders.create') }}" class="nav-link {{ request()->routeIs('work-orders.create') ? 'active' : '' }}">
                            <i class="fas fa-plus-circle nav-icon"></i>
                            <p>إضافة أمر شغل جديد</p>
                        </a>
                    </li>
                </ul>
            </li>
            
            <!-- تسجيل الخروج -->
            <li class="nav-item">
                <a href="#" class="nav-link logout-sidebar-btn" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                    <i class="nav-icon fas fa-sign-out-alt text-danger"></i>
                    <p class="text-danger font-weight-bold">
                        تسجيل الخروج
                    </p>
                </a>
                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                    @csrf
                </form>
            </li>
        </ul>
    </nav>
</div>