<li class="nav-item dropdown notifications-dropdown">
    <a class="nav-link dropdown-toggle" href="#" id="notificationsDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        <i class="fas fa-bell"></i>
        <span class="badge badge-danger notification-badge" id="notification-count">0</span>
    </a>
    <div class="dropdown-menu dropdown-menu-right notifications-menu" aria-labelledby="notificationsDropdown">
        <div class="dropdown-header d-flex justify-content-between align-items-center">
            <span>الإشعارات</span>
            <a href="{{ route('notifications.mark-all-read') }}" class="text-primary mark-all-read">
                <small>تحديد الكل كمقروء</small>
            </a>
        </div>
        <div class="notifications-container" id="notifications-container">
            <div class="text-center py-3">
                <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">جاري التحميل...</span>
                </div>
            </div>
        </div>
        <div class="dropdown-divider"></div>
        <a class="dropdown-item text-center" href="{{ route('notifications.index') }}">
            عرض جميع الإشعارات
        </a>
    </div>
</li>

@section('scripts')
@parent
<script>
    $(document).ready(function() {
        // Load notifications count on page load
        loadNotificationsCount();
        
        // Refresh notifications count every 5 minutes
        setInterval(loadNotificationsCount, 300000);
        
        // Load notifications when dropdown is opened
        $('.notifications-dropdown').on('show.bs.dropdown', function () {
            loadRecentNotifications();
        });
        
        function loadNotificationsCount() {
            $.ajax({
                url: '{{ route("notifications.unread-count") }}',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    // تحديث عدد الإشعارات في القائمة المنسدلة
                    $('#notification-count').text(data.count);
                    if (data.count > 0) {
                        $('#notification-count').show();
                    } else {
                        $('#notification-count').hide();
                    }
                    
                    // تحديث عدد الإشعارات في القائمة الجانبية
                    $('#sidebar-notification-count').text(data.count);
                    if (data.count > 0) {
                        $('#sidebar-notification-count').show();
                    } else {
                        $('#sidebar-notification-count').hide();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading notifications count:', error);
                }
            });
        }
        
        function loadRecentNotifications() {
            $.ajax({
                url: '{{ route("notifications.recent-unread") }}',
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    var container = $('#notifications-container');
                    container.empty();
                    
                    if (data.notifications.length > 0) {
                        $.each(data.notifications, function(index, notification) {
                            var notificationHtml = createNotificationItem(notification);
                            container.append(notificationHtml);
                        });
                    } else {
                        container.html('<div class="text-center py-3">لا توجد إشعارات جديدة</div>');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading recent notifications:', error);
                    $('#notifications-container').html('<div class="text-center py-3">حدث خطأ أثناء تحميل الإشعارات</div>');
                }
            });
        }
        
        function createNotificationItem(notification) {
            var priorityClass = '';
            switch(notification.priority) {
                case 'low':
                    priorityClass = 'border-secondary';
                    break;
                case 'normal':
                    priorityClass = 'border-info';
                    break;
                case 'high':
                    priorityClass = 'border-warning';
                    break;
                case 'urgent':
                    priorityClass = 'border-danger';
                    break;
                default:
                    priorityClass = 'border-info';
            }
            
            var typeLabel = '';
            switch(notification.type) {
                case 'maintenance_due':
                    typeLabel = '<span class="badge badge-info">صيانة مستحقة</span>';
                    break;
                case 'maintenance_overdue':
                    typeLabel = '<span class="badge badge-danger">صيانة متأخرة</span>';
                    break;
                case 'contract_expiring':
                    typeLabel = '<span class="badge badge-warning">عقد على وشك الانتهاء</span>';
                    break;
                default:
                    typeLabel = '<span class="badge badge-secondary">' + notification.type + '</span>';
            }
            
            var timeAgo = moment(notification.created_at).fromNow();
            
            return '<a href="' + '{{ url("notifications") }}/' + notification.id + '" class="dropdown-item notification-item border-left-4 ' + priorityClass + '">' +
                '<div class="d-flex">' +
                    '<div class="mr-3">' +
                        '<i class="fas fa-bell notification-icon"></i>' +
                    '</div>' +
                    '<div class="notification-content">' +
                        '<div class="notification-title">' + notification.title + '</div>' +
                        '<div class="notification-meta">' + typeLabel + ' <small class="text-muted">' + timeAgo + '</small></div>' +
                    '</div>' +
                '</div>' +
            '</a>';
        }
    });
</script>
@endsection

@section('styles')
@parent
<style>
    .notifications-dropdown .dropdown-menu {
        width: 320px;
        max-height: 500px;
        overflow-y: auto;
    }
    
    .notification-badge {
        position: absolute;
        top: 0;
        right: 0;
        font-size: 0.7rem;
    }
    
    .notifications-container {
        max-height: 350px;
        overflow-y: auto;
    }
    
    .notification-item {
        padding: 10px 15px;
        border-bottom: 1px solid #eee;
    }
    
    .notification-item:hover {
        background-color: #f8f9fa;
    }
    
    .border-left-4 {
        border-left: 4px solid;
    }
    
    .notification-icon {
        font-size: 1.2rem;
        color: #6c757d;
    }
    
    .notification-title {
        font-weight: 600;
        margin-bottom: 3px;
    }
    
    .notification-meta {
        font-size: 0.8rem;
    }
</style>
@endsection