<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container">
        <!-- Logo -->
        <a class="navbar-brand" href="{{ route('dashboard') }}">
            {{ config('app.name', 'Elevators ERP') }}
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <!-- Left Side Of Navbar -->
            <ul class="navbar-nav me-auto">
                @auth
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}" href="{{ route('dashboard') }}">
                            <i class="bi bi-speedometer2"></i> {{ __('Dashboard') }}
                        </a>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="customersDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-people"></i> {{ __('Customers') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="customersDropdown">
                            <li><a class="dropdown-item" href="{{ route('customers.index') }}">{{ __('All Customers') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('customers.create') }}">{{ __('Add Customer') }}</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="{{ route('locations.index') }}">{{ __('Locations') }}</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="elevatorsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-building"></i> {{ __('Elevators') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="elevatorsDropdown">
                            <li><a class="dropdown-item" href="{{ route('elevators.index') }}">{{ __('All Elevators') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('elevators.create') }}">{{ __('Add Elevator') }}</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="contractsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-file-earmark-text"></i> {{ __('Contracts') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="contractsDropdown">
                            <li><a class="dropdown-item" href="{{ route('maintenance-contracts.index') }}">{{ __('All Contracts') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('maintenance-contracts.create') }}">{{ __('Add Contract') }}</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="financialDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-cash-coin"></i> {{ __('Financial') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="financialDropdown">
                            <li><a class="dropdown-item" href="{{ route('invoices.index') }}">{{ __('Invoices') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('invoices.create') }}">{{ __('Create Invoice') }}</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="{{ route('payments.index') }}">{{ __('Payments') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('payment-methods.index') }}">{{ __('Payment Methods') }}</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="branchesDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-building"></i> {{ __('الفروع') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="branchesDropdown">
                            <li><a class="dropdown-item" href="{{ route('branches.index') }}">{{ __('جميع الفروع') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('branches.create') }}">{{ __('إضافة فرع جديد') }}</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="adminDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-gear"></i> {{ __('الإدارة') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="adminDropdown">
                            <li><a class="dropdown-item" href="{{ route('company_management.index') }}">{{ __('إدارة الشركات') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('companies.index') }}">{{ __('الشركات') }}</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="usersDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-people"></i> {{ __('إدارة المستخدمين') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="usersDropdown">
                            <li><a class="dropdown-item" href="{{ route('users.index') }}">{{ __('المستخدمين') }}</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="{{ route('roles.index') }}">{{ __('الأدوار') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('roles.manage-users') }}">{{ __('إدارة أدوار المستخدمين') }}</a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="{{ route('permissions.index') }}">{{ __('الصلاحيات') }}</a></li>
                            <li><a class="dropdown-item" href="{{ route('permissions.manage-users') }}">{{ __('إدارة صلاحيات المستخدمين') }}</a></li>
                        </ul>
                    </li>
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="securityDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-shield-lock"></i> {{ __('الأمان') }}
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="securityDropdown">
                            @can('view_activity_logs')
                            <li><a class="dropdown-item" href="{{ route('activity-logs.index') }}">{{ __('سجل النشاطات') }}</a></li>
                            @endcan
                            @can('view_login_history')
                            <li><a class="dropdown-item" href="{{ route('login-history.index') }}">{{ __('سجل تسجيل الدخول') }}</a></li>
                            @endcan
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="{{ route('two-factor.index') }}">{{ __('المصادقة الثنائية') }}</a></li>
                        </ul>
                    </li>
                @endauth
            </ul>

            <!-- Right Side Of Navbar -->
            <ul class="navbar-nav ms-auto">
                <!-- Authentication Links -->
                @guest
                    @if (Route::has('login'))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">{{ __('Login') }}</a>
                        </li>
                    @endif

                    @if (Route::has('register'))
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">{{ __('Register') }}</a>
                        </li>
                    @endif
                @else
                    <li class="nav-item dropdown">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                            {{ Auth::user()->name }}
                        </a>

                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="{{ route('profile.edit') }}">
                                <i class="bi bi-person"></i> {{ __('الملف الشخصي') }}
                            </a>
                            
                            <a class="dropdown-item" href="{{ route('two-factor.index') }}">
                                <i class="bi bi-shield-lock"></i> {{ __('المصادقة الثنائية') }}
                            </a>
                            
                            <div class="dropdown-divider"></div>
                            
                            <a class="dropdown-item" href="{{ route('logout') }}"
                               onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                                <i class="bi bi-box-arrow-right"></i> {{ __('تسجيل الخروج') }}
                            </a>

                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </div>
                    </li>
                @endguest
            </ul>
        </div>
    </div>
</nav>