<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="نظام إدارة المصاعد - حل متكامل لإدارة شركات المصاعد">
    <meta name="author" content="Elevators ERP">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', config('app.name', 'نظام إدارة المصاعد'))</title>

    <!-- Favicon -->
    <link rel="icon" href="{{ asset('favicon.ico') }}" type="image/x-icon">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="{{ asset('css/modern-dashboard.css') }}">
    <link rel="stylesheet" href="{{ asset('css/notifications.css') }}">
    <link rel="stylesheet" href="{{ asset('css/rtl-fixes.css') }}">
    <link rel="stylesheet" href="{{ asset('css/header-fix.css') }}">
    <link rel="stylesheet" href="{{ asset('css/sidebar-compact.css') }}">
    
    <!-- صفحات التنسيق المخصصة -->
    @stack('styles')
</head>
<body class="hold-transition">
    <div class="wrapper">
        <!-- Main Sidebar Container -->
        <aside class="main-sidebar">
            <!-- Brand Logo -->
            <a href="{{ url('/') }}" class="brand-link">
                @if(file_exists(public_path('images/logo.png')))
                    <img src="{{ asset('images/logo.png') }}" alt="{{ config('app.name', 'نظام إدارة المصاعد') }}" class="brand-image">
                @endif
                <span class="brand-text">{{ config('app.name', 'نظام إدارة المصاعد') }}</span>
            </a>

            <!-- Sidebar -->
            @auth
                @include('layouts.partials.sidebar')
            @endauth
            <!-- /.sidebar -->
        </aside>

        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-light">
            <div class="container-fluid">
                <!-- Left navbar links -->
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-widget="pushmenu" href="#" role="button">
                            <i class="fas fa-bars"></i>
                        </a>
                    </li>
                    <li class="nav-item d-none d-sm-inline-block">
                        <a href="{{ route('dashboard') }}" class="nav-link">
                            <i class="fas fa-tachometer-alt"></i>
                            <span class="d-none d-lg-inline-block ms-1">لوحة التحكم</span>
                        </a>
                    </li>
                </ul>

                <!-- Right navbar links -->
                <ul class="navbar-nav ms-auto">
                    <!-- Notifications Dropdown Menu -->
                    <li class="nav-item dropdown">
                        <a class="nav-link" data-bs-toggle="dropdown" href="#">
                            <i class="far fa-bell"></i>
                            <span class="badge bg-danger rounded-pill" id="notification-count">0</span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <span class="dropdown-header">الإشعارات</span>
                            <div class="dropdown-divider"></div>
                            <div id="notifications-container">
                                <a href="{{ route('notifications.index') }}" class="dropdown-item text-center">
                                    <i class="fas fa-bell me-2"></i> عرض جميع الإشعارات
                                </a>
                            </div>
                        </div>
                    </li>
                    
                    <!-- Dark Mode Toggle -->
                    <li class="nav-item">
                        <a class="nav-link" href="#" id="dark-mode-toggle">
                            <i class="fas fa-moon"></i>
                        </a>
                    </li>
                    
                    <!-- Language Toggle -->
                    <li class="nav-item dropdown">
                        <a class="nav-link" data-bs-toggle="dropdown" href="#">
                            <i class="fas fa-language"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end">
                            <span class="dropdown-header">اختر اللغة</span>
                            <div class="dropdown-divider"></div>
                            <a href="{{ route('users.index') }}" class="dropdown-item">
                                <i class="fas fa-globe me-2"></i> English
                            </a>
                            <a href="{{ route('users.arabic.index') }}" class="dropdown-item">
                                <i class="fas fa-globe me-2"></i> العربية
                            </a>
                        </div>
                    </li>
                    
                    <!-- User Dropdown Menu -->
                    @auth
                    <li class="nav-item dropdown">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-user-circle me-1"></i>
                            <span>{{ Auth::user()->name }}</span>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                            <div class="dropdown-header">
                                <h6 class="mb-0">{{ Auth::user()->name }}</h6>
                                <small>{{ Auth::user()->email }}</small>
                            </div>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="{{ route('profile.edit') }}">
                                <i class="fas fa-user-cog"></i> الملف الشخصي
                            </a>
                            <a class="dropdown-item" href="{{ route('notifications.index') }}">
                                <i class="fas fa-bell"></i> الإشعارات
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item logout-btn" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                <i class="fas fa-sign-out-alt"></i> تسجيل الخروج
                            </a>
                            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                @csrf
                            </form>
                        </div>
                    </li>
                    @endauth
                </ul>
            </div>
        </nav>
        <!-- /.navbar -->

        <!-- Content Wrapper -->
        <div class="content-wrapper">
            <!-- رسائل النجاح والخطأ -->
            <div class="container-fluid pt-3">
                @include('layouts.alerts')
            </div>
            
            @yield('content')
        </div>
        <!-- /.content-wrapper -->

        <!-- Footer -->
        <footer class="main-footer">
            <div class="float-left d-none d-sm-inline">
                <strong>{{ config('app.name', 'نظام إدارة المصاعد') }}</strong>
            </div>
            <strong>حقوق النشر &copy; {{ date('Y') }} <a href="{{ url('/') }}">{{ config('app.name', 'نظام إدارة المصاعد') }}</a>.</strong> جميع الحقوق محفوظة.
        </footer>

        <!-- Back to top button -->
        <a href="#" id="back-to-top" class="btn btn-primary back-to-top" role="button" aria-label="العودة إلى الأعلى">
            <i class="fas fa-chevron-up"></i>
        </a>
    </div>
    <!-- ./wrapper -->

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('js/modern-dashboard.js') }}"></script>
    <script src="{{ asset('js/rtl-fixes.js') }}"></script>
    
    <!-- CSRF Token for AJAX -->
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    </script>
    
    <!-- صفحات الجافا سكريبت المخصصة -->
    @stack('scripts')
</body>
</html>