@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>
                        @if($invoice->customer->tax_number)
                            فاتورة ضريبية #{{ $invoice->invoice_number }}
                        @else
                            فاتورة ضريبية مبسطة #{{ $invoice->invoice_number }}
                        @endif
                    </h4>
                    <div>
                        <a href="{{ route('invoices.print', $invoice->id) }}" class="btn btn-info" target="_blank">
                            <i class="fas fa-print"></i> طباعة
                        </a>
                        <a href="{{ route('invoices.export-pdf', $invoice->id) }}" class="btn btn-secondary" target="_blank">
                            <i class="fas fa-file-pdf"></i> تصدير PDF
                        </a>
                        @if($invoice->status == 'draft')
                            <a href="{{ route('invoices.edit', $invoice->id) }}" class="btn btn-primary">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                        @endif
                        <a href="{{ route('invoices.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>معلومات العميل</h5>
                            <p><strong>الاسم:</strong> {{ $invoice->customer->name }}</p>
                            <p><strong>العنوان:</strong> {{ $invoice->customer->address }}</p>
                            <p><strong>الهاتف:</strong> {{ $invoice->customer->phone }}</p>
                            <p><strong>البريد الإلكتروني:</strong> {{ $invoice->customer->email }}</p>
                            @if($invoice->customer->tax_number)
                                <p><strong>الرقم الضريبي:</strong> {{ $invoice->customer->tax_number }}</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <h5>معلومات الفاتورة</h5>
                            <p><strong>رقم الفاتورة:</strong> {{ $invoice->invoice_number }}</p>
                            <p><strong>تاريخ الفاتورة:</strong> {{ $invoice->invoice_date }}</p>
                            <p><strong>تاريخ الاستحقاق:</strong> {{ $invoice->due_date }}</p>
                            <p><strong>الحالة:</strong> 
                                @if($invoice->status == 'draft')
                                    <span class="badge bg-secondary">مسودة</span>
                                @elseif($invoice->status == 'sent')
                                    <span class="badge bg-info">مرسلة</span>
                                @elseif($invoice->status == 'paid')
                                    <span class="badge bg-success">مدفوعة</span>
                                @elseif($invoice->status == 'partially_paid')
                                    <span class="badge bg-warning">مدفوعة جزئيًا</span>
                                @elseif($invoice->status == 'overdue')
                                    <span class="badge bg-danger">متأخرة</span>
                                @elseif($invoice->status == 'cancelled')
                                    <span class="badge bg-dark">ملغاة</span>
                                @endif
                            </p>
                            @if($invoice->maintenance_contract)
                                <p><strong>عقد الصيانة:</strong> {{ $invoice->maintenance_contract->contract_number }}</p>
                            @endif
                            
                            <div class="mt-3">
                                <h5>رمز الاستجابة السريعة (QR) للزكاة والدخل</h5>
                                @if($invoice->zatca_qr_code)
                                    <div class="qr-code-container">
                                        <!-- استخدام تنسيق SVG مباشرة لأن الكود يقوم بإنشاء SVG دائمًا -->
                                        <img src="data:image/svg+xml;base64,{{ $invoice->zatca_qr_code }}" alt="رمز QR للزكاة والدخل" style="max-width: 150px; max-height: 150px;">
                                    </div>
                                @else
                                    <div class="alert alert-warning">
                                        رمز QR غير متوفر. 
                                        <a href="{{ route('invoices.regenerate-qr', $invoice->id) }}" class="btn btn-sm btn-primary">
                                            إعادة إنشاء رمز QR
                                        </a>
                                    </div>
                                @endif
                                @if($invoice->zatca_qr_code)
                                    <div class="mt-2">
                                        <a href="{{ route('invoices.regenerate-qr', $invoice->id) }}" class="btn btn-sm btn-outline-secondary">
                                            تحديث رمز QR
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>

                    <h5 class="mt-4 mb-3">بنود الفاتورة</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الوصف</th>
                                    <th>الكمية</th>
                                    <th>سعر الوحدة</th>
                                    <th>الخصم</th>
                                    <th>المجموع</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($invoice->items as $index => $item)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $item->description }}</td>
                                        <td>{{ $item->quantity }}</td>
                                        <td>{{ number_format($item->unit_price, 2) }}</td>
                                        <td>{{ $item->discount_percentage }}% ({{ number_format($item->discount_amount, 2) }})</td>
                                        <td>{{ number_format($item->total, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="5" class="text-left"><strong>المجموع الفرعي:</strong></td>
                                    <td>{{ number_format($invoice->subtotal, 2) }}</td>
                                </tr>
                                @if($invoice->discount_amount > 0)
                                <tr>
                                    <td colspan="5" class="text-left"><strong>الخصم ({{ $invoice->discount_percentage }}%):</strong></td>
                                    <td>{{ number_format($invoice->discount_amount, 2) }}</td>
                                </tr>
                                @endif
                                <tr>
                                    <td colspan="5" class="text-left"><strong>ضريبة القيمة المضافة ({{ $invoice->tax_rate }}%):</strong></td>
                                    <td>{{ number_format($invoice->tax_amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-left"><strong>الإجمالي:</strong></td>
                                    <td><strong>{{ number_format($invoice->total_amount, 2) }}</strong></td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-left"><strong>المبلغ المدفوع:</strong></td>
                                    <td>{{ number_format($invoice->paid_amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="5" class="text-left"><strong>المبلغ المستحق:</strong></td>
                                    <td><strong>{{ number_format($invoice->due_amount, 2) }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    @if($invoice->notes)
                        <div class="mt-4">
                            <h5>ملاحظات</h5>
                            <p>{{ $invoice->notes }}</p>
                        </div>
                    @endif

                    @if($invoice->terms_conditions)
                        <div class="mt-4">
                            <h5>الشروط والأحكام</h5>
                            <p>{{ $invoice->terms_conditions }}</p>
                        </div>
                    @endif

                    @if(count($invoice->payments) > 0)
                        <h5 class="mt-4 mb-3">المدفوعات</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>رقم المرجع</th>
                                        <th>تاريخ الدفع</th>
                                        <th>طريقة الدفع</th>
                                        <th>المبلغ</th>
                                        <th>ملاحظات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($invoice->payments as $index => $payment)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>{{ $payment->reference }}</td>
                                            <td>{{ $payment->date }}</td>
                                            <td>{{ $payment->paymentMethod->name }}</td>
                                            <td>{{ number_format($payment->amount, 2) }}</td>
                                            <td>{{ $payment->notes }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif

                    @if($invoice->status != 'paid' && $invoice->status != 'cancelled')
                        <div class="mt-4">
                            <a href="{{ route('payments.create', ['invoice_id' => $invoice->id]) }}" class="btn btn-success">
                                <i class="fas fa-money-bill"></i> تسجيل دفعة
                            </a>
                            
                            @if($invoice->status == 'draft')
                                <form action="{{ route('invoices.update', $invoice->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('PUT')
                                    <input type="hidden" name="status" value="sent">
                                    <button type="submit" class="btn btn-info">
                                        <i class="fas fa-paper-plane"></i> تغيير الحالة إلى "مرسلة"
                                    </button>
                                </form>
                            @endif
                            
                            @if($invoice->is_recurring == false)
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#recurringModal">
                                    <i class="fas fa-sync"></i> جعلها فاتورة متكررة
                                </button>
                            @endif
                            
                            <button type="button" class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#installmentsModal">
                                <i class="fas fa-money-check"></i> إنشاء أقساط
                            </button>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Recurring Invoice -->
<div class="modal fade" id="recurringModal" tabindex="-1" aria-labelledby="recurringModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('invoices.make-recurring', $invoice->id) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="recurringModalLabel">إنشاء فاتورة متكررة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="recurring_frequency">تكرار الفاتورة</label>
                        <select name="recurring_frequency" id="recurring_frequency" class="form-control" required>
                            <option value="monthly">شهريًا</option>
                            <option value="quarterly">ربع سنوي</option>
                            <option value="semi_annually">نصف سنوي</option>
                            <option value="annually">سنويًا</option>
                        </select>
                    </div>
                    <div class="form-group mb-3">
                        <label for="next_recurring_date">تاريخ الفاتورة التالية</label>
                        <input type="date" name="next_recurring_date" id="next_recurring_date" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">حفظ</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal for Installments -->
<div class="modal fade" id="installmentsModal" tabindex="-1" aria-labelledby="installmentsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('invoices.create-installments', $invoice->id) }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="installmentsModalLabel">إنشاء أقساط للفاتورة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group mb-3">
                        <label for="number_of_installments">عدد الأقساط</label>
                        <input type="number" name="number_of_installments" id="number_of_installments" class="form-control" min="2" max="12" value="3" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="first_installment_date">تاريخ القسط الأول</label>
                        <input type="date" name="first_installment_date" id="first_installment_date" class="form-control" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="installment_interval">الفترة بين الأقساط (بالأيام)</label>
                        <input type="number" name="installment_interval" id="installment_interval" class="form-control" min="1" value="30" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">إنشاء الأقساط</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // تعيين تاريخ الفاتورة التالية بشكل افتراضي بعد شهر من تاريخ اليوم
        var today = new Date();
        var nextMonth = new Date(today.setMonth(today.getMonth() + 1));
        var formattedDate = nextMonth.toISOString().split('T')[0];
        $('#next_recurring_date').val(formattedDate);
        
        // تعيين تاريخ القسط الأول بشكل افتراضي لتاريخ اليوم
        var today = new Date();
        var formattedToday = today.toISOString().split('T')[0];
        $('#first_installment_date').val(formattedToday);
    });
</script>
@endpush
@endsection