@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>الفواتير المتكررة</h4>
                    <div>
                        <button type="button" class="btn btn-success" data-toggle="modal" data-target="#generateRecurringModal">
                            <i class="fas fa-sync"></i> توليد الفواتير المتكررة
                        </button>
                        <a href="{{ route('invoices.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للفواتير
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم الفاتورة</th>
                                    <th>العميل</th>
                                    <th>تكرار الفاتورة</th>
                                    <th>تاريخ الفاتورة التالية</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoices as $invoice)
                                    <tr>
                                        <td>{{ $invoice->invoice_number }}</td>
                                        <td>{{ $invoice->customer->name }}</td>
                                        <td>
                                            @if($invoice->recurring_frequency == 'monthly')
                                                شهريًا
                                            @elseif($invoice->recurring_frequency == 'quarterly')
                                                ربع سنوي
                                            @elseif($invoice->recurring_frequency == 'semi_annually')
                                                نصف سنوي
                                            @elseif($invoice->recurring_frequency == 'annually')
                                                سنويًا
                                            @endif
                                        </td>
                                        <td>{{ $invoice->next_recurring_date }}</td>
                                        <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                        <td>
                                            @if($invoice->status == 'draft')
                                                <span class="badge bg-secondary">مسودة</span>
                                            @elseif($invoice->status == 'sent')
                                                <span class="badge bg-info">مرسلة</span>
                                            @elseif($invoice->status == 'paid')
                                                <span class="badge bg-success">مدفوعة</span>
                                            @elseif($invoice->status == 'partially_paid')
                                                <span class="badge bg-warning">مدفوعة جزئيًا</span>
                                            @elseif($invoice->status == 'overdue')
                                                <span class="badge bg-danger">متأخرة</span>
                                            @elseif($invoice->status == 'cancelled')
                                                <span class="badge bg-dark">ملغاة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <button type="button" class="btn btn-primary btn-sm" title="تعديل التكرار" 
                                                    data-toggle="modal" data-target="#editRecurringModal{{ $invoice->id }}">
                                                    <i class="fas fa-edit"></i>
                                                </button>
                                                <button type="button" class="btn btn-danger btn-sm" title="إلغاء التكرار" 
                                                    onclick="if(confirm('هل أنت متأكد من إلغاء تكرار هذه الفاتورة؟')) { document.getElementById('cancel-recurring-form-{{ $invoice->id }}').submit(); }">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                                <form id="cancel-recurring-form-{{ $invoice->id }}" action="{{ route('invoices.update', $invoice->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                    @method('PUT')
                                                    <input type="hidden" name="is_recurring" value="0">
                                                </form>
                                            </div>
                                            
                                            <!-- Modal for Editing Recurring -->
                                            <div class="modal fade" id="editRecurringModal{{ $invoice->id }}" tabindex="-1" aria-labelledby="editRecurringModalLabel{{ $invoice->id }}" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <form action="{{ route('invoices.update', $invoice->id) }}" method="POST">
                                                            @csrf
                                                            @method('PUT')
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="editRecurringModalLabel{{ $invoice->id }}">تعديل تكرار الفاتورة #{{ $invoice->invoice_number }}</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="form-group mb-3">
                                                                    <label for="recurring_frequency{{ $invoice->id }}">تكرار الفاتورة</label>
                                                                    <select name="recurring_frequency" id="recurring_frequency{{ $invoice->id }}" class="form-control" required>
                                                                        <option value="monthly" {{ $invoice->recurring_frequency == 'monthly' ? 'selected' : '' }}>شهريًا</option>
                                                                        <option value="quarterly" {{ $invoice->recurring_frequency == 'quarterly' ? 'selected' : '' }}>ربع سنوي</option>
                                                                        <option value="semi_annually" {{ $invoice->recurring_frequency == 'semi_annually' ? 'selected' : '' }}>نصف سنوي</option>
                                                                        <option value="annually" {{ $invoice->recurring_frequency == 'annually' ? 'selected' : '' }}>سنويًا</option>
                                                                    </select>
                                                                </div>
                                                                <div class="form-group mb-3">
                                                                    <label for="next_recurring_date{{ $invoice->id }}">تاريخ الفاتورة التالية</label>
                                                                    <input type="date" name="next_recurring_date" id="next_recurring_date{{ $invoice->id }}" class="form-control" value="{{ $invoice->next_recurring_date }}" required>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center">لا توجد فواتير متكررة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $invoices->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Generating Recurring Invoices -->
<div class="modal fade" id="generateRecurringModal" tabindex="-1" aria-labelledby="generateRecurringModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('invoices.generate-recurring') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="generateRecurringModalLabel">توليد الفواتير المتكررة</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info">
                        سيتم توليد الفواتير المتكررة التي حان موعدها حتى تاريخ اليوم.
                    </div>
                    <div class="form-group mb-3">
                        <label for="status">حالة الفواتير الجديدة</label>
                        <select name="status" id="status" class="form-control" required>
                            <option value="draft">مسودة</option>
                            <option value="sent">مرسلة</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">توليد الفواتير</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection