<!DOCTYPE html>
<html lang="{{ $invoice->language }}" dir="{{ $invoice->language === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $invoice->language === 'ar' ? 'فاتورة رقم' : 'Invoice #' }} {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: {{ $invoice->language === 'ar' ? "'XB Riyaz', 'Arial'" : "'DejaVu Sans', 'Arial'" }};
            margin: 0;
            padding: 20px;
            color: #333;
            direction: {{ $invoice->language === 'ar' ? 'rtl' : 'ltr' }};
        }
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .invoice-header {
            border-bottom: 2px solid #ddd;
            padding-bottom: 20px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
        }
        .company-info {
            text-align: {{ $invoice->language === 'ar' ? 'right' : 'left' }};
        }
        .invoice-info {
            text-align: {{ $invoice->language === 'ar' ? 'left' : 'right' }};
        }
        .invoice-title {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
            color: #2c3e50;
            text-align: center;
        }
        .customer-info {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: {{ $invoice->language === 'ar' ? 'right' : 'left' }};
        }
        th {
            background-color: #f2f2f2;
        }
        .amount-table th {
            width: 70%;
        }
        .amount-table td {
            text-align: {{ $invoice->language === 'ar' ? 'left' : 'right' }};
        }
        .total-row {
            font-weight: bold;
            background-color: #f9f9f9;
        }
        .notes {
            margin-top: 30px;
            padding: 15px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 12px;
            color: #777;
            border-top: 1px solid #ddd;
            padding-top: 20px;
        }
        .qr-code {
            text-align: center;
            margin-top: 20px;
        }
        .qr-code img {
            max-width: 150px;
            height: auto;
        }
        @media print {
            body {
                padding: 0;
            }
            .invoice-container {
                box-shadow: none;
                border: none;
                padding: 0;
            }
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <div class="invoice-header">
            <div class="company-info">
                <h2>{{ $invoice->company->name }}</h2>
                <p>{{ $invoice->language === 'ar' ? 'العنوان:' : 'Address:' }} {{ $invoice->company->address }}</p>
                <p>{{ $invoice->language === 'ar' ? 'الهاتف:' : 'Phone:' }} {{ $invoice->company->phone }}</p>
                <p>{{ $invoice->language === 'ar' ? 'البريد الإلكتروني:' : 'Email:' }} {{ $invoice->company->email }}</p>
                @if($invoice->company->vat_number)
                <p>{{ $invoice->language === 'ar' ? 'الرقم الضريبي:' : 'VAT Number:' }} {{ $invoice->company->vat_number }}</p>
                @endif
            </div>
            <div class="invoice-info">
                <h3>{{ $invoice->language === 'ar' ? 'فاتورة' : 'Invoice' }}</h3>
                <p>{{ $invoice->language === 'ar' ? 'رقم الفاتورة:' : 'Invoice Number:' }} {{ $invoice->invoice_number }}</p>
                <p>{{ $invoice->language === 'ar' ? 'تاريخ الفاتورة:' : 'Invoice Date:' }} {{ $invoice->invoice_date }}</p>
                <p>{{ $invoice->language === 'ar' ? 'تاريخ الاستحقاق:' : 'Due Date:' }} {{ $invoice->due_date }}</p>
                <p>{{ $invoice->language === 'ar' ? 'الحالة:' : 'Status:' }} 
                    @php
                        $statusText = [
                            'ar' => [
                                'draft' => 'مسودة',
                                'sent' => 'مرسلة',
                                'paid' => 'مدفوعة',
                                'partially_paid' => 'مدفوعة جزئياً',
                                'overdue' => 'متأخرة',
                                'cancelled' => 'ملغاة',
                            ],
                            'en' => [
                                'draft' => 'Draft',
                                'sent' => 'Sent',
                                'paid' => 'Paid',
                                'partially_paid' => 'Partially Paid',
                                'overdue' => 'Overdue',
                                'cancelled' => 'Cancelled',
                            ],
                        ];
                        $status = $statusText[$invoice->language][$invoice->status] ?? $invoice->status;
                    @endphp
                    {{ $status }}
                </p>
            </div>
        </div>
        
        <div class="invoice-title">
            @if($invoice->language === 'ar')
                @if($invoice->customer->tax_number)
                    فاتورة ضريبية رقم {{ $invoice->invoice_number }}
                @else
                    فاتورة ضريبية مبسطة رقم {{ $invoice->invoice_number }}
                @endif
            @else
                @if($invoice->customer->tax_number)
                    Tax Invoice # {{ $invoice->invoice_number }}
                @else
                    Simplified Tax Invoice # {{ $invoice->invoice_number }}
                @endif
            @endif
        </div>
        
        <div class="customer-info">
            <h3>{{ $invoice->language === 'ar' ? 'معلومات العميل' : 'Customer Information' }}</h3>
            <p><strong>{{ $invoice->language === 'ar' ? 'الاسم:' : 'Name:' }}</strong> {{ $invoice->customer->name }}</p>
            <p><strong>{{ $invoice->language === 'ar' ? 'الهاتف:' : 'Phone:' }}</strong> {{ $invoice->customer->phone }}</p>
            <p><strong>{{ $invoice->language === 'ar' ? 'البريد الإلكتروني:' : 'Email:' }}</strong> {{ $invoice->customer->email }}</p>
            <p><strong>{{ $invoice->language === 'ar' ? 'العنوان:' : 'Address:' }}</strong> {{ $invoice->customer->address }}</p>
            @if($invoice->customer->vat_number)
            <p><strong>{{ $invoice->language === 'ar' ? 'الرقم الضريبي:' : 'VAT Number:' }}</strong> {{ $invoice->customer->vat_number }}</p>
            @endif
        </div>
        
        @if($invoice->maintenance_contract)
        <div class="contract-info">
            <h3>{{ $invoice->language === 'ar' ? 'معلومات العقد' : 'Contract Information' }}</h3>
            <p><strong>{{ $invoice->language === 'ar' ? 'رقم العقد:' : 'Contract Number:' }}</strong> {{ $invoice->maintenance_contract->contract_number }}</p>
            <p><strong>{{ $invoice->language === 'ar' ? 'تاريخ البدء:' : 'Start Date:' }}</strong> {{ $invoice->maintenance_contract->start_date }}</p>
            <p><strong>{{ $invoice->language === 'ar' ? 'تاريخ الانتهاء:' : 'End Date:' }}</strong> {{ $invoice->maintenance_contract->end_date }}</p>
        </div>
        @endif
        
        <h3>{{ $invoice->language === 'ar' ? 'تفاصيل الفاتورة' : 'Invoice Details' }}</h3>
        <table>
            <thead>
                <tr>
                    <th>{{ $invoice->language === 'ar' ? 'الوصف' : 'Description' }}</th>
                    <th>{{ $invoice->language === 'ar' ? 'الكمية' : 'Quantity' }}</th>
                    <th>{{ $invoice->language === 'ar' ? 'سعر الوحدة' : 'Unit Price' }}</th>
                    <th>{{ $invoice->language === 'ar' ? 'الخصم' : 'Discount' }}</th>
                    <th>{{ $invoice->language === 'ar' ? 'الإجمالي' : 'Total' }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $item)
                <tr>
                    <td>{{ $item->description }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ number_format($item->unit_price, 2) }}</td>
                    <td>{{ $item->discount_percentage > 0 ? number_format($item->discount_percentage, 2) . '%' : '-' }}</td>
                    <td>{{ number_format($item->total, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
        
        <h3>{{ $invoice->language === 'ar' ? 'ملخص الفاتورة' : 'Invoice Summary' }}</h3>
        <table class="amount-table">
            <tr>
                <th>{{ $invoice->language === 'ar' ? 'المجموع الفرعي' : 'Subtotal' }}</th>
                <td>{{ number_format($invoice->subtotal, 2) }}</td>
            </tr>
            @if($invoice->discount_amount > 0)
            <tr>
                <th>{{ $invoice->language === 'ar' ? 'الخصم' : 'Discount' }} ({{ number_format($invoice->discount_percentage, 2) }}%)</th>
                <td>{{ number_format($invoice->discount_amount, 2) }}</td>
            </tr>
            @endif
            <tr>
                <th>{{ $invoice->language === 'ar' ? 'ضريبة القيمة المضافة' : 'VAT' }} ({{ $invoice->tax_rate }}%)</th>
                <td>{{ number_format($invoice->tax_amount, 2) }}</td>
            </tr>
            <tr class="total-row">
                <th>{{ $invoice->language === 'ar' ? 'المبلغ الإجمالي' : 'Total Amount' }}</th>
                <td>{{ number_format($invoice->total_amount, 2) }}</td>
            </tr>
            @if($invoice->paid_amount > 0)
            <tr>
                <th>{{ $invoice->language === 'ar' ? 'المبلغ المدفوع' : 'Paid Amount' }}</th>
                <td>{{ number_format($invoice->paid_amount, 2) }}</td>
            </tr>
            <tr class="total-row">
                <th>{{ $invoice->language === 'ar' ? 'المبلغ المتبقي' : 'Remaining Amount' }}</th>
                <td>{{ number_format($invoice->due_amount, 2) }}</td>
            </tr>
            @endif
        </table>
        
        @if($invoice->notes)
        <div class="notes">
            <h3>{{ $invoice->language === 'ar' ? 'ملاحظات' : 'Notes' }}</h3>
            <p>{{ $invoice->notes }}</p>
        </div>
        @endif
        
        @if($invoice->terms_conditions)
        <div class="notes">
            <h3>{{ $invoice->language === 'ar' ? 'الشروط والأحكام' : 'Terms and Conditions' }}</h3>
            <p>{{ $invoice->terms_conditions }}</p>
        </div>
        @endif
        
        @if($invoice->zatca_qr_code)
        <div class="qr-code">
            <h3>{{ $invoice->language === 'ar' ? 'رمز الاستجابة السريعة للفاتورة الإلكترونية' : 'E-Invoice QR Code' }}</h3>
            <img src="data:image/svg+xml;base64,{{ $invoice->zatca_qr_code }}" alt="QR Code">
        </div>
        @endif
        
        <div class="footer">
            <p>{{ $invoice->language === 'ar' ? 'شكراً لتعاملكم معنا' : 'Thank you for your business' }}</p>
            <p>{{ $invoice->language === 'ar' ? 'تم إنشاء هذه الفاتورة بواسطة' : 'This invoice was created by' }}: {{ auth()->user()->name }} {{ $invoice->language === 'ar' ? 'في' : 'on' }} {{ now()->format('Y-m-d H:i') }}</p>
        </div>
        
        <div class="no-print" style="margin-top: 30px; text-align: center;">
            <button onclick="window.print()" style="padding: 10px 20px; background-color: #3498db; color: white; border: none; border-radius: 5px; cursor: pointer;">
                {{ $invoice->language === 'ar' ? 'طباعة الفاتورة' : 'Print Invoice' }}
            </button>
            <button onclick="window.close()" style="padding: 10px 20px; background-color: #7f8c8d; color: white; border: none; border-radius: 5px; cursor: pointer; margin-right: 10px;">
                {{ $invoice->language === 'ar' ? 'إغلاق' : 'Close' }}
            </button>
        </div>
    </div>
</body>
</html>