@extends('layouts.modern')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4>قائمة الفواتير</h4>
                    <div>
                        <a href="{{ route('invoices.create') }}" class="btn btn-primary">إنشاء فاتورة جديدة</a>
                    </div>
                </div>
                <div class="card-body">
                    @include('layouts.alerts')

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم الفاتورة</th>
                                    <th>العميل</th>
                                    <th>تاريخ الفاتورة</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>المبلغ الإجمالي</th>
                                    <th>المبلغ المدفوع</th>
                                    <th>المبلغ المستحق</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invoices as $invoice)
                                    <tr>
                                        <td>{{ $invoice->invoice_number }}</td>
                                        <td>{{ $invoice->customer->name }}</td>
                                        <td>{{ $invoice->invoice_date }}</td>
                                        <td>{{ $invoice->due_date }}</td>
                                        <td>{{ number_format($invoice->total_amount, 2) }}</td>
                                        <td>{{ number_format($invoice->paid_amount, 2) }}</td>
                                        <td>{{ number_format($invoice->due_amount, 2) }}</td>
                                        <td>
                                            @if($invoice->status == 'draft')
                                                <span class="badge bg-secondary">مسودة</span>
                                            @elseif($invoice->status == 'sent')
                                                <span class="badge bg-info">مرسلة</span>
                                            @elseif($invoice->status == 'paid')
                                                <span class="badge bg-success">مدفوعة</span>
                                            @elseif($invoice->status == 'partially_paid')
                                                <span class="badge bg-warning">مدفوعة جزئيًا</span>
                                            @elseif($invoice->status == 'overdue')
                                                <span class="badge bg-danger">متأخرة</span>
                                            @elseif($invoice->status == 'cancelled')
                                                <span class="badge bg-dark">ملغاة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if($invoice->status == 'draft')
                                                    <a href="{{ route('invoices.edit', $invoice->id) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                @endif
                                                <a href="{{ route('invoices.export-pdf', $invoice->id) }}" class="btn btn-secondary btn-sm" title="تصدير PDF" target="_blank">
                                                    <i class="fas fa-file-pdf"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger btn-sm" title="حذف" 
                                                    onclick="if(confirm('هل أنت متأكد من حذف هذه الفاتورة؟')) { document.getElementById('delete-form-{{ $invoice->id }}').submit(); }">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                <form id="delete-form-{{ $invoice->id }}" action="{{ route('invoices.destroy', $invoice->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد فواتير</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-center mt-4">
                        {{ $invoices->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection