@extends('layouts.modern')

@section('title', 'تفاصيل قالب الفاتورة')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>تفاصيل قالب الفاتورة</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('invoice-templates.index') }}">قوالب الفواتير</a></li>
                    <li class="breadcrumb-item active">تفاصيل القالب</li>
                </ol>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">معلومات قالب الفاتورة</h3>
                        <div class="card-tools">
                            <a href="{{ route('invoice-templates.edit', $template->id) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-edit"></i> تعديل
                            </a>
                            <a href="{{ route('invoice-templates.preview', $template->id) }}" class="btn btn-info btn-sm" target="_blank">
                                <i class="fas fa-eye"></i> معاينة
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>اسم القالب:</label>
                                    <p>{{ $template->name }}</p>
                                </div>
                                <div class="form-group">
                                    <label>اللغة:</label>
                                    <p>{{ $template->language == 'ar' ? 'العربية' : 'الإنجليزية' }}</p>
                                </div>
                                <div class="form-group">
                                    <label>الحالة:</label>
                                    <p>
                                        @if($template->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </p>
                                </div>
                                <div class="form-group">
                                    <label>قالب افتراضي:</label>
                                    <p>
                                        @if($template->is_default)
                                            <span class="badge badge-primary">نعم</span>
                                        @else
                                            <span class="badge badge-secondary">لا</span>
                                        @endif
                                    </p>
                                </div>
                                <div class="form-group">
                                    <label>تاريخ الإنشاء:</label>
                                    <p>{{ $template->created_at->format('Y-m-d H:i') }}</p>
                                </div>
                                <div class="form-group">
                                    <label>آخر تحديث:</label>
                                    <p>{{ $template->updated_at->format('Y-m-d H:i') }}</p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>ترويسة القالب (HTML):</label>
                                    <div class="border p-2 bg-light">
                                        <pre class="mb-0" style="white-space: pre-wrap;">{{ $template->header_html }}</pre>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>تذييل القالب (HTML):</label>
                                    <div class="border p-2 bg-light">
                                        <pre class="mb-0" style="white-space: pre-wrap;">{{ $template->footer_html }}</pre>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>أنماط CSS:</label>
                                    <div class="border p-2 bg-light">
                                        <pre class="mb-0" style="white-space: pre-wrap;">{{ $template->css_styles }}</pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <a href="{{ route('invoice-templates.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة إلى القائمة
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection