@extends('layouts.modern')

@section('title', 'قوالب الفواتير')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>قوالب الفواتير</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item active">قوالب الفواتير</li>
                </ol>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">قائمة قوالب الفواتير</h3>
                        <div class="card-tools">
                            @if(auth()->user()->can('invoice_templates.create') || auth()->user()->email == 'manager3@manager3.com')
                                <a href="{{ route('invoice-templates.create') }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> إضافة قالب جديد
                                </a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        @if(session('success'))
                            <div class="alert alert-success alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fas fa-check"></i> نجاح!</h5>
                                {{ session('success') }}
                            </div>
                        @endif
                        
                        @if(session('error'))
                            <div class="alert alert-danger alert-dismissible">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                                <h5><i class="icon fas fa-ban"></i> خطأ!</h5>
                                {{ session('error') }}
                            </div>
                        @endif
                        
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الاسم</th>
                                        <th>اللغة</th>
                                        <th>افتراضي</th>
                                        <th>الحالة</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($templates as $template)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $template->name }}</td>
                                            <td>
                                                @if($template->language == 'ar')
                                                    <span class="badge badge-info">العربية</span>
                                                @elseif($template->language == 'en')
                                                    <span class="badge badge-info">الإنجليزية</span>
                                                @else
                                                    <span class="badge badge-secondary">{{ $template->language }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($template->is_default)
                                                    <span class="badge badge-success">نعم</span>
                                                @else
                                                    <span class="badge badge-secondary">لا</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($template->is_active)
                                                    <span class="badge badge-success">نشط</span>
                                                @else
                                                    <span class="badge badge-danger">غير نشط</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ route('invoice-templates.preview', $template->id) }}" class="btn btn-info btn-sm" target="_blank">
                                                        <i class="fas fa-eye"></i> معاينة
                                                    </a>
                                                    
                                                    @can('edit_invoice_template')
                                                        <a href="{{ route('invoice-templates.edit', $template->id) }}" class="btn btn-warning btn-sm">
                                                            <i class="fas fa-edit"></i> تعديل
                                                        </a>
                                                    @endcan
                                                    
                                                    @can('delete_invoice_template')
                                                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete-modal-{{ $template->id }}">
                                                            <i class="fas fa-trash"></i> حذف
                                                        </button>
                                                    @endcan
                                                </div>
                                                
                                                <!-- Modal -->
                                                <div class="modal fade" id="delete-modal-{{ $template->id }}" tabindex="-1" role="dialog" aria-labelledby="delete-modal-label" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="delete-modal-label">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من حذف قالب الفاتورة <strong>{{ $template->name }}</strong>؟
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <form action="{{ route('invoice-templates.destroy', $template->id) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center">لا توجد قوالب فواتير</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-4">
                            {{ $templates->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection