@extends('layouts.modern')

@section('title', 'تعديل قالب الفاتورة')

@section('content_header')
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>تعديل قالب الفاتورة</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('invoice-templates.index') }}">قوالب الفواتير</a></li>
                    <li class="breadcrumb-item active">تعديل قالب</li>
                </ol>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">بيانات قالب الفاتورة</h3>
                    </div>
                    <form action="{{ route('invoice-templates.update', $template->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <div class="form-group">
                                <label for="name">اسم القالب <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $template->name) }}" required>
                                @error('name')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="language">لغة القالب <span class="text-danger">*</span></label>
                                <select class="form-control @error('language') is-invalid @enderror" id="language" name="language" required>
                                    <option value="ar" {{ old('language', $template->language) == 'ar' ? 'selected' : '' }}>العربية</option>
                                    <option value="en" {{ old('language', $template->language) == 'en' ? 'selected' : '' }}>الإنجليزية</option>
                                </select>
                                @error('language')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="header_html">ترويسة القالب (HTML)</label>
                                <textarea class="form-control @error('header_html') is-invalid @enderror" id="header_html" name="header_html" rows="5">{{ old('header_html', $template->header_html) }}</textarea>
                                @error('header_html')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">يمكنك استخدام HTML لتنسيق ترويسة الفاتورة.</small>
                            </div>

                            <div class="form-group">
                                <label for="footer_html">تذييل القالب (HTML)</label>
                                <textarea class="form-control @error('footer_html') is-invalid @enderror" id="footer_html" name="footer_html" rows="5">{{ old('footer_html', $template->footer_html) }}</textarea>
                                @error('footer_html')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">يمكنك استخدام HTML لتنسيق تذييل الفاتورة.</small>
                            </div>

                            <div class="form-group">
                                <label for="css_styles">أنماط CSS</label>
                                <textarea class="form-control @error('css_styles') is-invalid @enderror" id="css_styles" name="css_styles" rows="5">{{ old('css_styles', $template->css_styles) }}</textarea>
                                @error('css_styles')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="form-text text-muted">يمكنك استخدام CSS لتنسيق مظهر الفاتورة.</small>
                            </div>

                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="is_default" name="is_default" value="1" {{ old('is_default', $template->is_default) ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="is_default">قالب افتراضي</label>
                                </div>
                                <small class="form-text text-muted">إذا تم تحديد هذا الخيار، سيتم استخدام هذا القالب افتراضيًا للفواتير الجديدة باللغة المحددة.</small>
                            </div>

                            <div class="form-group">
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', $template->is_active) ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="is_active">نشط</label>
                                </div>
                                <small class="form-text text-muted">إذا تم إلغاء تحديد هذا الخيار، لن يكون القالب متاحًا للاستخدام في الفواتير الجديدة.</small>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                            <a href="{{ route('invoice-templates.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    $(function() {
        // يمكن إضافة محرر نصوص متقدم هنا إذا كان مطلوبًا
        // مثال: CKEDITOR.replace('header_html');
    });
</script>
@endpush