@extends('layouts.modern')

@section('title', 'تقرير الأقساط المستحقة قريباً')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقرير الأقساط المستحقة قريباً</h3>
                    <div class="card-tools">
                        <a href="{{ route('invoice-installments.dashboard') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-tachometer-alt ml-1"></i> لوحة معلومات الأقساط
                        </a>
                        <a href="{{ route('invoice-installments.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-list ml-1"></i> قائمة الأقساط
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- إحصائيات الأقساط المستحقة قريباً -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-clock"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">عدد الأقساط المستحقة خلال 30 يوم</span>
                                    <span class="info-box-number">{{ $stats['count'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-money-bill-wave"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي المبالغ المستحقة</span>
                                    <span class="info-box-number">{{ number_format($stats['total_amount'], 2) }} ريال</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول الأقساط المستحقة قريباً -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>رقم القسط</th>
                                    <th>العميل</th>
                                    <th>رقم الفاتورة</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>المبلغ</th>
                                    <th>المبلغ المدفوع</th>
                                    <th>المبلغ المتبقي</th>
                                    <th>الأيام المتبقية</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($upcomingInstallments as $installment)
                                    <tr>
                                        <td>{{ $installment->id }}</td>
                                        <td>
                                            <a href="{{ route('customers.show', $installment->invoice->customer_id) }}">
                                                {{ $installment->invoice->customer->name }}
                                            </a>
                                        </td>
                                        <td>
                                            <a href="{{ route('invoices.show', $installment->invoice_id) }}">
                                                {{ $installment->invoice->invoice_number }}
                                            </a>
                                        </td>
                                        <td>{{ $installment->due_date->format('Y-m-d') }}</td>
                                        <td>{{ number_format($installment->amount, 2) }} ريال</td>
                                        <td>{{ number_format($installment->paid_amount, 2) }} ريال</td>
                                        <td>{{ number_format($installment->amount - $installment->paid_amount, 2) }} ريال</td>
                                        <td>{{ $installment->getDaysRemainingOrOverdue() }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('invoice-installments.show', $installment->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('invoice-installments.edit', $installment->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#paymentModal{{ $installment->id }}">
                                                    <i class="fas fa-money-bill"></i>
                                                </button>
                                                <form action="{{ route('invoice-installments.send-reminder', $installment->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-warning" onclick="return confirm('هل أنت متأكد من إرسال تذكير للعميل؟')">
                                                        <i class="fas fa-bell"></i>
                                                    </button>
                                                </form>
                                            </div>
                                            
                                            <!-- نافذة تسجيل الدفعة -->
                                            <div class="modal fade" id="paymentModal{{ $installment->id }}" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel{{ $installment->id }}" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="paymentModalLabel{{ $installment->id }}">تسجيل دفعة للقسط #{{ $installment->id }}</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <form action="{{ route('invoice-installments.record-payment', $installment->id) }}" method="POST">
                                                            @csrf
                                                            <div class="modal-body">
                                                                <div class="form-group">
                                                                    <label for="amount">المبلغ</label>
                                                                    <input type="number" name="amount" id="amount" class="form-control" step="0.01" min="0.01" max="{{ $installment->amount - $installment->paid_amount }}" value="{{ $installment->amount - $installment->paid_amount }}" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="payment_date">تاريخ الدفع</label>
                                                                    <input type="date" name="payment_date" id="payment_date" class="form-control" value="{{ date('Y-m-d') }}" required>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="payment_method_id">طريقة الدفع</label>
                                                                    <select name="payment_method_id" id="payment_method_id" class="form-control" required>
                                                                        @foreach(\App\Models\PaymentMethod::where('company_id', auth()->user()->company_id)->where('is_active', true)->get() as $method)
                                                                            <option value="{{ $method->id }}">{{ $method->name }}</option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="reference_number">رقم المرجع</label>
                                                                    <input type="text" name="reference_number" id="reference_number" class="form-control">
                                                                </div>
                                                                <div class="form-group">
                                                                    <label for="notes">ملاحظات</label>
                                                                    <textarea name="notes" id="notes" class="form-control" rows="3"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-success">تسجيل الدفعة</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد أقساط مستحقة خلال الـ 30 يوم القادمة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- ترقيم الصفحات -->
                    <div class="mt-4">
                        {{ $upcomingInstallments->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection